/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.SiteBuildOperation;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.site.ArchivePage;
import org.eclipse.pde.internal.ui.editor.site.FeaturesPage;
import org.eclipse.pde.internal.ui.editor.site.SiteInputContext;
import org.eclipse.pde.internal.ui.editor.site.SiteInputContextManager;
import org.eclipse.pde.internal.ui.editor.site.SiteOutlinePage;
import org.eclipse.pde.internal.ui.editor.site.SiteSourcePage;
import org.eclipse.pde.internal.ui.editor.site.SiteUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SiteEditor
extends MultiSourceEditor {
    private Action fBuildAllAction;

    @Override
    protected String getEditorID() {
        return "org.eclipse.pde.ui.siteEditor";
    }

    @Override
    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        IFile siteFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("site.xml")) {
            siteFile = file;
            if (siteFile.exists()) {
                FileEditorInput in = new FileEditorInput(siteFile);
                manager.putContext((IEditorInput)in, new SiteInputContext(this, (IEditorInput)in, file == siteFile));
            }
            manager.monitorFile(siteFile);
        }
    }

    @Override
    protected InputContextManager createInputContextManager() {
        SiteInputContextManager contextManager = new SiteInputContextManager(this);
        contextManager.setUndoManager(new SiteUndoManager(this));
        return contextManager;
    }

    @Override
    public void monitoredFileAdded(IFile file) {
    }

    @Override
    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    @Override
    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    @Override
    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    @Override
    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        File file = new File(input.getURI());
        File siteFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("site.xml") && (siteFile = file).exists()) {
            try {
                IFileStore store = EFS.getStore((URI)siteFile.toURI());
                FileStoreEditorInput in = new FileStoreEditorInput(store);
                manager.putContext((IEditorInput)in, new SiteInputContext(this, (IEditorInput)in, file == siteFile));
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        String name = input.getName().toLowerCase(Locale.ENGLISH);
        if (name.startsWith("site.xml")) {
            manager.putContext((IEditorInput)input, new SiteInputContext(this, (IEditorInput)input, true));
        }
    }

    @Override
    protected void contextMenuAboutToShow(IMenuManager manager) {
        super.contextMenuAboutToShow(manager);
    }

    @Override
    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new FeaturesPage(this));
            this.addPage((IFormPage)new ArchivePage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("site-context");
    }

    @Override
    protected String computeInitialPageId() {
        return "features";
    }

    @Override
    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new SiteSourcePage(editor, title, name);
    }

    @Override
    protected ISortableContentOutlinePage createContentOutline() {
        return new SiteOutlinePage(this);
    }

    @Override
    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof ISiteObject) {
            context = this.fInputContextManager.findContext("site-context");
        }
        return context;
    }

    @Override
    public void contributeToToolbar(IToolBarManager manager) {
        manager.add((IAction)this.getBuildAllAction());
    }

    protected Action getBuildAllAction() {
        if (this.fBuildAllAction == null) {
            this.fBuildAllAction = new Action(){

                public void run() {
                    ISiteModel model = (ISiteModel)SiteEditor.this.getAggregateModel();
                    if (model != null) {
                        SiteEditor.this.handleBuild(model.getSite().getFeatures());
                    }
                }
            };
            this.fBuildAllAction.setToolTipText(PDEUIMessages.CategorySection_buildAll);
            this.fBuildAllAction.setImageDescriptor(PDEPluginImages.DESC_BUILD_TOOL);
            this.updateActionEnablement();
            ISiteModel model = (ISiteModel)this.getAggregateModel();
            if (model != null) {
                model.addModelChangedListener(event -> this.updateActionEnablement());
            }
        }
        return this.fBuildAllAction;
    }

    private void updateActionEnablement() {
        if (((ISiteModel)this.getAggregateModel()).getSite().getFeatures().length > 0) {
            this.fBuildAllAction.setEnabled(true);
        } else {
            this.fBuildAllAction.setEnabled(false);
        }
    }

    protected void handleBuild(ISiteFeature[] sFeatures) {
        if (sFeatures.length == 0) {
            return;
        }
        IFeatureModel[] models = this.getFeatureModels(sFeatures);
        if (models.length == 0) {
            return;
        }
        this.ensureContentSaved();
        IModel model = (IModel)this.getAggregateModel();
        if (model == null) {
            return;
        }
        WorkspaceSiteModel buildSiteModel = new WorkspaceSiteModel((IFile)model.getUnderlyingResource());
        try {
            buildSiteModel.load();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return;
        }
        SiteBuildOperation job = new SiteBuildOperation(models, (ISiteModel)buildSiteModel, PDEUIMessages.BuildSiteJob_name);
        job.setUser(true);
        job.schedule();
    }

    private IFeatureModel[] getFeatureModels(ISiteFeature[] sFeatures) {
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        ISiteFeature[] iSiteFeatureArray = sFeatures;
        int n = sFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature siteFeature = iSiteFeatureArray[n2];
            IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(siteFeature.getId(), siteFeature.getVersion());
            if (model != null) {
                list.add(model);
            }
            ++n2;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private void ensureContentSaved() {
        if (this.isDirty()) {
            try {
                IRunnableWithProgress op = monitor -> this.doSave(monitor);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

