/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Objects;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.AbstractAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.commands.RadioState;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.jface.menus.TextState;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandImageService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;

public final class CommandLegacyActionWrapper
extends AbstractAction {
    private ParameterizedCommand command;
    private final ICommandListener commandListener = new CommandListener();
    private boolean enabled = true;
    private String id;
    private final IServiceLocator serviceLocator;
    private final String style;

    public CommandLegacyActionWrapper(String id, ParameterizedCommand command, String style, IServiceLocator serviceLocator) {
        if (command == null) {
            throw new NullPointerException("An action proxy can't be created without a command");
        }
        if (serviceLocator == null) {
            throw new NullPointerException("An action proxy can't be created without a service locator");
        }
        this.command = command;
        this.id = id;
        this.style = style;
        this.serviceLocator = serviceLocator;
        command.getCommand().addCommandListener(this.commandListener);
    }

    public int getAccelerator() {
        KeySequence keySequence;
        KeyStroke[] keyStrokes;
        String commandId = this.getActionDefinitionId();
        IBindingService bindingService = this.serviceLocator.getService(IBindingService.class);
        TriggerSequence triggerSequence = bindingService.getBestActiveBindingFor(commandId);
        if (triggerSequence instanceof KeySequence && (keyStrokes = (keySequence = (KeySequence)triggerSequence).getKeyStrokes()).length == 1) {
            KeyStroke keyStroke = keyStrokes[0];
            return keyStroke.getModifierKeys() | keyStroke.getNaturalKey();
        }
        return 0;
    }

    public String getActionDefinitionId() {
        return this.command.getId();
    }

    public String getDescription() {
        try {
            return this.command.getCommand().getDescription();
        }
        catch (NotDefinedException notDefinedException) {
            return null;
        }
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        String commandId = this.getActionDefinitionId();
        ICommandImageService commandImageService = this.serviceLocator.getService(ICommandImageService.class);
        return commandImageService.getImageDescriptor(commandId, 1, this.style);
    }

    public HelpListener getHelpListener() {
        return null;
    }

    public ImageDescriptor getHoverImageDescriptor() {
        String commandId = this.getActionDefinitionId();
        ICommandImageService commandImageService = this.serviceLocator.getService(ICommandImageService.class);
        return commandImageService.getImageDescriptor(commandId, 2, this.style);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        String commandId = this.getActionDefinitionId();
        ICommandImageService commandImageService = this.serviceLocator.getService(ICommandImageService.class);
        return commandImageService.getImageDescriptor(commandId, this.style);
    }

    public IMenuCreator getMenuCreator() {
        return null;
    }

    public int getStyle() {
        State state = this.command.getCommand().getState("STYLE");
        if (state instanceof RadioState) {
            return 8;
        }
        if (state instanceof ToggleState) {
            return 2;
        }
        return 1;
    }

    public String getText() {
        try {
            return this.command.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return null;
        }
    }

    public String getToolTipText() {
        return this.getDescription();
    }

    public boolean isChecked() {
        State state = this.command.getCommand().getState("STYLE");
        if (state instanceof ToggleState) {
            Boolean currentValue = (Boolean)state.getValue();
            return currentValue;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabledDisregardingCommand();
    }

    public boolean isEnabledDisregardingCommand() {
        return this.enabled;
    }

    public boolean isHandled() {
        Command baseCommand = this.command.getCommand();
        return baseCommand.isHandled();
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        Command baseCommand = this.command.getCommand();
        ExecutionEvent executionEvent = new ExecutionEvent(this.command.getCommand(), this.command.getParameterMap(), (Object)event, null);
        try {
            baseCommand.execute(executionEvent);
            this.firePropertyChange("result", null, Boolean.TRUE);
        }
        catch (NotHandledException notHandledException) {
            this.firePropertyChange("result", null, Boolean.FALSE);
        }
        catch (ExecutionException executionException) {
            this.firePropertyChange("result", null, Boolean.FALSE);
        }
    }

    public void setAccelerator(int keycode) {
    }

    public void setActionDefinitionId(String id) {
        boolean oldChecked = this.isChecked();
        String oldDescription = this.getDescription();
        boolean oldEnabled = this.isEnabled();
        boolean oldHandled = this.isHandled();
        ImageDescriptor oldDefaultImage = this.getImageDescriptor();
        ImageDescriptor oldDisabledImage = this.getDisabledImageDescriptor();
        ImageDescriptor oldHoverImage = this.getHoverImageDescriptor();
        String oldText = this.getText();
        Command oldBaseCommand = this.command.getCommand();
        oldBaseCommand.removeCommandListener(this.commandListener);
        ICommandService commandService = this.serviceLocator.getService(ICommandService.class);
        Command newBaseCommand = commandService.getCommand(id);
        this.command = new ParameterizedCommand(newBaseCommand, null);
        newBaseCommand.addCommandListener(this.commandListener);
        boolean newChecked = this.isChecked();
        String newDescription = this.getDescription();
        boolean newEnabled = this.isEnabled();
        boolean newHandled = this.isHandled();
        ImageDescriptor newDefaultImage = this.getImageDescriptor();
        ImageDescriptor newDisabledImage = this.getDisabledImageDescriptor();
        ImageDescriptor newHoverImage = this.getHoverImageDescriptor();
        String newText = this.getText();
        if (newChecked != oldChecked) {
            if (oldChecked) {
                this.firePropertyChange("checked", Boolean.TRUE, Boolean.FALSE);
            } else {
                this.firePropertyChange("checked", Boolean.FALSE, Boolean.TRUE);
            }
        }
        if (!Objects.equals(oldDescription, newDescription)) {
            this.firePropertyChange("description", oldDescription, newDescription);
            this.firePropertyChange("toolTipText", oldDescription, newDescription);
        }
        if (newEnabled != oldEnabled) {
            if (oldEnabled) {
                this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
            } else {
                this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
            }
        }
        if (newHandled != oldHandled) {
            if (oldHandled) {
                this.firePropertyChange("handled", Boolean.TRUE, Boolean.FALSE);
            } else {
                this.firePropertyChange("handled", Boolean.FALSE, Boolean.TRUE);
            }
        }
        if (!Objects.equals(oldDefaultImage, newDefaultImage)) {
            this.firePropertyChange("image", oldDefaultImage, newDefaultImage);
        }
        if (!Objects.equals(oldDisabledImage, newDisabledImage)) {
            this.firePropertyChange("image", oldDisabledImage, newDisabledImage);
        }
        if (!Objects.equals(oldHoverImage, newHoverImage)) {
            this.firePropertyChange("image", oldHoverImage, newHoverImage);
        }
        if (!Objects.equals(oldText, newText)) {
            this.firePropertyChange("text", oldText, newText);
        }
    }

    public void setChecked(boolean checked) {
        Boolean currentValue;
        State state = this.command.getCommand().getState("STYLE");
        if (state instanceof ToggleState && checked != (currentValue = (Boolean)state.getValue())) {
            if (checked) {
                state.setValue((Object)Boolean.TRUE);
            } else {
                state.setValue((Object)Boolean.FALSE);
            }
        }
    }

    public void setDescription(String text) {
        String currentValue;
        State state = this.command.getCommand().getState("DESCRIPTION");
        if (state instanceof TextState && !Objects.equals(text, currentValue = (String)state.getValue())) {
            state.setValue((Object)text);
        }
    }

    public void setDisabledImageDescriptor(ImageDescriptor newImage) {
        String commandId = this.getActionDefinitionId();
        ICommandImageService commandImageService = this.serviceLocator.getService(ICommandImageService.class);
        if (commandImageService instanceof CommandImageService) {
            ((CommandImageService)commandImageService).bind(commandId, 1, this.style, newImage);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            Boolean oldValue = this.enabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newValue = enabled ? Boolean.TRUE : Boolean.FALSE;
            this.enabled = enabled;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    public void setHelpListener(HelpListener listener) {
    }

    public void setHoverImageDescriptor(ImageDescriptor newImage) {
        String commandId = this.getActionDefinitionId();
        ICommandImageService commandImageService = this.serviceLocator.getService(ICommandImageService.class);
        if (commandImageService instanceof CommandImageService) {
            ((CommandImageService)commandImageService).bind(commandId, 2, this.style, newImage);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImageDescriptor(ImageDescriptor newImage) {
        String commandId = this.getActionDefinitionId();
        ICommandImageService commandImageService = this.serviceLocator.getService(ICommandImageService.class);
        if (commandImageService instanceof CommandImageService) {
            ((CommandImageService)commandImageService).bind(commandId, 0, this.style, newImage);
        }
    }

    public void setMenuCreator(IMenuCreator creator) {
    }

    public void setText(String text) {
        String currentValue;
        State state = this.command.getCommand().getState("NAME");
        if (state instanceof TextState && !Objects.equals(text, currentValue = (String)state.getValue())) {
            state.setValue((Object)text);
        }
    }

    public void setToolTipText(String text) {
        this.setDescription(text);
    }

    private final class CommandListener
    implements ICommandListener {
        private CommandListener() {
        }

        public void commandChanged(CommandEvent commandEvent) {
            Command baseCommand = commandEvent.getCommand();
            if (commandEvent.isNameChanged()) {
                String newName = null;
                if (baseCommand.isDefined()) {
                    try {
                        newName = baseCommand.getName();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                CommandLegacyActionWrapper.this.firePropertyChange("text", null, newName);
            }
            if (commandEvent.isDescriptionChanged()) {
                String newDescription = null;
                if (baseCommand.isDefined()) {
                    try {
                        newDescription = baseCommand.getDescription();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                CommandLegacyActionWrapper.this.firePropertyChange("description", null, newDescription);
                CommandLegacyActionWrapper.this.firePropertyChange("toolTipText", null, newDescription);
            }
            if (commandEvent.isHandledChanged()) {
                if (baseCommand.isHandled()) {
                    CommandLegacyActionWrapper.this.firePropertyChange("handled", Boolean.FALSE, Boolean.TRUE);
                } else {
                    CommandLegacyActionWrapper.this.firePropertyChange("handled", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }
    }
}

