/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.JUnitLauncherTask;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.NamedTest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestRequest;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public class SingleTestClass
extends TestDefinition
implements NamedTest {
    private String testClass;
    private Set<String> testMethods;

    public void setName(String test) {
        if (test == null || test.trim().isEmpty()) {
            throw new IllegalArgumentException("Test name cannot be null or empty string");
        }
        this.testClass = test;
    }

    @Override
    public String getName() {
        return this.testClass;
    }

    public void setMethods(String methods) {
        if (methods == null || methods.trim().isEmpty()) {
            this.testMethods = Collections.emptySet();
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(methods, ",");
        if (!tokenizer.hasMoreTokens()) {
            this.testMethods = Collections.emptySet();
            return;
        }
        this.testMethods = new LinkedHashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String method = tokenizer.nextToken().trim();
            if (method.isEmpty()) continue;
            this.testMethods.add(method);
        }
    }

    boolean hasMethodsSpecified() {
        return this.testMethods != null && !this.testMethods.isEmpty();
    }

    String[] getMethods() {
        if (!this.hasMethodsSpecified()) {
            return null;
        }
        return this.testMethods.toArray(new String[this.testMethods.size()]);
    }

    @Override
    List<TestRequest> createTestRequests(JUnitLauncherTask launcherTask) {
        String[] enginesToExclude;
        Project project = launcherTask.getProject();
        if (!this.shouldRun(project)) {
            launcherTask.log("Excluding test " + this.testClass + " since it's considered not to run in context of project " + project, 4);
            return Collections.emptyList();
        }
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
        if (!this.hasMethodsSpecified()) {
            requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)this.testClass)});
        } else {
            String[] methods;
            for (String method : methods = this.getMethods()) {
                requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod((String)this.testClass, (String)method)});
            }
        }
        String[] enginesToInclude = this.getIncludeEngines();
        if (enginesToInclude != null && enginesToInclude.length > 0) {
            requestBuilder.filters(new Filter[]{EngineFilter.includeEngines((String[])enginesToInclude)});
        }
        if ((enginesToExclude = this.getExcludeEngines()) != null && enginesToExclude.length > 0) {
            requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines((String[])enginesToExclude)});
        }
        return Collections.singletonList(new TestRequest(this, requestBuilder));
    }
}

