/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

public class ReflectURIHelper
implements URIHelperConstants {
    public URI createResourceURI(Type type) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURI(type, uriBuilder);
        return this.createURI(uriBuilder);
    }

    public URI createResourceURI(String withoutProtocol) {
        StringBuilder uriBuilder = new StringBuilder("java".length() + 1 + withoutProtocol.length());
        uriBuilder.append("java").append(":").append(withoutProtocol);
        return this.createURI(uriBuilder);
    }

    private StringBuilder createURIBuilder() {
        StringBuilder builder = new StringBuilder(48);
        builder.append("java");
        builder.append(':');
        return builder;
    }

    private URI createURI(StringBuilder uriBuilder) {
        return URI.createURI((String)uriBuilder.toString());
    }

    URI getFullURI(Type type) {
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURI(type, uriBuilder);
        uriBuilder.append('#');
        this.createFragment(type, uriBuilder);
        return this.createURI(uriBuilder);
    }

    URI getFullURI(Member member) {
        if (member instanceof Type) {
            return this.getFullURI((Type)((Object)member));
        }
        StringBuilder uriBuilder = this.createURIBuilder();
        this.createResourceURI(member.getDeclaringClass(), uriBuilder);
        uriBuilder.append('#');
        this.createFragmentForMember(member, uriBuilder);
        return this.createURI(uriBuilder);
    }

    public String getFragment(Type type) {
        StringBuilder uriBuilder = new StringBuilder(32);
        this.createFragment(type, uriBuilder);
        return uriBuilder.toString();
    }

    private void createFragment(Type type, StringBuilder uriBuilder) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            this.createFragmentForClass(clazz, uriBuilder);
        } else if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            this.createFragmentForTypeVariable(variable, uriBuilder);
        } else if (type instanceof GenericArrayType) {
            this.createFragment(((GenericArrayType)type).getGenericComponentType(), uriBuilder);
            uriBuilder.append("[]");
        } else {
            throw new IllegalStateException("Unexpected type: " + type);
        }
    }

    private void createFragmentForTypeVariable(TypeVariable<?> variable, StringBuilder uriBuilder) {
        Object declaration = variable.getGenericDeclaration();
        if (declaration instanceof Type) {
            Type declaringType = (Type)declaration;
            this.createFragment(declaringType, uriBuilder);
        } else if (declaration instanceof Member) {
            Member member = (Member)declaration;
            this.createFragmentForMember(member, uriBuilder);
        } else {
            throw new IllegalArgumentException(variable + " / " + declaration);
        }
        uriBuilder.append('/');
        uriBuilder.append(variable.getName());
    }

    private void createFragmentForMember(Member member, StringBuilder uriBuilder) {
        Class<?> declaringClass = member.getDeclaringClass();
        this.createFragmentForClass(declaringClass, uriBuilder);
        uriBuilder.append('.');
        if (member instanceof Constructor) {
            uriBuilder.append(declaringClass.getSimpleName());
        } else {
            uriBuilder.append(member.getName());
        }
        if (member instanceof Field) {
            return;
        }
        uriBuilder.append('(');
        Type[] parameterTypes = null;
        if (member instanceof Constructor) {
            parameterTypes = ((Constructor)member).getGenericParameterTypes();
        } else if (member instanceof Method) {
            parameterTypes = ((Method)member).getGenericParameterTypes();
        } else {
            throw new IllegalStateException("unknown member type: " + member);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i != 0) {
                uriBuilder.append(',');
            }
            this.computeTypeName(parameterTypes[i], uriBuilder);
        }
        uriBuilder.append(')');
    }

    String computeTypeName(Type type) {
        StringBuilder result = new StringBuilder(64);
        this.computeTypeName(type, result);
        return result.toString();
    }

    void computeTypeName(Type type, StringBuilder uriBuilder) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                this.computeTypeName(clazz.getComponentType(), uriBuilder);
                uriBuilder.append("[]");
            } else {
                uriBuilder.append(clazz.getName());
            }
        } else if (type instanceof GenericArrayType) {
            this.computeTypeName(((GenericArrayType)type).getGenericComponentType(), uriBuilder);
            uriBuilder.append("[]");
        } else if (type instanceof TypeVariable) {
            uriBuilder.append(((TypeVariable)type).getName());
        } else if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            this.computeTypeName(rawType, uriBuilder);
        } else {
            throw new IllegalStateException("unknown type: " + type);
        }
    }

    String computeParameterizedTypeName(Type type) {
        StringBuilder result = new StringBuilder(64);
        this.computeParameterizedTypeName(type, result);
        return result.toString();
    }

    void computeParameterizedTypeName(Type type, StringBuilder uriBuilder) {
        this.computeTypeName(type, uriBuilder);
        if (type instanceof ParameterizedType) {
            uriBuilder.append('<');
            ParameterizedType parameterized = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterized.getActualTypeArguments();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (i != 0) {
                    uriBuilder.append(',');
                }
                this.computeParameter(actualTypeArguments[i], uriBuilder);
            }
            uriBuilder.append('>');
        }
    }

    void computeParameter(Type type, StringBuilder uriBuilder) {
        if (type instanceof WildcardType) {
            int i;
            WildcardType wildcard = (WildcardType)type;
            boolean wrote = false;
            if (wildcard.getUpperBounds().length != 0) {
                uriBuilder.append("? extends ");
                wrote = true;
                for (i = 0; i < wildcard.getUpperBounds().length; ++i) {
                    if (i != 0) {
                        uriBuilder.append(" & extends ");
                    }
                    Type upperBound = wildcard.getUpperBounds()[i];
                    this.computeParameterizedTypeName(upperBound, uriBuilder);
                }
            }
            if (wildcard.getLowerBounds().length != 0) {
                if (!wrote) {
                    uriBuilder.append("? super ");
                }
                for (i = 0; i < wildcard.getLowerBounds().length; ++i) {
                    if (i != 0 || wrote) {
                        uriBuilder.append(" & super ");
                    }
                    Type lowerBound = wildcard.getLowerBounds()[i];
                    this.computeParameterizedTypeName(lowerBound, uriBuilder);
                }
            }
        } else {
            this.computeParameterizedTypeName(type, uriBuilder);
        }
    }

    private void createFragmentForClass(Class<?> clazz, StringBuilder uriBuilder) {
        if (clazz.isArray()) {
            this.createFragmentForClass(clazz.getComponentType(), uriBuilder);
            uriBuilder.append("[]");
        } else {
            uriBuilder.append(clazz.getName());
        }
    }

    private void createResourceURI(Type type, StringBuilder uriBuilder) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            this.createResourceURIForClass(clazz, uriBuilder);
        } else if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            this.createResourceURIForTypeVariable(variable, uriBuilder);
        } else if (type instanceof GenericArrayType) {
            this.createResourceURI(((GenericArrayType)type).getGenericComponentType(), uriBuilder);
        } else {
            throw new IllegalStateException("unexpected type: " + type);
        }
    }

    private void createResourceURIForTypeVariable(TypeVariable<?> variable, StringBuilder uriBuilder) {
        Object declaration = variable.getGenericDeclaration();
        if (declaration instanceof Class) {
            Class declaringClass = (Class)declaration;
            this.createResourceURIForClass(declaringClass, uriBuilder);
        } else if (declaration instanceof Member) {
            Member member = (Member)declaration;
            Class<?> declaringClass = member.getDeclaringClass();
            this.createResourceURIForClass(declaringClass, uriBuilder);
        } else {
            throw new IllegalArgumentException(variable + " / " + declaration);
        }
    }

    private void createResourceURIForClass(Class<?> clazz, StringBuilder uriBuilder) {
        if (clazz.isArray()) {
            this.createResourceURIForClass(clazz.getComponentType(), uriBuilder);
        } else if (clazz.isMemberClass()) {
            this.createResourceURIForClass(clazz.getDeclaringClass(), uriBuilder);
        } else if (clazz.isPrimitive()) {
            uriBuilder.append("/Primitives");
        } else {
            uriBuilder.append("/Objects/").append(clazz.getName());
        }
    }
}

