/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import com.ibm.icu.math.BigDecimal;
import org.eclipse.birt.chart.util.NumberUtil;

public class BigNumber
extends Number
implements Comparable {
    private static final long serialVersionUID = 1L;
    private BigDecimal value;
    private BigDecimal divisor;
    private double doublePart;

    public BigNumber(String value) {
        this(new BigDecimal(value));
    }

    public BigNumber(BigDecimal value) {
        this(value, null);
    }

    public BigNumber(BigDecimal value, BigDecimal divisor) {
        this.value = value;
        if (divisor != null) {
            this.setDivisor(divisor);
        }
    }

    public void setDivisor(BigDecimal divisor) {
        this.divisor = divisor;
        this.doublePart = this.value.divide(divisor, NumberUtil.DEFAULT_MATHCONTEXT).doubleValue();
        if (Double.isNaN(this.doublePart) || Double.isInfinite(this.doublePart)) {
            this.doublePart = 0.0;
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public double getDouble() {
        return this.doublePart;
    }

    public BigDecimal getDivisor() {
        return this.divisor;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.doublePart;
    }

    public int compareTo(Object o) {
        return this.value.compareTo(((BigNumber)o).getValue());
    }

    public BigNumber min(BigNumber o) {
        return this.compareTo(o) > 0 ? o : this;
    }

    public BigNumber max(BigNumber o) {
        return this.compareTo(o) < 0 ? o : this;
    }

    public BigNumber add(BigNumber num) {
        return new BigNumber(this.value.add(num.getValue(), NumberUtil.DEFAULT_MATHCONTEXT), this.divisor);
    }

    public BigNumber subtract(BigNumber num) {
        return new BigNumber(this.value.subtract(num.getValue(), NumberUtil.DEFAULT_MATHCONTEXT), this.divisor);
    }

    public String toString() {
        return this.value.toString();
    }
}

