/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.trigger.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.DecoratorImpl;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.predicate.Predicate;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.trigger.TriggerList;
import org.eclipse.stem.core.trigger.TriggerPackage;

public class TriggerListImpl
extends DecoratorImpl
implements TriggerList {
    private List<Decorator> actionListCopy;
    protected EList<Predicate> predicateList;
    protected EList<Decorator> actionList;

    protected TriggerListImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TriggerPackage.Literals.TRIGGER_LIST;
    }

    @Override
    public EList<Predicate> getPredicateList() {
        if (this.predicateList == null) {
            this.predicateList = new EObjectContainmentEList(Predicate.class, (InternalEObject)this, 8);
        }
        return this.predicateList;
    }

    @Override
    public EList<Decorator> getActionList() {
        if (this.actionList == null) {
            this.actionList = new EObjectContainmentEList(Decorator.class, (InternalEObject)this, 9);
        }
        return this.actionList;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getPredicateList()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getActionList()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getPredicateList();
            }
            case 9: {
                return this.getActionList();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getPredicateList().clear();
                this.getPredicateList().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getActionList().clear();
                this.getActionList().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getPredicateList().clear();
                return;
            }
            case 9: {
                this.getActionList().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.predicateList != null && !this.predicateList.isEmpty();
            }
            case 9: {
                return this.actionList != null && !this.actionList.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        this.actionListCopy = new ArrayList<Decorator>();
        for (Decorator action : this.getActionList()) {
            Decorator copy = (Decorator)EcoreUtil.copy((EObject)action);
            this.actionListCopy.add(copy);
            this.getGraph().getDecorators().add((Object)copy);
        }
        for (Decorator action : this.actionListCopy) {
            action.setEnabled(false);
        }
        for (Predicate predicate : this.getPredicateList()) {
            predicate.reset();
        }
    }

    @Override
    public void updateLabels(STEMTime time, long timerPeriod, int cycle) {
        try {
            this.resetLabels();
        }
        catch (ScenarioInitializationException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.predicateList.size()) {
            Predicate predicate = (Predicate)this.getPredicateList().get(i);
            if (predicate.evaluate(time, timerPeriod, (Graph)this.eContainer())) {
                Decorator action = this.actionListCopy.get(i);
                action.setEnabled(true);
                if (!action.isGraphDecorated()) {
                    try {
                        action.decorateGraph(time);
                    }
                    catch (ScenarioInitializationException sie) {
                        Scenario s = (Scenario)this.eContainer();
                        Utility.handleException(sie.getErrorMessage(), true, sie);
                    }
                    action.setGraphDecorated(true);
                }
                action.updateLabels(time, timerPeriod, cycle);
            }
            ++i;
        }
    }

    @Override
    public void resetLabels() throws ScenarioInitializationException {
        for (Decorator action : this.actionListCopy) {
            action.setEnabled(false);
            action.setGraphDecorated(false);
            if (!(action instanceof Modifier)) continue;
            ((Modifier)action).resetLabels();
        }
        for (Predicate predicate : this.getPredicateList()) {
            predicate.reset();
        }
    }
}

