/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.widgets.LocationPickerDialog;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class InfectorDefinitionComposite
extends Composite {
    private String isoKey = "";
    private URI targetURI = null;
    private Text numberOfInfectionsText;
    private final Text populationText;
    private final Text diseaseNameText;
    private Label numberOfInfectionsLabel;
    private Label logDirLabel;
    private Text logDirText;
    private String errorMessage;
    private Button[] infectorModeRadioButtons = new Button[2];
    private Button[] importRadioButtons = new Button[2];
    private Button useAbsoluteNumberButton = null;
    private Button usePercentageButton = null;
    private Button locationButton = null;
    private Button[] rowButtons = new Button[3];
    Composite rowComposite = null;
    private Button importFileButton = null;
    private boolean importFromFile = false;
    private boolean useFirstRow = true;
    private boolean useLastRow = false;
    private boolean useSelectedRow = false;
    Text rowtxt = null;
    Label isokeyValueLabel = null;
    private boolean infectorMode = true;
    private boolean percentage = false;
    public IProject currentProject;

    public InfectorDefinitionComposite(Composite parent, int style, final ModifyListener projectValidator, IProject project) {
        super(parent, style);
        this.currentProject = project;
        this.setLayout((Layout)new FormLayout());
        int margin1 = 35;
        int margin2 = 25;
        Composite infectorModeComposite = this.createInfectorModeRadioButtonsComposite(this, projectValidator);
        FormData fd_infectorMode = new FormData();
        fd_infectorMode.top = new FormAttachment(0, 0);
        fd_infectorMode.bottom = new FormAttachment(5, 0);
        fd_infectorMode.left = new FormAttachment(0, 0);
        fd_infectorMode.right = new FormAttachment(100, 0);
        infectorModeComposite.setLayoutData((Object)fd_infectorMode);
        Label diseaseNameLabel = new Label((Composite)this, 0);
        FormData fd_diseaseNameLabel = new FormData();
        fd_diseaseNameLabel.left = new FormAttachment(0, 0);
        fd_diseaseNameLabel.right = new FormAttachment(35, 0);
        fd_diseaseNameLabel.top = new FormAttachment((Control)infectorModeComposite, 5, 1024);
        diseaseNameLabel.setLayoutData((Object)fd_diseaseNameLabel);
        diseaseNameLabel.setText(DiseaseWizardMessages.getString("NInfWizDN"));
        this.diseaseNameText = new Text((Composite)this, 2048);
        this.diseaseNameText.setToolTipText(DiseaseWizardMessages.getString("NInfWizDNTT"));
        this.diseaseNameText.addModifyListener(projectValidator);
        FormData fd_diseaseNameText = new FormData();
        fd_diseaseNameText.left = new FormAttachment((Control)diseaseNameLabel, 0);
        fd_diseaseNameText.right = new FormAttachment(100, 0);
        fd_diseaseNameText.top = new FormAttachment((Control)infectorModeComposite, 5, 1024);
        this.diseaseNameText.setLayoutData((Object)fd_diseaseNameText);
        Label populationLabel = new Label((Composite)this, 0);
        FormData fd_populationLabel = new FormData();
        fd_populationLabel.left = new FormAttachment(0, 0);
        fd_populationLabel.right = new FormAttachment(35, 0);
        fd_populationLabel.top = new FormAttachment((Control)diseaseNameLabel, 5, 1024);
        populationLabel.setLayoutData((Object)fd_populationLabel);
        populationLabel.setText(DiseaseWizardMessages.getString("NInfWizPOP"));
        this.populationText = new Text((Composite)this, 2048);
        this.populationText.setText(StandardPackage.Literals.DISEASE_MODEL__POPULATION_IDENTIFIER.getDefaultValueLiteral());
        this.populationText.setToolTipText(DiseaseWizardMessages.getString("NInfWizPOPTT"));
        this.populationText.addModifyListener(projectValidator);
        FormData fd_populationText = new FormData();
        fd_populationText.top = new FormAttachment((Control)diseaseNameLabel, 5, 1024);
        fd_populationText.left = new FormAttachment((Control)populationLabel, 0);
        fd_populationText.right = new FormAttachment(100, 0);
        this.populationText.setLayoutData((Object)fd_populationText);
        Composite numberPercentInputComposite = this.createNumberPercentInputComposite(this, projectValidator, 35, 25);
        FormData fd_percentMode = new FormData();
        fd_percentMode.top = new FormAttachment((Control)populationLabel, 10, 1024);
        fd_percentMode.left = new FormAttachment(0, 0);
        fd_percentMode.right = new FormAttachment(100, 0);
        numberPercentInputComposite.setLayoutData((Object)fd_percentMode);
        Composite importModeComposite = this.createImportRadioButtonsComposite(this, projectValidator);
        FormData fd_importMode = new FormData();
        fd_importMode.top = new FormAttachment((Control)numberPercentInputComposite, 10, 1024);
        fd_importMode.left = new FormAttachment(0, 0);
        fd_importMode.right = new FormAttachment(100, 0);
        importModeComposite.setLayoutData((Object)fd_importMode);
        this.importFileButton = new Button((Composite)this, 2048);
        this.importFileButton.setText(DiseaseWizardMessages.getString("NInfWizImport"));
        FormData fd_importButton = new FormData();
        fd_importButton.left = new FormAttachment(0, 0);
        fd_importButton.right = new FormAttachment(100, 0);
        fd_importButton.top = new FormAttachment((Control)importModeComposite, 5, 1024);
        this.importFileButton.setLayoutData((Object)fd_importButton);
        this.importFileButton.setEnabled(false);
        this.logDirLabel = new Label((Composite)this, 0);
        this.logDirLabel.setText(DiseaseWizardMessages.getString("NInfWizLogDirLabel"));
        FormData fd_logDirLabel = new FormData();
        fd_logDirLabel.top = new FormAttachment((Control)this.importFileButton, 5, 1024);
        fd_logDirLabel.left = new FormAttachment(0, 0);
        fd_logDirLabel.right = new FormAttachment(35, 0);
        this.logDirLabel.setLayoutData((Object)fd_logDirLabel);
        this.logDirText = new Text((Composite)this, 2048);
        this.logDirText.setText("");
        this.logDirText.setEditable(true);
        this.logDirText.setEnabled(false);
        this.logDirText.addModifyListener(projectValidator);
        FormData fd_logDirText = new FormData();
        fd_logDirText.left = new FormAttachment((Control)this.logDirLabel, 0);
        fd_logDirText.right = new FormAttachment(100, 0);
        fd_logDirText.top = new FormAttachment((Control)this.importFileButton, 5, 1024);
        this.logDirText.setLayoutData((Object)fd_logDirText);
        this.rowComposite = this.createRowRadioButtonsComposite(this, projectValidator);
        FormData fd_row = new FormData();
        fd_row.top = new FormAttachment((Control)this.logDirLabel, 10, 1024);
        fd_row.left = new FormAttachment(0, 0);
        fd_row.right = new FormAttachment(100, 0);
        this.rowComposite.setLayoutData((Object)fd_row);
        this.rowComposite.setEnabled(false);
        final Shell shell = this.getShell();
        this.importFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(DiseaseWizardMessages.getString("NInfWizLogDirDesc"));
                String selected = dd.open();
                InfectorDefinitionComposite.this.logDirText.setText(selected);
                projectValidator.modifyText(null);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newinfectorinoculator_contextid");
    }

    Composite createInfectorModeRadioButtonsComposite(Composite parent, final ModifyListener projectValidator) {
        Composite radioComposite = new Composite(parent, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        radioComposite.setLayout((Layout)fillLayout);
        this.infectorModeRadioButtons[0] = new Button(radioComposite, 16);
        this.infectorModeRadioButtons[0].setSelection(true);
        this.infectorModeRadioButtons[0].setText(DiseaseWizardMessages.getString("NInfectorWiz.infect"));
        this.infectorModeRadioButtons[1] = new Button(radioComposite, 16);
        this.infectorModeRadioButtons[1].setText(DiseaseWizardMessages.getString("NInfectorWiz.inoculate"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == InfectorDefinitionComposite.this.infectorModeRadioButtons[0]) {
                    InfectorDefinitionComposite.this.infectorMode = InfectorDefinitionComposite.this.infectorModeRadioButtons[0].getSelection();
                }
                if (!InfectorDefinitionComposite.this.isPercentage()) {
                    if (InfectorDefinitionComposite.this.isInfectorMode()) {
                        InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizNIINF"));
                    } else {
                        InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizNIINO"));
                    }
                } else if (InfectorDefinitionComposite.this.isInfectorMode()) {
                    InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizPIINF"));
                } else {
                    InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizPIINO"));
                }
                projectValidator.modifyText(null);
            }
        };
        this.infectorModeRadioButtons[0].addListener(13, listener);
        return radioComposite;
    }

    Composite createImportRadioButtonsComposite(Composite parent, final ModifyListener projectValidator) {
        Composite radioComposite = new Composite(parent, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        radioComposite.setLayout((Layout)fillLayout);
        this.importRadioButtons[0] = new Button(radioComposite, 16);
        this.importRadioButtons[0].setSelection(true);
        this.importRadioButtons[0].setText(DiseaseWizardMessages.getString("NInfectorWiz.enter"));
        this.importRadioButtons[1] = new Button(radioComposite, 16);
        this.importRadioButtons[1].setText(DiseaseWizardMessages.getString("NInfectorWiz.import"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == InfectorDefinitionComposite.this.importRadioButtons[0]) {
                    boolean bl = InfectorDefinitionComposite.this.importFromFile = !InfectorDefinitionComposite.this.importRadioButtons[0].getSelection();
                    if (InfectorDefinitionComposite.this.importFromFile) {
                        InfectorDefinitionComposite.this.importFileButton.setEnabled(true);
                        InfectorDefinitionComposite.this.numberOfInfectionsText.setEnabled(false);
                        InfectorDefinitionComposite.this.logDirText.setEnabled(true);
                        InfectorDefinitionComposite.this.rowComposite.setEnabled(true);
                        InfectorDefinitionComposite.this.locationButton.setEnabled(false);
                    } else {
                        InfectorDefinitionComposite.this.importFileButton.setEnabled(false);
                        InfectorDefinitionComposite.this.numberOfInfectionsText.setEnabled(true);
                        InfectorDefinitionComposite.this.logDirText.setEnabled(false);
                        InfectorDefinitionComposite.this.rowComposite.setEnabled(false);
                        InfectorDefinitionComposite.this.locationButton.setEnabled(true);
                    }
                }
                projectValidator.modifyText(null);
            }
        };
        this.importRadioButtons[0].addListener(13, listener);
        return radioComposite;
    }

    Composite createRowRadioButtonsComposite(Composite parent, final ModifyListener projectValidator) {
        Composite radioComposite = new Composite(parent, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        radioComposite.setLayout((Layout)fillLayout);
        this.rowButtons[0] = new Button(radioComposite, 16);
        this.rowButtons[0].setSelection(true);
        this.rowButtons[0].setText(DiseaseWizardMessages.getString("NInfectorWiz.firstrow"));
        this.rowButtons[1] = new Button(radioComposite, 16);
        this.rowButtons[1].setText(DiseaseWizardMessages.getString("NInfectorWiz.lastrow"));
        this.rowButtons[2] = new Button(radioComposite, 16);
        this.rowButtons[2].setText(DiseaseWizardMessages.getString("NInfectorWiz.selectedrow"));
        this.rowtxt = new Text(radioComposite, 0);
        this.rowtxt.setText("0");
        this.rowtxt.setEditable(false);
        this.rowtxt.addModifyListener(projectValidator);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                InfectorDefinitionComposite.this.useFirstRow = InfectorDefinitionComposite.this.rowButtons[0].getSelection();
                InfectorDefinitionComposite.this.useLastRow = InfectorDefinitionComposite.this.rowButtons[1].getSelection();
                InfectorDefinitionComposite.this.useSelectedRow = InfectorDefinitionComposite.this.rowButtons[2].getSelection();
                if (InfectorDefinitionComposite.this.useFirstRow || InfectorDefinitionComposite.this.useLastRow) {
                    InfectorDefinitionComposite.this.rowtxt.setEditable(false);
                } else {
                    InfectorDefinitionComposite.this.rowtxt.setEditable(true);
                }
                projectValidator.modifyText(null);
            }
        };
        this.rowButtons[0].addListener(13, listener);
        this.rowButtons[1].addListener(13, listener);
        this.rowButtons[2].addListener(13, listener);
        return radioComposite;
    }

    Composite createNumberPercentInputComposite(Composite parent, final ModifyListener projectValidator, int margin1, int margin2) {
        Composite radio2Composite = new Composite(parent, 2048);
        radio2Composite.setLayout((Layout)new FormLayout());
        this.useAbsoluteNumberButton = new Button(radio2Composite, 16);
        this.useAbsoluteNumberButton.setSelection(true);
        this.useAbsoluteNumberButton.setText(DiseaseWizardMessages.getString("NInfWiz.absnumber"));
        FormData fd_numberButton = new FormData();
        fd_numberButton.top = new FormAttachment(0, 0);
        fd_numberButton.left = new FormAttachment(0, 0);
        fd_numberButton.right = new FormAttachment(margin1, 0);
        this.useAbsoluteNumberButton.setLayoutData((Object)fd_numberButton);
        this.usePercentageButton = new Button(radio2Composite, 16);
        this.usePercentageButton.setText(DiseaseWizardMessages.getString("NInfWiz.percentage"));
        FormData fd_percentButton = new FormData();
        fd_percentButton.top = new FormAttachment((Control)this.useAbsoluteNumberButton, 0);
        fd_percentButton.left = new FormAttachment(0, 0);
        fd_percentButton.right = new FormAttachment(margin1, 0);
        this.usePercentageButton.setLayoutData((Object)fd_percentButton);
        this.numberOfInfectionsLabel = new Label(radio2Composite, 0);
        this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizNIINF"));
        FormData fd_numberOfInfectionsLabel = new FormData();
        fd_numberOfInfectionsLabel.top = new FormAttachment((Control)this.usePercentageButton, 0);
        fd_numberOfInfectionsLabel.left = new FormAttachment(0, 0);
        fd_numberOfInfectionsLabel.right = new FormAttachment(margin1, 0);
        this.numberOfInfectionsLabel.setLayoutData((Object)fd_numberOfInfectionsLabel);
        this.numberOfInfectionsText = new Text(radio2Composite, 2048);
        this.numberOfInfectionsText.setText(StandardPackage.Literals.SI_INFECTOR__INFECTIOUS_COUNT.getDefaultValueLiteral());
        this.numberOfInfectionsText.setToolTipText(DiseaseWizardMessages.getString("NInfWizNITT"));
        this.numberOfInfectionsText.addModifyListener(projectValidator);
        FormData fd_numberOfInfectionsText = new FormData();
        fd_numberOfInfectionsText.top = new FormAttachment((Control)this.usePercentageButton, 0);
        fd_numberOfInfectionsText.left = new FormAttachment((Control)this.numberOfInfectionsLabel, 0);
        fd_numberOfInfectionsText.right = new FormAttachment(100, 0);
        this.numberOfInfectionsText.setLayoutData((Object)fd_numberOfInfectionsText);
        this.locationButton = new Button(radio2Composite, 0);
        this.locationButton.setText(DiseaseWizardMessages.getString("NInfWizPickLoc"));
        FormData fd_locButton = new FormData();
        fd_locButton.top = new FormAttachment((Control)this.numberOfInfectionsLabel, 0);
        fd_locButton.left = new FormAttachment(0, 0);
        this.locationButton.setLayoutData((Object)fd_locButton);
        Label isoKeyLabel = new Label(radio2Composite, 0);
        isoKeyLabel.setText(DiseaseWizardMessages.getString("NInfWizISOK"));
        FormData fd_isoKeyLabel = new FormData();
        fd_isoKeyLabel.top = new FormAttachment((Control)this.locationButton, 0);
        fd_isoKeyLabel.left = new FormAttachment(0, 0);
        fd_isoKeyLabel.right = new FormAttachment(margin2, 0);
        isoKeyLabel.setLayoutData((Object)fd_isoKeyLabel);
        this.isokeyValueLabel = new Label(radio2Composite, 2048);
        this.isokeyValueLabel.setText(this.isoKey);
        FormData fd_isokeyValueLabel = new FormData();
        fd_isokeyValueLabel.top = new FormAttachment((Control)this.locationButton, 0);
        fd_isokeyValueLabel.left = new FormAttachment((Control)isoKeyLabel, 0);
        fd_isokeyValueLabel.right = new FormAttachment(100, 0);
        this.isokeyValueLabel.setLayoutData((Object)fd_isokeyValueLabel);
        Label spacerLabel = new Label(radio2Composite, 0);
        spacerLabel.setText(" ");
        FormData fd_spacerLabel = new FormData();
        fd_spacerLabel.top = new FormAttachment((Control)isoKeyLabel, 0);
        fd_spacerLabel.left = new FormAttachment(0, 0);
        fd_spacerLabel.right = new FormAttachment(margin2, 0);
        spacerLabel.setLayoutData((Object)fd_spacerLabel);
        this.locationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LocationPickerDialog lpDialog = new LocationPickerDialog(InfectorDefinitionComposite.this.getShell(), 0, DiseaseWizardMessages.getString("NInfWizPickLocTitle"), InfectorDefinitionComposite.this.isoKey, InfectorDefinitionComposite.this.currentProject);
                Object[] ret = lpDialog.open();
                if (ret != null) {
                    InfectorDefinitionComposite.this.isoKey = (String)ret[0];
                    InfectorDefinitionComposite.this.targetURI = (URI)ret[1];
                    InfectorDefinitionComposite.this.isokeyValueLabel.setText(InfectorDefinitionComposite.this.isoKey);
                    projectValidator.modifyText(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == InfectorDefinitionComposite.this.useAbsoluteNumberButton || event.widget == InfectorDefinitionComposite.this.usePercentageButton) {
                    InfectorDefinitionComposite.this.percentage = InfectorDefinitionComposite.this.usePercentageButton.getSelection();
                    if (!InfectorDefinitionComposite.this.percentage) {
                        if (InfectorDefinitionComposite.this.isInfectorMode()) {
                            InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizNIINF"));
                        } else {
                            InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizNIINO"));
                        }
                    } else if (InfectorDefinitionComposite.this.isInfectorMode()) {
                        InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizPIINF"));
                    } else {
                        InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizPIINO"));
                    }
                }
                projectValidator.modifyText(null);
            }
        };
        this.useAbsoluteNumberButton.addListener(13, listener);
        return radio2Composite;
    }

    public boolean validate() {
        File f;
        double temp;
        boolean retValue = true;
        if (this.getDiseaseName() == null || this.getDiseaseName().equals("")) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.1");
            retValue = false;
        }
        if (retValue && (this.getPopulation() == null || this.getPopulation().equals(""))) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.2");
            retValue = false;
        }
        if (!this.importFromFile && retValue && (this.numberOfInfectionsText.getText() == null || this.numberOfInfectionsText.getText().equals(""))) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.3");
            retValue = false;
        }
        if (!this.importFromFile && retValue && (temp = Double.parseDouble(this.numberOfInfectionsText.getText())) < 0.0) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.4");
            retValue = false;
        }
        if (!this.importFromFile && retValue) {
            temp = Double.parseDouble(this.numberOfInfectionsText.getText());
            if (this.isPercentage() && temp > 100.0) {
                this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.8");
                retValue = false;
            }
        }
        if (retValue && !this.isFromFile() && (this.getIsoKey() == null || this.getIsoKey().equals(""))) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.6");
            retValue = false;
        }
        if (retValue && this.isFromFile() && (this.getImportFolder() == null || this.getImportFolder().equals(""))) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.9");
            retValue = false;
        }
        if (retValue && this.isFromFile() && !(f = new File(this.getImportFolder())).exists()) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.10");
            retValue = false;
        }
        if (retValue && this.isFromFile() && this.isSelectedRow()) {
            String val = this.rowtxt.getText();
            try {
                int v = Integer.parseInt(val);
                if (v < 0) {
                    this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.11");
                    retValue = false;
                }
            }
            catch (Exception e) {
                this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.11");
                retValue = false;
            }
        }
        return retValue;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isInfectorMode() {
        return this.infectorMode;
    }

    public boolean isFromFile() {
        return this.importFromFile;
    }

    public String getImportFolder() {
        return this.logDirText.getText();
    }

    public final String getIsoKey() {
        return this.isoKey;
    }

    public final URI getTargetURI() {
        return this.targetURI;
    }

    public final String getLocationName() {
        return this.getIsoKey();
    }

    public final String getDiseaseName() {
        return this.diseaseNameText.getText();
    }

    public final String getPopulation() {
        return this.populationText.getText();
    }

    public double getNumber() {
        try {
            return Double.parseDouble(this.numberOfInfectionsText.getText());
        }
        catch (NumberFormatException e) {
            Activator.logError((String)DiseaseWizardMessages.getString("NInfWizError.7"), (Throwable)e);
            return 0.0;
        }
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public boolean isFirstRow() {
        return this.useFirstRow;
    }

    public boolean isLastRow() {
        return this.useLastRow;
    }

    public boolean isSelectedRow() {
        return this.useSelectedRow;
    }

    public int getSelectecRow() {
        return Integer.parseInt(this.rowtxt.getText());
    }

    public void setProject(IProject p) {
        this.currentProject = p;
    }
}

