/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.versioning;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stem.core.CorePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class VersioningUtil {
    public static final String VERSION_FILE_NAME = ".version";
    public static final Version STEM_VERSION_1 = new Version(1, 0, 0);
    public static final Version STEM_VERSION_2 = new Version(2, 0, 0);

    public static Version getSTEMProjectVersion(IProject project) {
        try {
            if (!project.hasNature("org.eclipse.stem.stemnature")) {
                return null;
            }
        }
        catch (CoreException ce) {
            return null;
        }
        IFile versionFile = project.getFile(VERSION_FILE_NAME);
        if (!versionFile.exists()) {
            return STEM_VERSION_1;
        }
        String versionString = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(versionFile.getContents()));
            versionString = br.readLine();
            br.close();
        }
        catch (IOException ioe) {
            CorePlugin.logError((String)ioe.getMessage(), (Throwable)ioe);
        }
        catch (CoreException ce) {
            return STEM_VERSION_1;
        }
        return new Version(versionString);
    }

    public static void setSTEMProjectVersion(IProject project, String version) {
        try {
            if (!project.hasNature("org.eclipse.stem.stemnature")) {
                return;
            }
        }
        catch (CoreException ce) {
            return;
        }
        IFile newVersionFile = project.getFile(VERSION_FILE_NAME);
        ByteArrayInputStream bais = new ByteArrayInputStream(version.getBytes(Charset.forName("UTF-8")));
        try {
            if (newVersionFile.exists()) {
                newVersionFile.setContents((InputStream)bais, true, false, null);
            } else {
                newVersionFile.create((InputStream)bais, true, null);
            }
        }
        catch (CoreException ce) {
            CorePlugin.logError((String)ce.getMessage(), (Throwable)ce);
        }
    }

    public static Version getSTEMVersion() {
        Bundle thisBundle = CorePlugin.getDefault().getBundle();
        Version STEMVersion = thisBundle.getVersion();
        return STEMVersion;
    }
}

