/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.text.NumberFormatter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.geography.names.GeographicNames;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.RelativeValueColorProvider;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.adapters.color.StandardColorProvider;
import org.eclipse.stem.ui.views.geographic.map.GeographicSelectionElements;
import org.eclipse.stem.ui.views.graphmap.GraphMapControl;
import org.eclipse.stem.ui.views.graphmap.GraphMapPreferences;
import org.eclipse.stem.ui.views.graphmap.GraphMapRegistry;
import org.eclipse.stem.ui.views.graphmap.GraphMapView;
import org.eclipse.stem.ui.views.graphmap.Messages;
import org.eclipse.stem.ui.views.graphmap.StemPolygon;
import org.eclipse.stem.ui.views.graphmap.StemPolygonList;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class GraphMapCanvas
extends Canvas
implements ISelectionProvider,
PaintListener,
MouseWheelListener,
MouseMoveListener,
KeyListener,
DisposeListener,
MouseListener,
MouseTrackListener,
IPropertyChangeListener,
ControlListener {
    public static final double INITIAL_SCALE_FACTOR = 0.99;
    private final double INITIAL_GAIN_FACTOR = 1.0;
    private final double INITIAL_EDGE_GAIN_FACTOR = 1.0;
    private final boolean INITIAL_DRAW_POLYGON_BORDERS = true;
    private final boolean INITIAL_USE_LOG_SCALING = false;
    private final boolean INITIAL_USE_LOG_EDGE_SCALING = false;
    private final boolean INITIAL_ADJUST_EDGE_THICKNESS = false;
    private final boolean INITIAL_SHOW_OPTIONS_VIEW = true;
    private final double ZOOMING_FACTOR = 1.1;
    private final int ARROWHEAD_LENGTH = 10;
    private final int ARROWHEAD_THICKNESS = 10;
    private Label gainScaleLabel;
    private GainFactorAction defaultGainFactorAction;
    private GainFactorAction lastGainFactorAction;
    private EdgeGainFactorAction defaultEdgeGainFactorAction;
    private EdgeGainFactorAction lastEdgeGainFactorAction;
    private LogarithmicAction logarithmicAction;
    private LogarithmicEdgeAction logarithmicEdgeAction;
    private AdjustEdgeThicknessAction adjustEdgeThicknessAction;
    private DrawPolygonBordersAction drawPolygonBordersAction;
    private ToggleOptionsViewAction toggleOptionsViewAction;
    private StemPolygonList polygonsToRender;
    private double gainFactor;
    private double edgeGainFactor;
    private boolean drawPolygonBorders;
    private StandardColorProvider stdColorProvider;
    private ColorProviderAdapter colorProvider;
    private boolean useLogScaling;
    private boolean useLogEdgeScaling;
    private boolean adjustEdgeThickness;
    private boolean leftMouseButtonPressed;
    private boolean initialTransformationComputed;
    private boolean transformationChanged;
    private boolean showOptionsBar;
    private double translationX;
    private double translationY;
    private double scaleFactor;
    private double scaleX;
    private double scaleY;
    private int lastX;
    private int lastY;
    private ISelection selection;
    private List<ISelectionChangedListener> selectionChangedListeners;
    private ISimulation simulation;
    private DefaultToolTip tooltip;
    private Image image;
    private GC imageGC;
    private Image borderImage;
    private StemPolygonList lastNonSquarePolygons;
    private StemPolygonList lastSquarePolygons;
    private List<Color> lastNonSquareColors;
    private List<Color> lastSquareColors;
    private int lastBorderAlpha;
    private Color lastBackgroundColor;
    private Color lastBorderColor;
    private Image canvasImage;
    private volatile GraphMapView view;
    private volatile GraphMapControl ctrl;
    private static String mapPropertyName = "graphMapScaleFactor";
    private PropertyChangeSupport paneChangeSubject;

    public GraphMapCanvas(Composite parent, int style, GraphMapView view) {
        super(parent, 0x20040000);
        this.ctrl = (GraphMapControl)parent;
        this.paneChangeSubject = new PropertyChangeSupport((Object)this){
            private static final long serialVersionUID = -55036425306354436L;
        };
        this.drawPolygonBorders = true;
        this.useLogScaling = false;
        this.useLogEdgeScaling = false;
        this.gainFactor = 1.0;
        this.edgeGainFactor = 1.0;
        this.adjustEdgeThickness = false;
        this.showOptionsBar = true;
        this.addPaintListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMoveListener(this);
        this.addKeyListener(this);
        this.addDisposeListener(this);
        this.addMouseListener(this);
        this.addMouseTrackListener(this);
        this.addControlListener(this);
        this.tooltip = new DefaultToolTip((Control)this);
        this.transformationChanged = false;
        this.leftMouseButtonPressed = false;
        this.initialTransformationComputed = false;
        this.stdColorProvider = new StandardColorProvider((Device)this.getDisplay());
        this.selectionChangedListeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.view = view;
    }

    public void paintControl(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        Color backgroundColor = this.stdColorProvider.getBackgroundColor();
        Color borderColor = this.stdColorProvider.getBordersColor();
        int borderAlpha = this.stdColorProvider.getBordersAlpha();
        Image newCanvasImage = new Image((Device)e.display, rect.width, rect.height);
        GC gc = new GC((Drawable)newCanvasImage);
        gc.setBackground(backgroundColor);
        this.drawBackground(gc, 0, 0, rect.width, rect.height);
        if (this.polygonsToRender == null || this.polygonsToRender.isEmpty()) {
            return;
        }
        StemPolygonList nonSquarePolygons = new StemPolygonList();
        StemPolygonList squarePolygons = new StemPolygonList();
        StemPolygonList nonMigrationEdges = new StemPolygonList();
        StemPolygonList migrationsEdges = new StemPolygonList();
        for (StemPolygon stempoly : this.polygonsToRender) {
            Identifiable id = stempoly.getIdentifiable();
            if (id instanceof Node) {
                if (stempoly.isSquare()) {
                    squarePolygons.add(stempoly);
                    continue;
                }
                nonSquarePolygons.add(stempoly);
                continue;
            }
            if (id instanceof MigrationEdge) {
                migrationsEdges.add(stempoly);
                continue;
            }
            if (!(id instanceof Edge)) continue;
            nonMigrationEdges.add(stempoly);
        }
        if (this.transformationChanged) {
            Rectangle canvasBounds = this.getClientArea();
            int cCX = canvasBounds.x + canvasBounds.width / 2;
            int cCY = canvasBounds.y + canvasBounds.height / 2;
            double relTransX = (double)cCX - this.translationX;
            double relTransY = (double)cCY - this.translationY;
            double[] mapScale = new double[]{this.scaleX, relTransX, relTransY};
            java.beans.PropertyChangeEvent evt = new java.beans.PropertyChangeEvent((Object)this, mapPropertyName, null, mapScale);
            this.paneChangeSubject.firePropertyChange(evt);
            for (StemPolygon stempoly : this.polygonsToRender) {
                stempoly.computeTransformedPoints(this.translationX, this.translationY, this.scaleX, this.scaleY);
            }
        }
        if (this.transformationChanged || !nonSquarePolygons.equals(this.lastNonSquarePolygons) || !squarePolygons.equals(this.lastSquarePolygons) || !backgroundColor.equals((Object)this.lastBackgroundColor)) {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            if (this.borderImage != null) {
                this.borderImage.dispose();
                this.borderImage = null;
            }
        } else if (!(borderAlpha == this.lastBorderAlpha && borderColor.equals((Object)this.lastBorderColor) || this.borderImage == null)) {
            this.borderImage.dispose();
            this.borderImage = null;
        }
        List<Color> nonSquareColors = this.getColors(gc, nonSquarePolygons);
        List<Color> squareColors = this.getColors(gc, squarePolygons);
        if (this.image == null) {
            this.createImage(gc.getDevice(), rect.width, rect.height, nonSquarePolygons, squarePolygons, nonSquareColors, squareColors);
            gc.drawImage(this.image, 0, 0);
        } else {
            this.updateImage(gc.getDevice(), rect.width, rect.height, nonSquarePolygons, squarePolygons, nonSquareColors, squareColors);
            gc.drawImage(this.image, 0, 0);
        }
        if (this.drawPolygonBorders) {
            if (this.borderImage == null) {
                this.computeBorderImage(gc.getDevice(), rect.width, rect.height, nonSquarePolygons, squarePolygons);
            }
            gc.drawImage(this.borderImage, 0, 0);
        }
        for (StemPolygon stempoly : nonMigrationEdges) {
            this.paintEdge(gc, stempoly);
        }
        for (StemPolygon stempoly : migrationsEdges) {
            this.paintMigrationEdge(gc, stempoly);
        }
        gc.setLineWidth(0);
        gc.setForeground(this.getInvertedColor(backgroundColor));
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        e.gc.drawImage(newCanvasImage, 0, 0);
        if (this.canvasImage != null && !this.canvasImage.isDisposed()) {
            this.canvasImage.dispose();
        }
        this.canvasImage = newCanvasImage;
        this.transformationChanged = false;
        this.lastNonSquarePolygons = nonSquarePolygons;
        this.lastSquarePolygons = squarePolygons;
        this.lastNonSquareColors = nonSquareColors;
        this.lastSquareColors = squareColors;
        this.lastBackgroundColor = backgroundColor;
        this.lastBorderAlpha = borderAlpha;
        this.lastBorderColor = borderColor;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (!this.isDisposed()) {
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Rectangle bounds = this.getClientArea();
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        switch (e.keyCode) {
            case 0x1000001: {
                this.zoomIn(centerX, centerY);
                break;
            }
            case 0x1000002: {
                this.zoomOut(centerX, centerY);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        StemPolygon polygon;
        if (e.button == 1 && (polygon = this.getPolygon(e.x, e.y)) != null) {
            GeographicSelectionElements gse = new GeographicSelectionElements();
            Point2D.Double latLongPosition = this.getInversedPoint(e.x, e.y);
            double longitude = latLongPosition.getX();
            double latitude = latLongPosition.getY();
            gse.setPoint(longitude, latitude);
            Identifiable regnImpl = polygon.getIdentifiable();
            Object[] elements = new Object[]{regnImpl, gse};
            StructuredSelection selection = new StructuredSelection(elements);
            this.fireSelection((ISelection)selection);
        }
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.lastX = e.x;
            this.lastY = e.y;
            this.leftMouseButtonPressed = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1) {
            this.leftMouseButtonPressed = false;
        }
    }

    public void mouseScrolled(MouseEvent e) {
        if (e.count >= 0) {
            this.zoomIn(e.x, e.y);
        } else {
            this.zoomOut(e.x, e.y);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.leftMouseButtonPressed) {
            int diffX = e.x - this.lastX;
            int diffY = e.y - this.lastY;
            this.lastX = e.x;
            this.lastY = e.y;
            if (diffX != 0 || diffY != 0) {
                this.translationX += (double)diffX;
                this.translationY += (double)diffY;
                this.transformationChanged = true;
                this.redraw();
            }
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        StemPolygon polygon = this.getPolygon(e.x, e.y);
        if (polygon == null) {
            this.tooltip.setText("No region");
            return;
        }
        String toolTipText = null;
        Identifiable identifiable = polygon.getIdentifiable();
        String dcIdentifier = identifiable.getDublinCore().getIdentifier();
        String isoKey = dcIdentifier.substring(dcIdentifier.lastIndexOf("/") + 1);
        if (isoKey == null || isoKey.equals("")) {
            this.tooltip.setText(polygon.getIdentifiable().getDublinCore().getTitle());
            return;
        }
        boolean retry = true;
        while (retry) {
            try {
                StringBuilder sb = new StringBuilder(GeographicNames.getName((String)isoKey));
                Region region = (Region)identifiable;
                STEMTime time = this.simulation.getScenario().getSequencer().getCurrentTime();
                Point2D.Double latLongPosition = this.getInversedPoint(e.x, e.y);
                sb.append(" (" + isoKey + ")");
                for (NodeLabel nextLabel : region.getLabels()) {
                    if (nextLabel instanceof PopulationModelLabel) {
                        sb.append("\nPopulation (now): " + nextLabel);
                        continue;
                    }
                    if (nextLabel instanceof PopulationLabel) {
                        sb.append("\nPopulation (" + ((PopulationLabel)nextLabel).getValidYear() + "):" + nextLabel);
                        continue;
                    }
                    if (nextLabel instanceof AreaLabel) {
                        sb.append("\nArea: " + nextLabel);
                        continue;
                    }
                    if (!(nextLabel instanceof StandardDiseaseModelLabel)) continue;
                    sb.append("\n" + ((StandardDiseaseModelLabel)nextLabel).toTooltipString());
                }
                sb.append("\nLatitude: " + latLongPosition.y + ", Longitude: " + latLongPosition.x);
                sb.append("\nTime: " + time);
                toolTipText = sb.toString();
                retry = false;
            }
            catch (ConcurrentModificationException cme) {
                retry = true;
            }
        }
        this.tooltip.setText(toolTipText);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.transformationChanged = true;
    }

    public void propertyChange(java.beans.PropertyChangeEvent event) {
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.fireSelection(selection);
    }

    public void addPaneChangeListener(PropertyChangeListener listener) {
        this.paneChangeSubject.addPropertyChangeListener(listener);
    }

    public void removePaneChangeListener(PropertyChangeListener listener) {
        this.paneChangeSubject.removePropertyChangeListener(listener);
    }

    public void dispose() {
        this.removePaintListener(this);
        this.removeMouseWheelListener(this);
        this.removeMouseMoveListener(this);
        this.removeKeyListener(this);
        this.removeDisposeListener(this);
        this.removeMouseListener(this);
        this.removeMouseTrackListener(this);
    }

    public void render(StemPolygonList polygonsToRender, ISimulation sim) {
        this.simulation = sim;
        this.polygonsToRender = polygonsToRender;
        this.updateScaleLogLinLabel();
        if (!this.initialTransformationComputed) {
            this.loadMenuSettings(sim);
            MenuManager menuManager = this.createContextMenuManager();
            this.setMenu(menuManager.createContextMenu((Control)this));
            if (this.computeTransform(true)) {
                this.initialTransformationComputed = true;
            } else {
                this.setMenu(null);
            }
        }
        for (StemPolygon stempoly : polygonsToRender) {
            stempoly.computeTransformedPoints(this.translationX, this.translationY, this.scaleX, this.scaleY);
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void setDrawPolygonBorders(boolean drawPolygonBorders) {
        this.drawPolygonBorders = drawPolygonBorders;
    }

    public void setGainFactor(double gainFactor) {
        this.gainFactor = gainFactor;
    }

    public void setEdgeGainFactor(double edgeGainFactor) {
        this.edgeGainFactor = edgeGainFactor;
    }

    public void setUseLogScaling(boolean useLogScaling) {
        this.useLogScaling = useLogScaling;
    }

    public void setUseLogEdgeScaling(boolean useLogEdgeScaling) {
        this.useLogEdgeScaling = useLogEdgeScaling;
    }

    public void setAdjustEdgeThickness(boolean adjustEdgeThickness) {
        this.adjustEdgeThickness = adjustEdgeThickness;
    }

    public void setColorProvider(ColorProviderAdapter colorProvider) {
        this.colorProvider = colorProvider;
    }

    public void showOptionsBar(boolean show) {
        this.showOptionsBar = show;
        this.ctrl.showOptionsBar(show);
    }

    public void reset() {
        this.lastGainFactorAction.setChecked(false);
        this.defaultGainFactorAction.setChecked(true);
        this.lastEdgeGainFactorAction.setChecked(false);
        this.defaultEdgeGainFactorAction.setChecked(true);
        this.useLogScaling = false;
        this.logarithmicAction.setChecked(this.useLogScaling);
        this.useLogEdgeScaling = false;
        this.logarithmicEdgeAction.setChecked(this.useLogEdgeScaling);
        this.drawPolygonBorders = true;
        this.drawPolygonBordersAction.setChecked(this.drawPolygonBorders);
        this.adjustEdgeThickness = false;
        this.adjustEdgeThicknessAction.setChecked(this.adjustEdgeThickness);
        this.showOptionsBar = true;
        this.toggleOptionsViewAction.setChecked(this.showOptionsBar);
        this.showOptionsBar(this.showOptionsBar);
        this.resetView();
    }

    public void resetView() {
        if (this.simulation == null) {
            return;
        }
        this.initialTransformationComputed = false;
        if (this.computeTransform(false)) {
            this.initialTransformationComputed = true;
        }
        this.transformationChanged = true;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void setGainScaleLabel(Label gainScaleLabel) {
        this.gainScaleLabel = gainScaleLabel;
        this.updateScaleLogLinLabel();
    }

    public Image getCanvasImage() {
        return this.canvasImage;
    }

    private void updateScaleLogLinLabel() {
        String text = "  ";
        if (this.simulation != null) {
            text = String.valueOf(text) + this.simulation.getName() + " | ";
        }
        text = this.useLogScaling ? String.valueOf(text) + Messages.getString("MapMenu.LogScale") + " | " : String.valueOf(text) + Messages.getString("MapMenu.LinScale") + " | ";
        text = String.valueOf(text) + Messages.getString("MapMenu.Gain") + " x" + this.gainFactor;
        this.gainScaleLabel.setText(text);
    }

    private void createImage(Device device, int width, int height, StemPolygonList nonSquarePolygons, StemPolygonList squarePolygons, List<Color> nonSquareColors, List<Color> squareColors) {
        Color backgroundColor = this.stdColorProvider.getBackgroundColor();
        this.image = new Image(device, width, height);
        this.imageGC = new GC((Drawable)this.image);
        this.imageGC.setBackground(backgroundColor);
        this.imageGC.fillRectangle(0, 0, width, height);
        int n1 = nonSquarePolygons.size();
        int n2 = squarePolygons.size();
        int i = 0;
        while (i < n1) {
            if (!nonSquareColors.get(i).equals((Object)backgroundColor)) {
                this.imageGC.setBackground(nonSquareColors.get(i));
                this.imageGC.fillPolygon(((StemPolygon)nonSquarePolygons.get((int)i)).transformedPoints);
            }
            ++i;
        }
        i = 0;
        while (i < n2) {
            this.imageGC.setBackground(squareColors.get(i));
            this.imageGC.fillPolygon(((StemPolygon)squarePolygons.get((int)i)).transformedPoints);
            ++i;
        }
    }

    private void updateImage(Device device, int width, int height, StemPolygonList nonSquarePolygons, StemPolygonList squarePolygons, List<Color> nonSquareColors, List<Color> squareColors) {
        int n1 = nonSquarePolygons.size();
        int n2 = squarePolygons.size();
        boolean nonSquareColorsChanged = false;
        int i = 0;
        while (i < n1) {
            if (!nonSquareColors.get(i).equals((Object)this.lastNonSquareColors.get(i))) {
                this.imageGC.setBackground(nonSquareColors.get(i));
                this.imageGC.fillPolygon(((StemPolygon)nonSquarePolygons.get((int)i)).transformedPoints);
                nonSquareColorsChanged = true;
            }
            ++i;
        }
        if (nonSquareColorsChanged) {
            i = 0;
            while (i < n2) {
                this.imageGC.setBackground(squareColors.get(i));
                this.imageGC.fillPolygon(((StemPolygon)squarePolygons.get((int)i)).transformedPoints);
                ++i;
            }
        } else {
            i = 0;
            while (i < n2) {
                if (!squareColors.get(i).equals((Object)this.lastSquareColors.get(i))) {
                    this.imageGC.setBackground(squareColors.get(i));
                    this.imageGC.fillPolygon(((StemPolygon)squarePolygons.get((int)i)).transformedPoints);
                }
                ++i;
            }
        }
    }

    private void computeBorderImage(Device device, int width, int height, StemPolygonList nonSquarePolygons, StemPolygonList squarePolygons) {
        Color backgroundColor = this.stdColorProvider.getBackgroundColor();
        Color borderColor = this.stdColorProvider.getBordersColor();
        int borderAlpha = this.stdColorProvider.getBordersAlpha();
        Image memImage = new Image(device, width, height);
        GC gc = new GC((Drawable)memImage);
        gc.setBackground(backgroundColor);
        gc.fillRectangle(0, 0, width, height);
        gc.setForeground(borderColor);
        gc.setLineWidth(0);
        for (StemPolygon stempoly : nonSquarePolygons) {
            gc.drawPolygon(stempoly.transformedPoints);
        }
        for (StemPolygon stempoly : squarePolygons) {
            gc.fillPolygon(stempoly.transformedPoints);
        }
        for (StemPolygon stempoly : squarePolygons) {
            gc.drawPolygon(stempoly.transformedPoints);
        }
        ImageData data = memImage.getImageData();
        int back = data.palette.getPixel(backgroundColor.getRGB());
        int[] pixels = new int[width * height];
        int startIndex = 0;
        int y = 0;
        while (y < height) {
            data.getPixels(0, y, width, pixels, startIndex);
            startIndex += width;
            ++y;
        }
        data.alphaData = new byte[width * height];
        int i = 0;
        while (i < width * height) {
            data.alphaData[i] = pixels[i] == back ? (byte)0 : (byte)borderAlpha;
            ++i;
        }
        this.borderImage = new Image(device, data);
        memImage.dispose();
    }

    private List<Color> getColors(GC gc, StemPolygonList polygonList) {
        ArrayList<Color> colors = new ArrayList<Color>(polygonList.size());
        for (StemPolygon stempoly : polygonList) {
            STEMColor stemColor;
            Color backgroundColor = this.stdColorProvider.getBackgroundColor();
            if (Double.isNaN(stempoly.getValueToDisplay())) {
                this.colorProvider.setTarget((Notifier)stempoly.getIdentifiable());
                stemColor = this.colorProvider.getColor((float)this.gainFactor, this.useLogScaling);
            } else {
                double value = Math.min(1.0, stempoly.getValueToDisplay() * this.gainFactor);
                if (this.useLogScaling) {
                    value = Math.log10(value * 9.0 + 1.0);
                }
                stemColor = ((RelativeValueColorProvider)((Object)this.colorProvider)).getColorForRelativeValue(value);
            }
            Color color = stemColor.toSWTColor(gc.getDevice());
            double alpha = stemColor.getAlpha();
            if (alpha == 1.0) {
                colors.add(color);
                continue;
            }
            if (alpha * 255.0 >= 1.0) {
                int r = (int)(alpha * (double)color.getRed() + (1.0 - alpha) * (double)backgroundColor.getRed());
                int g = (int)(alpha * (double)color.getGreen() + (1.0 - alpha) * (double)backgroundColor.getGreen());
                int b = (int)(alpha * (double)color.getBlue() + (1.0 - alpha) * (double)backgroundColor.getBlue());
                colors.add(new Color(gc.getDevice(), r, g, b));
                continue;
            }
            colors.add(backgroundColor);
        }
        return colors;
    }

    private void paintEdge(GC gc, StemPolygon stempoly) {
        gc.setForeground(this.stdColorProvider.getEdgesColor());
        gc.setLineWidth(3);
        gc.drawLine(stempoly.transformedPoints[0], stempoly.transformedPoints[1], stempoly.transformedPoints[2], stempoly.transformedPoints[3]);
    }

    private void paintMigrationEdge(GC gc, StemPolygon stempoly) {
        int thickness = 3;
        if (this.adjustEdgeThickness) {
            double value;
            if (Double.isNaN(stempoly.getValueToDisplay())) {
                MigrationEdge edge = (MigrationEdge)stempoly.getIdentifiable();
                value = edge.getLabel().getCurrentValue().getMigrationRate();
            } else {
                value = stempoly.getValueToDisplay();
            }
            value = Math.min(value * this.edgeGainFactor, 1.0);
            if (this.useLogEdgeScaling) {
                value = Math.log10(value * 9.0 + 1.0);
            }
            thickness = (int)Math.ceil(value * 10.0);
        }
        this.drawArrow(gc, stempoly.transformedPoints[0], stempoly.transformedPoints[1], stempoly.transformedPoints[2], stempoly.transformedPoints[3], thickness);
    }

    private void drawArrow(GC gc, int x1, int y1, int x2, int y2, int thickness) {
        double angle = x1 == x2 && y1 == y2 ? 0.5890486225480862 : Math.atan2(y1 - y2, x1 - x2);
        int arrowHeadThickness = Math.max(10, 2 * thickness);
        int nx = x2 + (int)(10.0 * Math.cos(angle));
        int ny = y2 + (int)(10.0 * Math.sin(angle));
        double orthAngle = angle + 1.5707963267948966;
        int nx1 = nx + (int)((double)arrowHeadThickness / 2.0 * Math.cos(orthAngle));
        int ny1 = ny + (int)((double)arrowHeadThickness / 2.0 * Math.sin(orthAngle));
        int nx2 = nx - (int)((double)arrowHeadThickness / 2.0 * Math.cos(orthAngle));
        int ny2 = ny - (int)((double)arrowHeadThickness / 2.0 * Math.sin(orthAngle));
        int[] poly = new int[]{x2, y2, nx1, ny1, nx2, ny2, x2, y2};
        gc.setForeground(this.stdColorProvider.getEdgesColor());
        gc.setBackground(this.stdColorProvider.getEdgesColor());
        gc.fillPolygon(poly);
        gc.setLineWidth(thickness);
        if (x1 == x2 && y1 == y2) {
            gc.drawOval(x1 - 10, y1, 20, 20);
        } else {
            gc.drawLine(x1, y1, nx, ny);
        }
    }

    private boolean computeTransform(boolean usePreferences) {
        GraphMapPreferences pref = GraphMapPreferences.getInstance();
        int viewId = GraphMapRegistry.getInstance().getViewId(this.view);
        Scenario sce = this.simulation.getScenario();
        IDialogSettings settings = pref.getPreferencesFor(viewId, sce);
        this.scaleFactor = 0.99;
        Rectangle2D.Double polygonsBounds = this.polygonsToRender.getBounds();
        if (polygonsBounds == null || polygonsBounds.isEmpty()) {
            return false;
        }
        Rectangle canvasBounds = this.getClientArea();
        double widthRatio = (double)canvasBounds.width / polygonsBounds.width;
        double heightRatio = (double)canvasBounds.height / polygonsBounds.height;
        int canvasCenterX = canvasBounds.x + canvasBounds.width / 2;
        int canvasCenterY = canvasBounds.y + canvasBounds.height / 2;
        double polygonCenterX = polygonsBounds.getCenterX();
        double polygonCenterY = polygonsBounds.getCenterY();
        this.scaleX = Math.min(widthRatio, heightRatio) * this.scaleFactor;
        this.scaleY = -this.scaleX;
        this.translationX = (double)canvasCenterX - polygonCenterX * this.scaleX;
        this.translationY = (double)canvasCenterY - polygonCenterY * this.scaleY;
        if (usePreferences && settings != null && settings.get("org.eclipse.stem.ui.views.graphmap.scalefactor") != null) {
            this.scaleX = this.scaleFactor = settings.getDouble("org.eclipse.stem.ui.views.graphmap.scalefactor");
            this.scaleY = -this.scaleX;
            this.translationX = (double)canvasCenterX - settings.getDouble("org.eclipse.stem.ui.views.graphmap.translationx");
            this.translationY = (double)canvasCenterY - settings.getDouble("org.eclipse.stem.ui.views.graphmap.translationy");
        }
        return true;
    }

    private void zoomIn(int x, int y) {
        Point2D.Double p = this.getInversedPoint(x, y);
        this.translationX -= 0.10000000000000009 * this.scaleX * p.x;
        this.translationY -= 0.10000000000000009 * this.scaleY * p.y;
        this.scaleFactor *= 1.1;
        this.scaleX *= 1.1;
        this.scaleY *= 1.1;
        this.transformationChanged = true;
        this.redraw();
    }

    private void zoomOut(int x, int y) {
        Point2D.Double p = this.getInversedPoint(x, y);
        this.scaleX /= 1.1;
        this.scaleY /= 1.1;
        this.scaleFactor /= 1.1;
        this.translationX += 0.10000000000000009 * this.scaleX * p.x;
        this.translationY += 0.10000000000000009 * this.scaleY * p.y;
        this.transformationChanged = true;
        this.redraw();
    }

    private StemPolygon getPolygon(int x, int y) {
        Point2D.Double point = this.getInversedPoint(x, y);
        StemPolygon retValue = null;
        if (point != null && this.polygonsToRender != null) {
            retValue = this.polygonsToRender.getContainingRegionPolygon(point);
        }
        return retValue;
    }

    private void fireSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(event);
        }
    }

    private Point2D.Double getInversedPoint(int x, int y) {
        return new Point2D.Double(((double)x - this.translationX) / this.scaleX, ((double)y - this.translationY) / this.scaleY);
    }

    private void loadMenuSettings(ISimulation sim) {
        GraphMapPreferences pref = GraphMapPreferences.getInstance();
        int viewId = GraphMapRegistry.getInstance().getViewId(this.view);
        Scenario sce = this.simulation.getScenario();
        IDialogSettings settings = pref.getPreferencesFor(viewId, sce);
        this.drawPolygonBorders = true;
        this.useLogScaling = false;
        this.useLogEdgeScaling = false;
        this.gainFactor = 1.0;
        this.edgeGainFactor = 1.0;
        this.adjustEdgeThickness = false;
        this.showOptionsBar = true;
        if (settings == null) {
            return;
        }
        if (settings.get("org.eclipse.stem.ui.views.graphmap.drawpolygonborders") != null) {
            this.drawPolygonBorders = settings.getBoolean("org.eclipse.stem.ui.views.graphmap.drawpolygonborders");
        }
        if (settings.get("org.eclipse.stem.ui.views.graphmap.uselogscaling") != null) {
            this.useLogScaling = settings.getBoolean("org.eclipse.stem.ui.views.graphmap.uselogscaling");
        }
        if (settings.get("org.eclipse.stem.ui.views.graphmap.useedgelogscaling") != null) {
            this.useLogEdgeScaling = settings.getBoolean("org.eclipse.stem.ui.views.graphmap.useedgelogscaling");
        }
        if (settings.get("org.eclipse.stem.ui.views.graphmap.gainfactor") != null) {
            this.gainFactor = settings.getDouble("org.eclipse.stem.ui.views.graphmap.gainfactor");
        }
        if (settings.get("org.eclipse.stem.ui.views.graphmap.edgegainfactor") != null) {
            this.edgeGainFactor = settings.getDouble("org.eclipse.stem.ui.views.graphmap.edgegainfactor");
        }
        if (settings.get("org.eclipse.stem.ui.views.graphmap.adjustedgethickness") != null) {
            this.adjustEdgeThickness = settings.getBoolean("org.eclipse.stem.ui.views.graphmap.adjustedgethickness");
        }
        if (settings.get("org.eclipse.stem.ui.views.graphmap.showoptionsview") != null) {
            this.showOptionsBar = settings.getBoolean("org.eclipse.stem.ui.views.graphmap.showoptionsview");
            this.showOptionsBar(this.showOptionsBar);
        }
    }

    private MenuManager createContextMenuManager() {
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.add((IContributionItem)this.createGainFactorMenu(this.gainFactor));
        this.logarithmicAction = new LogarithmicAction();
        contextMenuManager.add((IAction)this.logarithmicAction);
        contextMenuManager.add((IContributionItem)new Separator());
        this.drawPolygonBordersAction = new DrawPolygonBordersAction();
        contextMenuManager.add((IAction)this.drawPolygonBordersAction);
        contextMenuManager.add((IContributionItem)new Separator());
        this.adjustEdgeThicknessAction = new AdjustEdgeThicknessAction();
        contextMenuManager.add((IAction)this.adjustEdgeThicknessAction);
        contextMenuManager.add((IContributionItem)this.createEdgeGainFactorMenu(this.edgeGainFactor));
        this.logarithmicEdgeAction = new LogarithmicEdgeAction();
        contextMenuManager.add((IAction)this.logarithmicEdgeAction);
        contextMenuManager.add((IContributionItem)new Separator());
        contextMenuManager.add((IAction)new ResetViewAction());
        contextMenuManager.add((IAction)new ResetMapCanvasAction());
        contextMenuManager.add((IContributionItem)new Separator());
        this.toggleOptionsViewAction = new ToggleOptionsViewAction();
        contextMenuManager.add((IAction)this.toggleOptionsViewAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        return contextMenuManager;
    }

    private MenuManager createGainFactorMenu(double defaultFactor) {
        MenuManager gainFactorMenu = new MenuManager(Messages.getString("MapMenu.GainFactor"));
        int i = -7;
        while (i < 7) {
            double factor = Math.pow(10.0, i);
            GainFactorAction action = new GainFactorAction(factor);
            gainFactorMenu.add((IAction)action);
            if (factor == defaultFactor) {
                this.defaultGainFactorAction = action;
                this.lastGainFactorAction = action;
            }
            ++i;
        }
        return gainFactorMenu;
    }

    private MenuManager createEdgeGainFactorMenu(double defaultFactor) {
        MenuManager edgeGainFactorMenu = new MenuManager(Messages.getString("MapMenu.EdgeGainFactor"));
        int i = -7;
        while (i < 7) {
            double factor = Math.pow(10.0, i);
            EdgeGainFactorAction action = new EdgeGainFactorAction(factor);
            edgeGainFactorMenu.add((IAction)action);
            if (factor == defaultFactor) {
                this.defaultEdgeGainFactorAction = action;
                this.lastEdgeGainFactorAction = action;
            }
            ++i;
        }
        return edgeGainFactorMenu;
    }

    private String getText(double factor) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(10);
        NumberFormatter formatter = new NumberFormatter(format);
        String retValue = "";
        try {
            retValue = formatter.valueToString(factor);
        }
        catch (ParseException e) {
            Activator.logError("Problem parsing gain factor value \"" + factor + "\"", e);
        }
        return retValue;
    }

    private Color getInvertedColor(Color color) {
        return new Color(color.getDevice(), 255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    private class AdjustEdgeThicknessAction
    extends Action {
        public AdjustEdgeThicknessAction() {
            super(Messages.getString("MapMenu.AdjustEdgeThickness"), 2);
            this.setChecked(GraphMapCanvas.this.adjustEdgeThickness);
        }

        public String getText() {
            return Messages.getString("MapMenu.AdjustEdgeThickness");
        }

        public void run() {
            GraphMapCanvas.this.adjustEdgeThickness = !GraphMapCanvas.this.adjustEdgeThickness;
            GraphMapPreferences pref = GraphMapPreferences.getInstance();
            pref.updatePreferenceState(GraphMapRegistry.getInstance().getViewId(GraphMapCanvas.this.view), GraphMapCanvas.this.simulation, "org.eclipse.stem.ui.views.graphmap.adjustedgethickness", GraphMapCanvas.this.adjustEdgeThickness);
            GraphMapCanvas.this.redraw();
        }
    }

    private class DrawPolygonBordersAction
    extends Action {
        public DrawPolygonBordersAction() {
            super(Messages.getString("MapMenu.Polygon_Borders"), 2);
            if (GraphMapCanvas.this.drawPolygonBorders) {
                this.setChecked(true);
            }
        }

        public String getText() {
            return Messages.getString("MapMenu.Polygon_Borders");
        }

        public void run() {
            GraphMapCanvas.this.drawPolygonBorders = !GraphMapCanvas.this.drawPolygonBorders;
            GraphMapPreferences pref = GraphMapPreferences.getInstance();
            pref.updatePreferenceState(GraphMapRegistry.getInstance().getViewId(GraphMapCanvas.this.view), GraphMapCanvas.this.simulation, "org.eclipse.stem.ui.views.graphmap.drawpolygonborders", GraphMapCanvas.this.drawPolygonBorders);
            GraphMapCanvas.this.redraw();
        }
    }

    private class EdgeGainFactorAction
    extends Action {
        private double factor;

        EdgeGainFactorAction(double factor) {
            super(GraphMapCanvas.this.getText(factor), 8);
            this.factor = factor;
            this.setChecked(factor == GraphMapCanvas.this.edgeGainFactor);
        }

        public String getText() {
            return GraphMapCanvas.this.getText(this.factor);
        }

        public void run() {
            GraphMapCanvas.this.edgeGainFactor = this.factor;
            GraphMapCanvas.this.lastEdgeGainFactorAction = this;
            GraphMapPreferences pref = GraphMapPreferences.getInstance();
            pref.updatePreferenceState(GraphMapRegistry.getInstance().getViewId(GraphMapCanvas.this.view), GraphMapCanvas.this.simulation, "org.eclipse.stem.ui.views.graphmap.edgegainfactor", GraphMapCanvas.this.edgeGainFactor);
            GraphMapCanvas.this.redraw();
        }
    }

    private class GainFactorAction
    extends Action {
        private double factor;

        GainFactorAction(double factor) {
            super(GraphMapCanvas.this.getText(factor), 8);
            this.factor = factor;
            this.setChecked(factor == GraphMapCanvas.this.gainFactor);
        }

        public String getText() {
            return GraphMapCanvas.this.getText(this.factor);
        }

        public void run() {
            GraphMapCanvas.this.gainFactor = this.factor;
            GraphMapCanvas.this.lastGainFactorAction = this;
            GraphMapPreferences pref = GraphMapPreferences.getInstance();
            pref.updatePreferenceState(GraphMapRegistry.getInstance().getViewId(GraphMapCanvas.this.view), GraphMapCanvas.this.simulation, "org.eclipse.stem.ui.views.graphmap.gainfactor", GraphMapCanvas.this.gainFactor);
            GraphMapCanvas.this.updateScaleLogLinLabel();
            GraphMapCanvas.this.redraw();
        }
    }

    private class LogarithmicAction
    extends Action {
        public LogarithmicAction() {
            super(Messages.getString("MapMenu.Logrithmic_Scaling"), 2);
            this.setChecked(GraphMapCanvas.this.useLogScaling);
        }

        public String getText() {
            return Messages.getString("MapMenu.Logrithmic_Scaling");
        }

        public void run() {
            GraphMapCanvas.this.useLogScaling = !GraphMapCanvas.this.useLogScaling;
            GraphMapPreferences pref = GraphMapPreferences.getInstance();
            pref.updatePreferenceState(GraphMapRegistry.getInstance().getViewId(GraphMapCanvas.this.view), GraphMapCanvas.this.simulation, "org.eclipse.stem.ui.views.graphmap.uselogscaling", GraphMapCanvas.this.useLogScaling);
            GraphMapCanvas.this.updateScaleLogLinLabel();
            GraphMapCanvas.this.redraw();
        }
    }

    private class LogarithmicEdgeAction
    extends Action {
        public LogarithmicEdgeAction() {
            super(Messages.getString("MapMenu.Logrithmic_EdgeScaling"), 2);
            this.setChecked(GraphMapCanvas.this.useLogEdgeScaling);
        }

        public String getText() {
            return Messages.getString("MapMenu.Logrithmic_EdgeScaling");
        }

        public void run() {
            GraphMapCanvas.this.useLogEdgeScaling = !GraphMapCanvas.this.useLogEdgeScaling;
            GraphMapPreferences pref = GraphMapPreferences.getInstance();
            pref.updatePreferenceState(GraphMapRegistry.getInstance().getViewId(GraphMapCanvas.this.view), GraphMapCanvas.this.simulation, "org.eclipse.stem.ui.views.graphmap.useedgelogscaling", GraphMapCanvas.this.useLogEdgeScaling);
            GraphMapCanvas.this.redraw();
        }
    }

    private class ResetMapCanvasAction
    extends Action {
        private ResetMapCanvasAction() {
        }

        public String getText() {
            return Messages.getString("MapMenu.Reset");
        }

        public void run() {
            GraphMapCanvas.this.reset();
        }
    }

    private class ResetViewAction
    extends Action {
        private ResetViewAction() {
        }

        public String getText() {
            return Messages.getString("MapMenu.ResetView");
        }

        public void run() {
            GraphMapCanvas.this.resetView();
        }
    }

    private class ToggleOptionsViewAction
    extends Action {
        public ToggleOptionsViewAction() {
            super(Messages.getString("MapMenu.ToggleOptionsView"), 2);
            this.setChecked(GraphMapCanvas.this.showOptionsBar);
        }

        public String getText() {
            return Messages.getString("MapMenu.ToggleOptionsView");
        }

        public void run() {
            GraphMapCanvas.this.showOptionsBar = this.isChecked();
            GraphMapCanvas.this.showOptionsBar(GraphMapCanvas.this.showOptionsBar);
            GraphMapPreferences pref = GraphMapPreferences.getInstance();
            pref.updatePreferenceState(GraphMapRegistry.getInstance().getViewId(GraphMapCanvas.this.view), GraphMapCanvas.this.simulation, "org.eclipse.stem.ui.views.graphmap.showoptionsview", GraphMapCanvas.this.showOptionsBar);
        }
    }
}

