/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginDetailsSection
extends PDESection
implements IPartSelectionListener {
    protected IFeaturePlugin fInput;
    private FormEntry fNameText;
    private FormEntry fVersionText;
    private FormEntry fdownloadSizeText;
    private FormEntry fInstallSizeText;
    private Button fUnpackButton;
    private boolean fBlockNotification;

    public PluginDetailsSection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.SiteEditor_PluginDetailsSection_title, PDEUIMessages.SiteEditor_PluginDetailsSection_desc, 0);
    }

    public PluginDetailsSection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    public void cancelEdit() {
        this.fVersionText.cancelEdit();
        this.fdownloadSizeText.cancelEdit();
        this.fInstallSizeText.cancelEdit();
        super.cancelEdit();
    }

    public void commit(boolean onSave) {
        this.fVersionText.commit();
        this.fdownloadSizeText.commit();
        this.fInstallSizeText.commit();
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(770);
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        this.fNameText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PluginDetailsSection_pluginLabel, null, false);
        this.limitTextWidth(this.fNameText);
        this.fNameText.setEditable(false);
        this.fNameText.getText().setEnabled(false);
        this.fVersionText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_version, null, false);
        this.fVersionText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (PluginDetailsSection.this.fInput != null) {
                    try {
                        PluginDetailsSection.this.fInput.setVersion(text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fVersionText);
        this.fVersionText.setEditable(this.isEditable());
        this.fdownloadSizeText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PluginDetailsSection_downloadSize, null, false);
        this.fdownloadSizeText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (PluginDetailsSection.this.fInput != null) {
                    try {
                        PluginDetailsSection.this.fInput.setDownloadSize(PluginDetailsSection.this.getLong(text.getValue()));
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fdownloadSizeText);
        this.fdownloadSizeText.setEditable(this.isEditable());
        this.fInstallSizeText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PluginDetailsSection_installSize, null, false);
        this.fInstallSizeText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (PluginDetailsSection.this.fInput != null) {
                    try {
                        PluginDetailsSection.this.fInput.setInstallSize(PluginDetailsSection.this.getLong(text.getValue()));
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fInstallSizeText);
        this.fInstallSizeText.setEditable(this.isEditable());
        this.fUnpackButton = toolkit.createButton(container, PDEUIMessages.SiteEditor_PluginDetailsSection_unpack, 32);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fUnpackButton.setLayoutData((Object)gd);
        this.fUnpackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!PluginDetailsSection.this.fBlockNotification) {
                        PluginDetailsSection.this.fInput.setUnpack(PluginDetailsSection.this.fUnpackButton.getSelection());
                    }
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize(IManagedForm form) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.initialize(form);
    }

    protected void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void refresh() {
        this.update();
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection s;
        Object o;
        this.fInput = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((o = (s = (IStructuredSelection)selection).getFirstElement()) instanceof IFeaturePlugin ? (IFeaturePlugin)o : null) : null;
        this.update();
    }

    public void setFocus() {
        if (this.fdownloadSizeText != null) {
            this.fdownloadSizeText.getText().setFocus();
        }
    }

    private void update() {
        if (this.fInput != null) {
            this.fNameText.setValue(this.fInput.getLabel());
            this.fVersionText.setValue(this.fInput.getVersion(), true);
            this.fdownloadSizeText.setValue(this.fInput.getDownloadSize() >= 0L ? "" + this.fInput.getDownloadSize() : null, true);
            this.fInstallSizeText.setValue(this.fInput.getInstallSize() >= 0L ? "" + this.fInput.getInstallSize() : null, true);
            this.fBlockNotification = true;
            this.fUnpackButton.setSelection(this.fInput.isUnpack());
            this.fBlockNotification = false;
        } else {
            this.fNameText.setValue(null);
            this.fVersionText.setValue(null, true);
            this.fdownloadSizeText.setValue(null, true);
            this.fInstallSizeText.setValue(null, true);
            this.fBlockNotification = true;
            this.fUnpackButton.setSelection(true);
            this.fBlockNotification = false;
        }
        boolean editable = this.fInput != null && this.isEditable();
        this.fVersionText.setEditable(editable);
        this.fdownloadSizeText.setEditable(editable);
        this.fInstallSizeText.setEditable(editable);
        this.fUnpackButton.setEnabled(editable);
    }

    @Override
    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    private long getLong(String svalue) {
        if (svalue == null) {
            return 0L;
        }
        try {
            return Long.parseLong(svalue);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }
}

