/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.evolving.impl;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.evolving.EvolvingDiseaseModel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingDiseaseTransformer;
import org.eclipse.stem.diseasemodels.evolving.EvolvingFactory;
import org.eclipse.stem.diseasemodels.evolving.EvolvingPackage;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSIDiseaseModel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSIDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSIDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.evolving.impl.EvolvingDiseaseTransformerImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;

public class EvolvingSIDiseaseModelImpl
extends SIImpl
implements EvolvingSIDiseaseModel {
    protected EvolvingDiseaseModel parentDisease;
    protected EvolvingDiseaseTransformer transformer;
    protected DiseaseModelLabel evolvedAt;
    protected static final boolean[] GENOME_EDEFAULT = null;
    protected boolean[] genome = GENOME_EDEFAULT;
    protected static final int EVOLUTION_COUNT_EDEFAULT = 0;
    protected int evolutionCount = 0;
    protected static final double CASE_MUTATION_RATE_EDEFAULT = 1.0E-5;
    protected double caseMutationRate = 1.0E-5;
    protected static final int GENOME_LENGTH_EDEFAULT = 5;
    protected int genomeLength = 5;
    protected static final double GENETIC_DIST_NONLIN_EXPONENT_EDEFAULT = 1.0;
    protected double geneticDistNonlinExponent = 1.0;

    public EvolvingSIDiseaseModelImpl() {
        this.setTransformer(new EvolvingDiseaseTransformerImpl());
    }

    protected EClass eStaticClass() {
        return EvolvingPackage.Literals.EVOLVING_SI_DISEASE_MODEL;
    }

    @Override
    public EvolvingDiseaseModel getParentDisease() {
        if (this.parentDisease != null && this.parentDisease.eIsProxy()) {
            InternalEObject oldParentDisease = (InternalEObject)this.parentDisease;
            this.parentDisease = (EvolvingDiseaseModel)this.eResolveProxy(oldParentDisease);
        }
        return this.parentDisease;
    }

    public EvolvingDiseaseModel basicGetParentDisease() {
        return this.parentDisease;
    }

    @Override
    public void setParentDisease(EvolvingDiseaseModel newParentDisease) {
        this.parentDisease = newParentDisease;
    }

    @Override
    public EvolvingDiseaseTransformer getTransformer() {
        if (this.transformer != null && this.transformer.eIsProxy()) {
            InternalEObject oldTransformer = (InternalEObject)this.transformer;
            this.transformer = (EvolvingDiseaseTransformer)this.eResolveProxy(oldTransformer);
        }
        return this.transformer;
    }

    public EvolvingDiseaseTransformer basicGetTransformer() {
        return this.transformer;
    }

    @Override
    public void setTransformer(EvolvingDiseaseTransformer newTransformer) {
        this.transformer = newTransformer;
    }

    @Override
    public DiseaseModelLabel getEvolvedAt() {
        if (this.evolvedAt != null && this.evolvedAt.eIsProxy()) {
            InternalEObject oldEvolvedAt = (InternalEObject)this.evolvedAt;
            this.evolvedAt = (DiseaseModelLabel)this.eResolveProxy(oldEvolvedAt);
        }
        return this.evolvedAt;
    }

    public DiseaseModelLabel basicGetEvolvedAt() {
        return this.evolvedAt;
    }

    @Override
    public void setEvolvedAt(DiseaseModelLabel newEvolvedAt) {
        this.evolvedAt = newEvolvedAt;
    }

    @Override
    public int getEvolutionCount() {
        return this.evolutionCount;
    }

    @Override
    public void setEvolutionCount(int newEvolutionCount) {
        this.evolutionCount = newEvolutionCount;
    }

    @Override
    public double getCaseMutationRate() {
        return this.caseMutationRate;
    }

    @Override
    public void setCaseMutationRate(double newCaseMutationRate) {
        this.caseMutationRate = newCaseMutationRate;
    }

    @Override
    public int getGenomeLength() {
        return this.genomeLength;
    }

    @Override
    public void setGenomeLength(int newGenomeLength) {
        this.genomeLength = newGenomeLength;
    }

    @Override
    public double getGeneticDistNonlinExponent() {
        return this.geneticDistNonlinExponent;
    }

    @Override
    public void setGeneticDistNonlinExponent(double newGeneticDistNonlinExponent) {
        this.geneticDistNonlinExponent = newGeneticDistNonlinExponent;
    }

    @Override
    public boolean[] getGenome() {
        if (this.genome == null) {
            this.genome = new boolean[this.genomeLength];
            int i = 0;
            while (i < this.genome.length) {
                this.genome[i] = true;
                ++i;
            }
        }
        return this.genome;
    }

    @Override
    public void setGenome(boolean[] newGenome) {
        this.genome = newGenome;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 23: {
                if (resolve) {
                    return this.getParentDisease();
                }
                return this.basicGetParentDisease();
            }
            case 24: {
                if (resolve) {
                    return this.getTransformer();
                }
                return this.basicGetTransformer();
            }
            case 25: {
                if (resolve) {
                    return this.getEvolvedAt();
                }
                return this.basicGetEvolvedAt();
            }
            case 26: {
                return this.getGenome();
            }
            case 27: {
                return this.getEvolutionCount();
            }
            case 28: {
                return this.getCaseMutationRate();
            }
            case 29: {
                return this.getGenomeLength();
            }
            case 30: {
                return this.getGeneticDistNonlinExponent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 23: {
                this.setParentDisease((EvolvingDiseaseModel)newValue);
                return;
            }
            case 24: {
                this.setTransformer((EvolvingDiseaseTransformer)newValue);
                return;
            }
            case 25: {
                this.setEvolvedAt((DiseaseModelLabel)newValue);
                return;
            }
            case 26: {
                this.setGenome((boolean[])newValue);
                return;
            }
            case 27: {
                this.setEvolutionCount((Integer)newValue);
                return;
            }
            case 28: {
                this.setCaseMutationRate((Double)newValue);
                return;
            }
            case 29: {
                this.setGenomeLength((Integer)newValue);
                return;
            }
            case 30: {
                this.setGeneticDistNonlinExponent((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 23: {
                this.setParentDisease(null);
                return;
            }
            case 24: {
                this.setTransformer(null);
                return;
            }
            case 25: {
                this.setEvolvedAt(null);
                return;
            }
            case 26: {
                this.setGenome(GENOME_EDEFAULT);
                return;
            }
            case 27: {
                this.setEvolutionCount(0);
                return;
            }
            case 28: {
                this.setCaseMutationRate(1.0E-5);
                return;
            }
            case 29: {
                this.setGenomeLength(5);
                return;
            }
            case 30: {
                this.setGeneticDistNonlinExponent(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 23: {
                return this.parentDisease != null;
            }
            case 24: {
                return this.transformer != null;
            }
            case 25: {
                return this.evolvedAt != null;
            }
            case 26: {
                return GENOME_EDEFAULT == null ? this.genome != null : !GENOME_EDEFAULT.equals(this.genome);
            }
            case 27: {
                return this.evolutionCount != 0;
            }
            case 28: {
                return this.caseMutationRate != 1.0E-5;
            }
            case 29: {
                return this.genomeLength != 5;
            }
            case 30: {
                return this.geneticDistNonlinExponent != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == EvolvingDiseaseModel.class) {
            switch (derivedFeatureID) {
                case 23: {
                    return 0;
                }
                case 24: {
                    return 1;
                }
                case 25: {
                    return 2;
                }
                case 26: {
                    return 3;
                }
                case 27: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == EvolvingDiseaseModel.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 23;
                }
                case 1: {
                    return 24;
                }
                case 2: {
                    return 25;
                }
                case 3: {
                    return 26;
                }
                case 4: {
                    return 27;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (genome: ");
        result.append(this.genome);
        result.append(", evolutionCount: ");
        result.append(this.evolutionCount);
        result.append(", caseMutationRate: ");
        result.append(this.caseMutationRate);
        result.append(", genomeLength: ");
        result.append(this.genomeLength);
        result.append(", geneticDistNonlinExponent: ");
        result.append(this.geneticDistNonlinExponent);
        result.append(')');
        return result.toString();
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta);
        double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SILabelValue currentSI = (SILabelValue)currentState;
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSI.getI();
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSI.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * currentSI.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * currentSI.getS() * effectiveInfectious;
            double numberOfInfectedToSusceptible = adjustedRecoveryRate * currentSI.getI();
            double deltaS = -numberOfSusceptibleToInfected + numberOfInfectedToSusceptible;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToSusceptible - diseaseDeaths;
            SILabelValueImpl ret = (SILabelValueImpl)deltaValue;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)siExchange);
            Exchange isExchange = (Exchange)ExchangePool.POOL.get();
            isExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            isExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            isExchange.setCount(numberOfInfectedToSusceptible);
            isExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)isExchange);
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    public EvolvingDiseaseModel evolve(DiseaseModelLabel label) {
        double threshold;
        double pic;
        SILabelValue siValues = (SILabelValue)label.getCurrentValue();
        double incidence = siValues.getIncidence();
        if (incidence > 1.0 && (pic = Math.random()) < (threshold = incidence * this.caseMutationRate)) {
            boolean[] newGenome = this.mutateGenome(this.getGenome());
            String evolutionKey = String.valueOf(Arrays.hashCode(newGenome));
            for (DiseaseModel dm : this.getTransformer().getEvolvedDiseases()) {
                if (!evolutionKey.equals(dm.getURI().query())) continue;
                return null;
            }
            int evolutions = this.getEvolutionCount();
            this.setEvolutionCount(++evolutions);
            String genomeSTR = EvolvingSIDiseaseModelImpl.getGenomeSTR(newGenome);
            String phyloDieaseName = this.getPhyloDiseaseName(this.getDiseaseName());
            String uniqueIdentifier = String.valueOf(phyloDieaseName) + ":" + evolutions + "_[" + genomeSTR + "]";
            EvolvingSIDiseaseModel dm = (EvolvingSIDiseaseModel)EcoreUtil.copy((EObject)this);
            dm.setGenome(newGenome);
            this.getTransformer().getEvolvedDiseases().add((Object)dm);
            dm.setGraphDecorated(false);
            dm.setDiseaseName(uniqueIdentifier);
            dm.setTransformer(this.getTransformer());
            dm.setParentDisease(this);
            dm.setURI(this.getURI().appendQuery(evolutionKey));
            dm.setEvolvedAt(label);
            return dm;
        }
        return null;
    }

    public boolean[] mutateGenome(boolean[] parentGenome) {
        this.genomeLength = parentGenome.length;
        boolean[] genome = new boolean[this.genomeLength];
        double dMute = Math.random() * (double)genome.length;
        int iMute = (int)Math.round(dMute);
        int i = 0;
        while (i < genome.length) {
            genome[i] = parentGenome[i];
            if (i == iMute) {
                genome[i] = !parentGenome[i];
            }
            ++i;
        }
        return genome;
    }

    public static String getGenomeSTR(boolean[] genome) {
        String retval = "";
        int i = 0;
        while (i < genome.length) {
            retval = genome[i] ? String.valueOf(retval) + "1" : String.valueOf(retval) + "0";
            ++i;
        }
        return retval;
    }

    @Override
    public void calculateEvolvedInitialState() {
        EvolvingSIDiseaseModelImpl parentDiseaseModel = (EvolvingSIDiseaseModelImpl)this.getParentDisease();
        DiseaseModelLabel parentEvolutionSource = this.getEvolvedAt();
        if (parentDiseaseModel == null && parentEvolutionSource == null) {
            System.err.println("Trying to calculate label state from an improperly initialized evolved model.  Do something.");
            return;
        }
        Node currentNode = parentEvolutionSource.getNode();
        URI evolutionLocation = currentNode.getURI();
        boolean[] genome = this.getGenome();
        boolean[] parentGenome = parentDiseaseModel.getGenome();
        if (genome != null && genome.length > 1) {
            double dMute = Math.random() * (double)genome.length;
            int iMute = (int)Math.round(dMute);
            int i = 0;
            while (i < genome.length) {
                genome[i] = parentGenome[i];
                if (i == iMute) {
                    genome[i] = !genome[i];
                }
                ++i;
            }
        }
        this.setGenome(genome);
        for (DynamicLabel dl : this.getLabelsToUpdate()) {
            double popCount;
            if (!(dl instanceof EvolvingSIDiseaseModelLabel)) continue;
            double s = 0.0;
            double i = 0.0;
            double diseaseDeaths = 0.0;
            EvolvingSIDiseaseModelLabel childLabel = (EvolvingSIDiseaseModelLabel)dl;
            EvolvingSIDiseaseModelLabelValue childLabelValues = (EvolvingSIDiseaseModelLabelValue)childLabel.getCurrentValue();
            EvolvingSIDiseaseModelLabel parentSIlabel = (EvolvingSIDiseaseModelLabel)parentEvolutionSource;
            childLabel.setPopulationLabel(parentSIlabel.getPopulationLabel());
            childLabel.setPopulationModelLabel(parentSIlabel.getPopulationModelLabel());
            EvolvingSIDiseaseModelLabelValue lv = (EvolvingSIDiseaseModelLabelValue)parentSIlabel.getCurrentValue();
            s = popCount = lv.getPopulationCount();
            if (childLabel.getNode().getURI().equals(evolutionLocation)) {
                System.out.println("initializing child disease at evolution location");
                if (parentEvolutionSource instanceof EvolvingSIDiseaseModelLabel) {
                    if (popCount > 1.0) {
                        i = 1.0;
                        s -= 1.0;
                    } else {
                        System.err.println("Likely ERROR: Zero population detected on node " + currentNode.getURI().lastSegment() + " ...  Do something.");
                    }
                }
            }
            childLabelValues.setS(s);
            childLabelValues.setI(i);
            childLabelValues.setDiseaseDeaths(diseaseDeaths);
        }
    }

    @Override
    public double getGeneticDistance(EvolvingDiseaseModel otherDieaseStrain) {
        boolean[] genome = this.getGenome();
        if (genome == null || genome.length <= 1) {
            return 1.0;
        }
        boolean[] otherGenome = otherDieaseStrain.getGenome();
        double ntDistance = 0.0;
        int i = 0;
        while (i < genome.length) {
            if (genome[i] != otherGenome[i]) {
                ntDistance += 1.0;
            }
            ++i;
        }
        this.getCMdistance(otherDieaseStrain);
        return Math.pow(ntDistance, this.geneticDistNonlinExponent);
    }

    protected double getCMdistance(EvolvingDiseaseModel otherStrain) {
        double cm1 = this.getGeneticCenterOfMass(this);
        this.getGeneticCenterOfMass(otherStrain);
        double diff = Math.abs(cm1 - cm1);
        if (diff >= 1.0) {
            return diff;
        }
        return 1.0;
    }

    protected double getGeneticCenterOfMass(EvolvingDiseaseModel otherStrain) {
        double cm = 0.0;
        boolean[] genome = this.getGenome();
        boolean[] otherGenome = otherStrain.getGenome();
        int i = 0;
        while (i < genome.length) {
            if (otherGenome[i]) {
                cm += (double)i;
            }
            ++i;
        }
        return cm /= (double)genome.length;
    }

    protected String getPhyloDiseaseName(String rootName) {
        String retVal = rootName;
        int idx1 = retVal.indexOf("_[");
        if (idx1 >= 0) {
            retVal = rootName.substring(0, idx1);
        }
        return retVal;
    }

    public void prepare(Model model, STEMTime time) {
        super.prepare(model, time);
        EvolvingDiseaseTransformer transformer = this.getTransformer();
        if (transformer != null) {
            model.getNodeDecorators().add((Object)transformer);
        }
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        EvolvingSIDiseaseModelLabel label = EvolvingFactory.eINSTANCE.createEvolvingSIDiseaseModelLabel();
        label.setTypeURI(DiseaseModelLabel.URI_TYPE_DYNAMIC_DISEASE_LABEL);
        return label;
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return EvolvingFactory.eINSTANCE.createEvolvingSIDiseaseModelLabelValue();
    }
}

