/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonTypeSet
extends TypeSet {
    private final TType fType;

    public SingletonTypeSet(TType t, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        Assert.isNotNull((Object)t);
        this.fType = t;
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    @Override
    public TypeSet makeClone() {
        return this;
    }

    @Override
    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        if (s2.contains(this.fType)) {
            return this;
        }
        return this.getTypeSetEnvironment().getEmptyTypeSet();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public TypeSet upperBound() {
        return this;
    }

    @Override
    public TypeSet lowerBound() {
        return this;
    }

    @Override
    public boolean hasUniqueLowerBound() {
        return true;
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return true;
    }

    @Override
    public TType uniqueLowerBound() {
        return this.fType;
    }

    @Override
    public TType uniqueUpperBound() {
        return this.fType;
    }

    @Override
    public boolean contains(TType t) {
        return this.fType.equals(t);
    }

    @Override
    public boolean containsAll(TypeSet s) {
        if (s.isEmpty()) {
            return true;
        }
        if (s.isSingleton()) {
            return s.anyMember().equals(this.fType);
        }
        return false;
    }

    @Override
    public Iterator<TType> iterator() {
        return new Iterator<TType>(){
            private boolean done = false;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public TType next() {
                this.done = true;
                return SingletonTypeSet.this.fType;
            }
        };
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public TType anyMember() {
        return this.fType;
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(this.fType, this.getTypeSetEnvironment());
        enumeratedTypeSet.initComplete();
        return enumeratedTypeSet;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SingletonTypeSet) {
            SingletonTypeSet other = (SingletonTypeSet)o;
            return this.fType.equals(other.fType);
        }
        if (o instanceof TypeSet) {
            TypeSet other = (TypeSet)o;
            return other.isSingleton() && other.anyMember().equals(this.fType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fType.hashCode();
    }

    @Override
    public String toString() {
        return "{" + this.fID + ": " + this.fType.getPrettySignature() + "}";
    }
}

