/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.ToggleBreadcrumbAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.ConfigureWorkingSetAssignementAction;
import org.eclipse.jdt.ui.actions.BuildActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.NavigateActionGroup;
import org.eclipse.jdt.ui.actions.ProjectActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.operations.UndoRedoActionGroup;

final class JavaEditorBreadcrumbActionGroup
extends CompositeActionGroup {
    public JavaEditorBreadcrumbActionGroup(JavaEditor javaEditor, ISelectionProvider selectionProvider) {
        super(new ActionGroup[]{new BreadcrumbActionGroup(javaEditor), new UndoRedoActionGroup((IWorkbenchPartSite)javaEditor.getEditorSite(), (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class), true), new NewWizardsActionGroup((IWorkbenchSite)javaEditor.getEditorSite()), new JavaSearchActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider), new NavigateActionGroup((IWorkbenchPartSite)javaEditor.getEditorSite(), selectionProvider), new CCPActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider), new GenerateBuildPathActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider), new GenerateActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider), new RefactorActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider), new BuildActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider), new ProjectActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider), new WorkingSetActionGroup((IWorkbenchSite)javaEditor.getEditorSite(), selectionProvider)});
    }

    public void fillContextMenu(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        super.fillContextMenu(menu);
    }

    private static final class BreadcrumbActionGroup
    extends ActionGroup {
        private GoToEditorAction fGoToEditor;
        private ToggleBreadcrumbAction fHideBreadcrumb;

        public BreadcrumbActionGroup(JavaEditor javaEditor) {
            this.fGoToEditor = new GoToEditorAction(javaEditor);
            this.fGoToEditor.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb");
            this.fHideBreadcrumb = new ToggleBreadcrumbAction(javaEditor.getSite().getPage(), true);
            this.fHideBreadcrumb.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.toggleBreadcrumb");
        }

        public void fillActionBars(IActionBars actionBars) {
            super.fillActionBars(actionBars);
            actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb", (IAction)this.fGoToEditor);
        }

        public void fillContextMenu(IMenuManager menu) {
            super.fillContextMenu(menu);
            menu.appendToGroup("group.open", (IAction)this.fGoToEditor);
            menu.appendToGroup("group.open", (IAction)this.fHideBreadcrumb);
        }

        private static final class GoToEditorAction
        extends Action {
            private final JavaEditor fJavaEditor;

            public GoToEditorAction(JavaEditor javaEditor) {
                super(JavaEditorMessages.JavaEditorBreadcrumbActionGroup_go_to_editor_action_label);
                this.setEnabled(true);
                this.fJavaEditor = javaEditor;
            }

            public void run() {
                this.fJavaEditor.getViewer().getTextWidget().setFocus();
            }
        }
    }

    static final class WorkingSetActionGroup
    extends ActionGroup {
        private final ConfigureWorkingSetAssignementAction fAssignWorkingSetAction;
        private final ISelectionProvider fSelectionProvider;

        public WorkingSetActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
            this.fSelectionProvider = selectionProvider;
            this.fAssignWorkingSetAction = new ConfigureWorkingSetAssignementAction(site);
            this.fAssignWorkingSetAction.setSpecialSelectionProvider(selectionProvider);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fAssignWorkingSetAction);
        }

        public void dispose() {
            super.dispose();
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fAssignWorkingSetAction);
        }

        public void fillContextMenu(IMenuManager menu) {
            if (this.fAssignWorkingSetAction.isEnabled()) {
                menu.appendToGroup("group.build", (IAction)this.fAssignWorkingSetAction);
            }
        }
    }
}

