/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Collection;
import java.util.LinkedList;
import javax.inject.Inject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.XMLModelReconciler;
import org.eclipse.e4.ui.workbench.modeling.IModelReconcilingService;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public class ModelReconcilingService
implements IModelReconcilingService {
    @Inject
    private Logger logger;

    @Override
    public ModelReconciler createModelReconciler() {
        return new XMLModelReconciler();
    }

    @Override
    public IStatus applyDeltas(Collection<ModelDelta> deltas) {
        return this.applyDeltas(deltas, null);
    }

    @Override
    public IStatus applyDeltas(Collection<ModelDelta> deltas, String[] filters) {
        IStatus[] status;
        if (filters == null) {
            filters = new String[]{};
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.e4.ui.workbench", 0, "", null);
        LinkedList<ModelDelta> delayedDeltas = new LinkedList<ModelDelta>();
        block10: for (final ModelDelta delta : deltas) {
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (delta.getAttributeName().equals(filter)) continue block10;
                ++n2;
            }
            status = new IStatus[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    status[0] = delta.apply();
                }

                public void handleException(Throwable exception) {
                    status[0] = new Status(4, "org.eclipse.e4.ui.workbench", "Failed to apply delta", exception);
                }
            });
            if (status[0].getSeverity() == 8) {
                delayedDeltas.add(delta);
                continue;
            }
            multiStatus.add(status[0]);
            switch (status[0].getCode()) {
                case 1: {
                    this.logger.info(status[0].getMessage());
                    break;
                }
                case 2: {
                    this.logger.warn(status[0].getMessage());
                    break;
                }
                case 4: {
                    this.logger.error(status[0].getMessage());
                }
            }
        }
        for (final ModelDelta delta : delayedDeltas) {
            status = new IStatus[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    status[0] = delta.apply();
                }

                public void handleException(Throwable exception) {
                    status[0] = new Status(4, "org.eclipse.e4.ui.workbench", "Failed to apply delta", exception);
                }
            });
            if (status[0].getSeverity() == 8) continue;
            multiStatus.add(status[0]);
            switch (status[0].getCode()) {
                case 1: {
                    this.logger.info(status[0].getMessage());
                    break;
                }
                case 2: {
                    this.logger.warn(status[0].getMessage());
                    break;
                }
                case 4: {
                    this.logger.error(status[0].getMessage());
                }
            }
        }
        return multiStatus;
    }
}

