/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.compare;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ui.StorageTypedElement;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareInputResourceProvider
implements IResourceProvider {
    private ICompareInput compareInput;
    private ITypedElement typedElement;

    public CompareInputResourceProvider(ICompareInput compareInput, ITypedElement typedElement) {
        Assert.isNotNull((Object)compareInput, (String)"parameter 'compareInput' must not be null");
        Assert.isNotNull((Object)typedElement, (String)"parameter 'typedElement' must not be null");
        this.compareInput = compareInput;
        this.typedElement = typedElement;
    }

    public IResource getResource() {
        IResource resource = this.getResource(this.typedElement);
        if (resource == null) {
            resource = this.typedElement == this.compareInput.getLeft() ? this.getResource(this.compareInput.getRight()) : this.getResource(this.compareInput.getLeft());
        }
        if (resource == null && this.compareInput instanceof ITypedElement) {
            resource = this.getResource((ITypedElement)this.compareInput);
        }
        return resource;
    }

    protected IResource getResource(ITypedElement typedElement) {
        IResource result = null;
        if (typedElement instanceof IResourceProvider) {
            IResourceProvider resourceProvider = (IResourceProvider)typedElement;
            result = resourceProvider.getResource();
        } else if (typedElement instanceof StorageTypedElement) {
            StorageTypedElement storageTypedElement = (StorageTypedElement)typedElement;
            IStorage bufferedStorage = storageTypedElement.getBufferedStorage();
            result = this.getExistingFile((IPath)(bufferedStorage != null ? bufferedStorage.getFullPath() : Path.EMPTY));
        }
        if (result == null) {
            IProject projectFromInput = this.getProjectFromInput();
            List<String> path = this.getPath(typedElement);
            int i = 0;
            while (i < path.size() && result == null) {
                IProject project = this.getWorkspaceRoot().getProject(path.get(i));
                String subPath = String.valueOf('/') + Joiner.on((char)'/').join(path.subList(i, path.size()));
                if (project.exists()) {
                    result = this.getExistingFile((IPath)new Path(subPath));
                } else if (projectFromInput != null) {
                    String pathInProject = String.valueOf('/') + projectFromInput.getName() + subPath;
                    result = this.getExistingFile((IPath)new Path(pathInProject));
                }
                ++i;
            }
        }
        return result;
    }

    private IProject getProjectFromInput() {
        IResource res;
        if (this.compareInput instanceof IResourceProvider && (res = ((IResourceProvider)this.compareInput).getResource()) != null) {
            return res.getProject();
        }
        return null;
    }

    private IResource getExistingFile(IPath fullPath) {
        IFile file = this.getWorkspaceRoot().getFile(fullPath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private List<String> getPath(ITypedElement typedElement) {
        ArrayList names = Lists.newArrayList((Object[])new String[]{typedElement.getName()});
        ITypedElement current = typedElement;
        while (current instanceof IDiffContainer) {
            names.add(current.getName());
            current = ((IDiffContainer)current).getParent();
        }
        Collections.reverse(names);
        ArrayList segments = Lists.newArrayList();
        for (String name : names) {
            if (Strings.isEmpty((String)name)) continue;
            String[] stringArray = name.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                segments.add(seg);
                ++n2;
            }
        }
        return segments;
    }
}

