/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.sourcelookup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.containers.ClasspathContainerSourceContainer;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.swt.widgets.Shell;

public class ClasspathContainerSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        return this.editLibraries(shell, director, null);
    }

    public boolean canEditSourceContainers(ISourceLookupDirector director, ISourceContainer[] containers) {
        return containers.length == 1;
    }

    public ISourceContainer[] editSourceContainers(Shell shell, ISourceLookupDirector director, ISourceContainer[] containers) {
        ClasspathContainerSourceContainer sourceContainer = (ClasspathContainerSourceContainer)containers[0];
        IPath containerPath = sourceContainer.getPath();
        IClasspathEntry classpathEntry = JavaCore.newContainerEntry((IPath)containerPath);
        return this.editLibraries(shell, director, classpathEntry);
    }

    private ISourceContainer[] editLibraries(Shell shell, ISourceLookupDirector director, IClasspathEntry classpathEntry) {
        IJavaProject project = null;
        ILaunchConfiguration configuration = director.getLaunchConfiguration();
        if (configuration != null) {
            try {
                project = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            }
            catch (CoreException coreException) {}
        }
        IClasspathEntry[] edits = null;
        IClasspathEntry[] created = null;
        if (classpathEntry == null) {
            edits = new IClasspathEntry[]{};
            created = BuildPathDialogAccess.chooseContainerEntries((Shell)shell, (IJavaProject)project, (IClasspathEntry[])edits);
        } else {
            edits = new IClasspathEntry[]{classpathEntry};
            IClasspathEntry edit = BuildPathDialogAccess.configureContainerEntry((Shell)shell, (IClasspathEntry)classpathEntry, (IJavaProject)project, (IClasspathEntry[])edits);
            if (edit != null) {
                created = new IClasspathEntry[]{edit};
            }
        }
        if (created != null) {
            ISourceContainer[] newContainers = new ISourceContainer[created.length];
            int i = 0;
            while (i < created.length) {
                IClasspathEntry entry = created[i];
                ClasspathContainerSourceContainer container = new ClasspathContainerSourceContainer(entry.getPath());
                container.init(director);
                newContainers[i] = container;
                ++i;
            }
            return newContainers;
        }
        return new ISourceContainer[0];
    }
}

