/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.category.CategoryLabelProvider;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Version;

public class CategorySection
extends TreeSection
implements IFeatureModelListener {
    private static final int BUTTON_ADD_CATEGORY = 0;
    private static final int BUTTON_ADD_FEATURE = 1;
    private static final int BUTTON_ADD_BUNDLE = 2;
    private static int fCounter;
    private ISiteModel fModel;
    private TreePart fCategoryTreePart;
    private TreeViewer fCategoryViewer;
    private LabelProvider fSiteLabelProvider;

    public CategorySection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEUIMessages.CategoryDefinitionCategorySection_new, PDEUIMessages.CategorySection_add, PDEUIMessages.CategorySection_addBundle});
        this.getSection().setText(PDEUIMessages.CategoryDefinitionCategorySection_title);
        this.getSection().setDescription(PDEUIMessages.CategoryDefinitionCategorySection_desc);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fCategoryTreePart = this.getTreePart();
        this.fCategoryViewer = this.fCategoryTreePart.getTreeViewer();
        this.fCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.fSiteLabelProvider = new CategoryLabelProvider();
        this.fCategoryViewer.setLabelProvider((IBaseLabelProvider)this.fSiteLabelProvider);
        this.fCategoryViewer.setInput((Object)this.fModel.getSite());
        int ops = 19;
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance()};
        if (this.isEditable()) {
            this.fCategoryViewer.addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fCategoryViewer){

                public void dragEnter(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragEnter(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOperationChanged(event);
                }

                public void dragOver(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOver(event);
                }

                protected int determineLocation(DropTargetEvent event) {
                    Rectangle bounds;
                    if (!(event.item instanceof Item)) {
                        return 4;
                    }
                    Item item = (Item)event.item;
                    Point coordinates = new Point(event.x, event.y);
                    coordinates = this.getViewer().getControl().toControl(coordinates);
                    if (item != null && (bounds = this.getBounds(item)) == null) {
                        return 4;
                    }
                    return 3;
                }

                public boolean performDrop(Object data) {
                    if (!(data instanceof Object[])) {
                        return false;
                    }
                    Object target = this.getCurrentTarget();
                    int op = this.getCurrentOperation();
                    Object[] objects = (Object[])data;
                    if (objects.length > 0 && objects[0] instanceof SiteFeatureAdapter) {
                        if (op == 1 && target != null) {
                            CategorySection.this.copyFeature((SiteFeatureAdapter)objects[0], target);
                        } else {
                            CategorySection.this.moveFeature((SiteFeatureAdapter)objects[0], target);
                        }
                        return true;
                    }
                    if (objects.length > 0 && objects[0] instanceof SiteBundleAdapter) {
                        if (op == 1 && target != null) {
                            CategorySection.this.copyBundle((SiteBundleAdapter)objects[0], target);
                        } else {
                            CategorySection.this.moveBundle((SiteBundleAdapter)objects[0], target);
                        }
                        return true;
                    }
                    return false;
                }

                public boolean validateDrop(Object target, int operation, TransferData transferType) {
                    return target instanceof ISiteCategoryDefinition || target == null;
                }
            });
        }
        this.fCategoryViewer.addDragSupport(3, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)CategorySection.this.fCategoryViewer.getSelection();
                if (ssel == null || ssel.isEmpty() || !(ssel.getFirstElement() instanceof SiteFeatureAdapter) && !(ssel.getFirstElement() instanceof SiteBundleAdapter)) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)CategorySection.this.fCategoryViewer.getSelection();
                event.data = ssel.toArray();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.fCategoryTreePart.setButtonEnabled(0, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(1, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(2, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private boolean categoryExists(String name) {
        ISiteCategoryDefinition[] defs = this.fModel.getSite().getCategoryDefinitions();
        int i = 0;
        while (i < defs.length) {
            ISiteCategoryDefinition def = defs[i];
            String dname = def.getName();
            if (dname != null && dname.equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void copyFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            return;
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(feature, ((ISiteCategoryDefinition)target).getName());
        }
    }

    private void copyBundle(SiteBundleAdapter adapter, Object target) {
        ISiteBundle bundle = this.findRealBundle(adapter);
        if (bundle == null) {
            return;
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(bundle, ((ISiteCategoryDefinition)target).getName());
        }
    }

    private void addCategory(ISiteFeature aFeature, String catName) {
        try {
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] cats = aFeature.getCategories();
            int j = 0;
            while (j < cats.length) {
                if (cats[j].getName().equals(catName)) {
                    return;
                }
                ++j;
            }
            ISiteCategory cat = this.fModel.getFactory().createCategory(aFeature);
            cat.setName(catName);
            this.expandCategory(catName);
            aFeature.addCategories(new ISiteCategory[]{cat});
        }
        catch (CoreException coreException) {}
    }

    private void addCategory(ISiteBundle aBundle, String catName) {
        try {
            if (aBundle == null) {
                return;
            }
            ISiteCategory[] cats = aBundle.getCategories();
            int j = 0;
            while (j < cats.length) {
                if (cats[j].getName().equals(catName)) {
                    return;
                }
                ++j;
            }
            ISiteCategory cat = this.fModel.getFactory().createCategory(aBundle);
            cat.setName(catName);
            this.expandCategory(catName);
            aBundle.addCategories(new ISiteCategory[]{cat});
        }
        catch (CoreException coreException) {}
    }

    private void moveFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            return;
        }
        if (adapter.category != null) {
            this.removeCategory(feature, adapter.category);
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(feature, ((ISiteCategoryDefinition)target).getName());
        }
    }

    private void moveBundle(SiteBundleAdapter adapter, Object target) {
        ISiteBundle bundle = this.findRealBundle(adapter);
        if (bundle == null) {
            return;
        }
        if (adapter.category != null) {
            this.removeCategory(bundle, adapter.category);
        }
        if (target != null && target instanceof ISiteCategoryDefinition) {
            this.addCategory(bundle, ((ISiteCategoryDefinition)target).getName());
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddCategoryDefinition();
                break;
            }
            case 1: {
                this.handleNewFeature();
                break;
            }
            case 2: {
                this.handleNewBundle();
            }
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection ssel) {
        super.handleDoubleClick(ssel);
        Object selected = ssel.getFirstElement();
        if (selected instanceof SiteFeatureAdapter) {
            IFeature feature = this.findFeature(((SiteFeatureAdapter)selected).feature);
            FeatureEditor.openFeatureEditor(feature);
        } else if (selected instanceof SiteBundleAdapter) {
            ManifestEditor.openPluginEditor(((SiteBundleAdapter)selected).bundle.getId());
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    private void handleAddCategoryDefinition() {
        String name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++fCounter));
        while (this.categoryExists(name)) {
            name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++fCounter));
        }
        String label = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryLabel, (Object)Integer.toString(fCounter));
        ISiteCategoryDefinition categoryDef = this.fModel.getFactory().createCategoryDefinition();
        try {
            categoryDef.setName(name);
            categoryDef.setLabel(label);
            this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{categoryDef});
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)categoryDef), true);
    }

    private boolean handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        Iterator iterator = ssel.iterator();
        boolean success = true;
        HashSet removedCategories = new HashSet();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            if (object instanceof ISiteCategoryDefinition) {
                if (this.handleRemoveCategoryDefinition((ISiteCategoryDefinition)object)) continue;
                success = false;
                continue;
            }
            if (object instanceof SiteFeatureAdapter) {
                SiteFeatureAdapter fa = (SiteFeatureAdapter)object;
                if (removedCategories.contains(fa.category) || this.handleRemoveSiteFeatureAdapter(fa)) continue;
                success = false;
                continue;
            }
            if (!(object instanceof SiteBundleAdapter)) continue;
            SiteBundleAdapter ba = (SiteBundleAdapter)object;
            if (removedCategories.contains(ba.category) || this.handleRemoveSiteBundleAdapter(ba)) continue;
            success = false;
        }
        return success;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean handleRemoveCategoryDefinition(ISiteCategoryDefinition catDef) {
        try {
            Object[] children = ((CategoryContentProvider)this.fCategoryViewer.getContentProvider()).getChildren(catDef);
            int i = 0;
            while (i < children.length) {
                int j;
                ISiteCategory[] cats;
                Serializable adapter;
                if (children[i] instanceof SiteFeatureAdapter) {
                    adapter = (SiteFeatureAdapter)children[i];
                    cats = adapter.feature.getCategories();
                    j = 0;
                    while (j < cats.length) {
                        if (adapter.category.equals(cats[j].getName())) {
                            adapter.feature.removeCategories(new ISiteCategory[]{cats[j]});
                        }
                        ++j;
                    }
                    if (adapter.feature.getCategories().length == 0) {
                        this.fModel.getSite().removeFeatures(new ISiteFeature[]{adapter.feature});
                    }
                } else if (children[i] instanceof SiteBundleAdapter) {
                    adapter = (SiteBundleAdapter)children[i];
                    cats = ((SiteBundleAdapter)adapter).bundle.getCategories();
                    j = 0;
                    while (j < cats.length) {
                        if (((SiteBundleAdapter)adapter).category.equals(cats[j].getName())) {
                            ((SiteBundleAdapter)adapter).bundle.removeCategories(new ISiteCategory[]{cats[j]});
                        }
                        ++j;
                    }
                    if (((SiteBundleAdapter)adapter).bundle.getCategories().length == 0) {
                        this.fModel.getSite().removeBundles(new ISiteBundle[]{((SiteBundleAdapter)adapter).bundle});
                    }
                } else {
                    return false;
                }
                ++i;
            }
            this.fModel.getSite().removeCategoryDefinitions(new ISiteCategoryDefinition[]{catDef});
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteFeatureAdapter(SiteFeatureAdapter adapter) {
        try {
            ISiteFeature feature = adapter.feature;
            if (adapter.category == null) {
                this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
            } else {
                this.removeCategory(feature, adapter.category);
                if (feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteBundleAdapter(SiteBundleAdapter adapter) {
        try {
            ISiteBundle bundle = adapter.bundle;
            if (adapter.category == null) {
                this.fModel.getSite().removeBundles(new ISiteBundle[]{bundle});
            } else {
                this.removeCategory(bundle, adapter.category);
                if (bundle.getCategories().length == 0) {
                    this.fModel.getSite().removeBundles(new ISiteBundle[]{bundle});
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void removeCategory(ISiteFeature aFeature, String catName) {
        try {
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] cats = aFeature.getCategories();
            int i = 0;
            while (i < cats.length) {
                if (catName.equals(cats[i].getName())) {
                    aFeature.removeCategories(new ISiteCategory[]{cats[i]});
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void removeCategory(ISiteBundle aBundle, String catName) {
        try {
            if (aBundle == null) {
                return;
            }
            ISiteCategory[] cats = aBundle.getCategories();
            int i = 0;
            while (i < cats.length) {
                if (catName.equals(cats[i].getName())) {
                    aBundle.removeCategories(new ISiteCategory[]{cats[i]});
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private ISiteFeature findRealFeature(SiteFeatureAdapter adapter) {
        ISiteFeature featureCopy = adapter.feature;
        ISiteFeature[] features = this.fModel.getSite().getFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getId().equals(featureCopy.getId()) && features[i].getVersion().equals(featureCopy.getVersion())) {
                return features[i];
            }
            ++i;
        }
        return null;
    }

    private ISiteBundle findRealBundle(SiteBundleAdapter adapter) {
        ISiteBundle featureCopy = adapter.bundle;
        ISiteBundle[] bundles = this.fModel.getSite().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getId().equals(featureCopy.getId()) && bundles[i].getVersion().equals(featureCopy.getVersion())) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.removeFeatureModelListener((IFeatureModelListener)this);
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
        if (this.fSiteLabelProvider != null) {
            this.fSiteLabelProvider.dispose();
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        Action removeAction = new Action(PDEUIMessages.CategorySection_remove){

            public void run() {
                CategorySection.this.doGlobalAction(ActionFactory.DELETE.getId());
            }
        };
        removeAction.setEnabled(this.isEditable());
        manager.add((IAction)removeAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return this.handleRemove();
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.fCategoryViewer.getTree().selectAll();
            this.refresh();
        }
        return false;
    }

    public void refresh() {
        this.fCategoryViewer.refresh();
        super.refresh();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void initialize() {
        this.refresh();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.addFeatureModelListener((IFeatureModelListener)this);
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        try {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof SiteFeatureAdapter) {
                    this.copyFeature((SiteFeatureAdapter)objects[i], target);
                } else if (objects[i] instanceof SiteBundleAdapter) {
                    this.copyBundle((SiteBundleAdapter)objects[i], target);
                } else if (objects[i] instanceof ISiteCategoryDefinition) {
                    this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)objects[i]});
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        if (target == null || target instanceof ISiteCategoryDefinition) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof SiteFeatureAdapter) {
                    return true;
                }
                if (objects[i] instanceof SiteBundleAdapter) {
                    return true;
                }
                if (objects[i] instanceof ISiteCategoryDefinition) {
                    String name = ((ISiteCategoryDefinition)objects[i]).getName();
                    ISiteCategoryDefinition[] defs = this.fModel.getSite().getCategoryDefinitions();
                    int j = 0;
                    while (j < defs.length) {
                        ISiteCategoryDefinition def = defs[j];
                        String dname = def.getName();
                        if (dname != null && dname.equals(name)) {
                            return false;
                        }
                        ++j;
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IFeature findFeature(ISiteFeature siteFeature) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(siteFeature.getId(), siteFeature.getVersion());
        if (model != null) {
            return model.getFeature();
        }
        return null;
    }

    private void handleNewFeature() {
        Control control = this.fCategoryViewer.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
                ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
                int i = 0;
                while (i < allModels.length) {
                    if (CategorySection.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
                FeatureSelectionDialog dialog = new FeatureSelectionDialog(CategorySection.this.fCategoryViewer.getTree().getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    try {
                        CategorySection.this.doAdd(models);
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
            }
        });
    }

    private void handleNewBundle() {
        Control control = this.fCategoryViewer.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IPluginModelBase[] allModels = PluginRegistry.getAllModels();
                ArrayList<IPluginModelBase> newModels = new ArrayList<IPluginModelBase>();
                int i = 0;
                while (i < allModels.length) {
                    if (CategorySection.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IPluginModelBase[] candidateModels = newModels.toArray(new IPluginModelBase[newModels.size()]);
                PluginSelectionDialog dialog = new PluginSelectionDialog(CategorySection.this.fCategoryViewer.getTree().getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    try {
                        CategorySection.this.doAddBundles(models);
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
            }
        });
    }

    private boolean canAdd(IFeatureModel candidate) {
        ISiteFeature[] features = this.fModel.getSite().getFeatures();
        IFeature cfeature = candidate.getFeature();
        int i = 0;
        while (i < features.length) {
            ISiteFeature bfeature = features[i];
            if (bfeature.getId().equals(cfeature.getId()) && bfeature.getVersion().equals(cfeature.getVersion())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canAdd(IPluginModelBase candidate) {
        ISiteBundle[] currentBundles = this.fModel.getSite().getBundles();
        IPluginBase candidateBundle = candidate.getPluginBase();
        int i = 0;
        while (i < currentBundles.length) {
            ISiteBundle currentBundle = currentBundles[i];
            if (currentBundle.getId().equals(candidateBundle.getId()) && currentBundle.getVersion().equals(candidateBundle.getVersion())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ISiteFeature createSiteFeature(ISiteModel model, IFeatureModel featureModel) throws CoreException {
        IFeature feature = featureModel.getFeature();
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(feature.getId());
        sfeature.setVersion(feature.getVersion());
        sfeature.setURL("features/" + feature.getId() + "_" + CategorySection.formatVersion(feature.getVersion()) + ".jar");
        sfeature.setOS(feature.getOS());
        sfeature.setWS(feature.getWS());
        sfeature.setArch(feature.getArch());
        sfeature.setNL(feature.getNL());
        sfeature.setIsPatch(CategorySection.isFeaturePatch(feature));
        return sfeature;
    }

    private ISiteBundle createSiteBundle(ISiteModel model, IPluginModelBase candidate) throws CoreException {
        ISiteBundle newBundle = model.getFactory().createBundle();
        newBundle.setId(candidate.getPluginBase().getId());
        newBundle.setVersion(candidate.getPluginBase().getVersion());
        return newBundle;
    }

    private static String formatVersion(String version) {
        try {
            Version v = new Version(version);
            return v.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return version;
        }
    }

    private static boolean isFeaturePatch(IFeature feature) {
        IFeatureImport[] imports = feature.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ISiteModel getModel() {
        return this.fModel;
    }

    public void doAdd(Object[] candidates) throws CoreException {
        String categoryName = null;
        ISelection selection = this.fCategoryViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ISiteCategoryDefinition) {
                categoryName = ((ISiteCategoryDefinition)element).getName();
            } else if (element instanceof SiteFeatureAdapter) {
                categoryName = ((SiteFeatureAdapter)element).category;
            } else if (element instanceof SiteBundleAdapter) {
                categoryName = ((SiteBundleAdapter)element).category;
            }
        }
        ISiteFeature[] added = new ISiteFeature[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            ISiteFeature child = CategorySection.createSiteFeature(this.fModel, candidate);
            if (categoryName != null) {
                this.addCategory(child, categoryName);
            }
            added[i] = child;
            ++i;
        }
        this.fModel.getSite().addFeatures(added);
        if (added.length > 0) {
            if (categoryName != null) {
                this.expandCategory(categoryName);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteFeatureAdapter(categoryName, added[added.length - 1])), true);
        }
    }

    public void doAddBundles(Object[] candidates) throws CoreException {
        String categoryName = null;
        ISelection selection = this.fCategoryViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ISiteCategoryDefinition) {
                categoryName = ((ISiteCategoryDefinition)element).getName();
            } else if (element instanceof SiteFeatureAdapter) {
                categoryName = ((SiteFeatureAdapter)element).category;
            } else if (element instanceof SiteBundleAdapter) {
                categoryName = ((SiteBundleAdapter)element).category;
            }
        }
        ISiteBundle[] added = new ISiteBundle[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IPluginModelBase candidate = (IPluginModelBase)candidates[i];
            ISiteBundle child = this.createSiteBundle(this.fModel, candidate);
            if (categoryName != null) {
                this.addCategory(child, categoryName);
            }
            added[i] = child;
            ++i;
        }
        this.fModel.getSite().addBundles(added);
        if (added.length > 0) {
            if (categoryName != null) {
                this.expandCategory(categoryName);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteBundleAdapter(categoryName, added[added.length - 1])), true);
        }
    }

    void fireSelection() {
        this.fCategoryViewer.setSelection(this.fCategoryViewer.getSelection());
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ISiteCategoryDefinition) {
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        if (input instanceof SiteFeatureAdapter) {
            String category = ((SiteFeatureAdapter)input).category;
            if (category != null) {
                this.expandCategory(category);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    private void expandCategory(String category) {
        if (category != null) {
            ISiteCategoryDefinition[] catDefs = this.fModel.getSite().getCategoryDefinitions();
            int i = 0;
            while (i < catDefs.length) {
                if (category.equals(catDefs[i].getName())) {
                    this.fCategoryViewer.expandToLevel((Object)catDefs[i], 1);
                    break;
                }
                ++i;
            }
        }
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.markStale();
    }

    class CategoryContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> result = new ArrayList<Object>();
            ISiteCategoryDefinition[] catDefs = CategorySection.this.fModel.getSite().getCategoryDefinitions();
            int i = 0;
            while (i < catDefs.length) {
                result.add(catDefs[i]);
                ++i;
            }
            ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
            int i2 = 0;
            while (i2 < features.length) {
                if (features[i2].getCategories().length == 0) {
                    result.add(new SiteFeatureAdapter(null, features[i2]));
                }
                ++i2;
            }
            ISiteBundle[] bundles = CategorySection.this.fModel.getSite().getBundles();
            int i3 = 0;
            while (i3 < bundles.length) {
                if (bundles[i3].getCategories().length == 0) {
                    result.add(new SiteBundleAdapter(null, bundles[i3]));
                }
                ++i3;
            }
            return result.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ISiteCategoryDefinition) {
                ISiteCategoryDefinition catDef = (ISiteCategoryDefinition)parent;
                ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
                HashSet<Serializable> result = new HashSet<Serializable>();
                int i = 0;
                while (i < features.length) {
                    ISiteCategory[] cats = features[i].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            result.add(new SiteFeatureAdapter(cats[j].getName(), features[i]));
                        }
                        ++j;
                    }
                    ++i;
                }
                ISiteBundle[] bundles = CategorySection.this.fModel.getSite().getBundles();
                int i2 = 0;
                while (i2 < bundles.length) {
                    ISiteCategory[] cats = bundles[i2].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            result.add(new SiteBundleAdapter(cats[j].getName(), bundles[i2]));
                        }
                        ++j;
                    }
                    ++i2;
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ISiteCategoryDefinition) {
                ISiteCategoryDefinition catDef = (ISiteCategoryDefinition)element;
                ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
                int i = 0;
                while (i < features.length) {
                    ISiteCategory[] cats = features[i].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
                ISiteBundle[] bundles = CategorySection.this.fModel.getSite().getBundles();
                int i2 = 0;
                while (i2 < bundles.length) {
                    ISiteCategory[] cats = bundles[i2].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            return false;
        }
    }
}

