/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.stem.core.graph.provider.EdgeItemProvider;
import org.eclipse.stem.core.graph.provider.ExchangeItemProvider;
import org.eclipse.stem.core.graph.provider.GraphItemProvider;
import org.eclipse.stem.core.graph.provider.NodeItemProvider;
import org.eclipse.stem.core.graph.provider.SimpleGraphPartitionerItemProvider;
import org.eclipse.stem.core.graph.util.GraphAdapterFactory;

public class GraphItemProviderAdapterFactory
extends GraphAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Disposable disposable = new Disposable();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected EdgeItemProvider edgeItemProvider;
    protected NodeItemProvider nodeItemProvider;
    protected SimpleGraphPartitionerItemProvider simpleGraphPartitionerItemProvider;
    protected ExchangeItemProvider exchangeItemProvider;

    public GraphItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    @Override
    public Adapter createEdgeAdapter() {
        if (this.edgeItemProvider == null) {
            this.edgeItemProvider = new EdgeItemProvider((AdapterFactory)this);
        }
        return this.edgeItemProvider;
    }

    @Override
    public Adapter createGraphAdapter() {
        return new GraphItemProvider((AdapterFactory)this);
    }

    @Override
    public Adapter createNodeAdapter() {
        if (this.nodeItemProvider == null) {
            this.nodeItemProvider = new NodeItemProvider((AdapterFactory)this);
        }
        return this.nodeItemProvider;
    }

    @Override
    public Adapter createSimpleGraphPartitionerAdapter() {
        if (this.simpleGraphPartitionerItemProvider == null) {
            this.simpleGraphPartitionerItemProvider = new SimpleGraphPartitionerItemProvider((AdapterFactory)this);
        }
        return this.simpleGraphPartitionerItemProvider;
    }

    @Override
    public Adapter createExchangeAdapter() {
        if (this.exchangeItemProvider == null) {
            this.exchangeItemProvider = new ExchangeItemProvider((AdapterFactory)this);
        }
        return this.exchangeItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected void associate(Adapter adapter, Notifier target) {
        super.associate(adapter, target);
        if (adapter != null) {
            this.disposable.add((Object)adapter);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        this.disposable.dispose();
    }
}

