/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ApiDescriptionProcessor;
import org.eclipse.pde.api.tools.internal.BundleVersionRange;
import org.eclipse.pde.api.tools.internal.CompositeApiDescription;
import org.eclipse.pde.api.tools.internal.FilterStore;
import org.eclipse.pde.api.tools.internal.RequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.Component;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.ProfileModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.eclipse.pde.api.tools.internal.util.SourceDefaultHandler;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BundleComponent
extends Component {
    static final String TMP_API_FILE_PREFIX = "api";
    static final String TMP_API_FILE_POSTFIX = "tmp";
    private Map<String, String> fManifest;
    private static final String[] MANIFEST_HEADERS = new String[]{"Eclipse-SourceBundle", "Bundle-ClassPath", "Bundle-Name", "Bundle-Version"};
    private boolean fHasApiDescription = false;
    private String fLocation;
    private BundleDescription fBundleDescription;
    private String fSymbolicName = null;
    private Version fVersion = null;
    private String[] lowestEEs;
    private boolean fWorkspaceBinary = false;
    private long fBundleId = 0L;

    public BundleComponent(IApiBaseline baseline, String location, long bundleid) throws CoreException {
        super(baseline);
        this.fLocation = location;
        this.fBundleId = bundleid;
        this.fWorkspaceBinary = this.isBinary() && "workspace".equals(baseline.getName()) && !new File(location).isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            super.dispose();
        }
        catch (Throwable throwable) {
            BundleComponent bundleComponent = this;
            synchronized (bundleComponent) {
                this.fManifest = null;
                this.fBundleDescription = null;
            }
            throw throwable;
        }
        BundleComponent bundleComponent = this;
        synchronized (bundleComponent) {
            this.fManifest = null;
            this.fBundleDescription = null;
        }
    }

    protected synchronized Map<String, String> getManifest() throws CoreException {
        if (this.fManifest == null) {
            try {
                this.fManifest = ManifestUtils.loadManifest((File)new File(this.fLocation));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 204) {
                    return null;
                }
                throw e;
            }
            if (this.isWorkspaceBinary()) {
                TargetWeaver.weaveManifest(this.fManifest);
            }
        }
        return this.fManifest;
    }

    protected synchronized void doManifestCompaction() {
        Map<String, String> temp = this.fManifest;
        this.fManifest = new Hashtable<String, String>(MANIFEST_HEADERS.length, 1.0f);
        String[] stringArray = MANIFEST_HEADERS;
        int n = MANIFEST_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            String value = temp.get(header);
            if (value != null) {
                this.fManifest.put(header, value);
            }
            ++n2;
        }
    }

    public boolean isValidBundle() throws CoreException {
        Map<String, String> manifest = this.getManifest();
        return manifest != null && manifest.get("Bundle-Name") != null && manifest.get("Bundle-Version") != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleComponent) {
            BundleComponent comp = (BundleComponent)obj;
            return this.getName().equals(comp.getName()) && this.getSymbolicName().equals(comp.getSymbolicName()) && this.getVersion().equals(comp.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getSymbolicName().hashCode() + this.getVersion().hashCode();
    }

    protected synchronized void init() {
        if (this.fBundleDescription != null) {
            return;
        }
        try {
            Map<String, String> manifest = this.getManifest();
            if (manifest == null) {
                ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Unable to find a manifest for the component from: " + this.fLocation, null));
                return;
            }
            this.fBundleDescription = this.getBundleDescription(manifest, this.fLocation, this.fBundleId);
            this.fSymbolicName = this.fBundleDescription.getSymbolicName();
            this.fVersion = this.fBundleDescription.getVersion();
            this.setName(manifest.get("Bundle-Name"));
        }
        catch (BundleException e) {
            ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Unable to create API component from specified location: " + this.fLocation, (Throwable)e));
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
        this.doManifestCompaction();
    }

    public boolean isWorkspaceBinary() {
        return this.fWorkspaceBinary;
    }

    protected State getState() {
        return ((ApiBaseline)this.getBaseline()).getState();
    }

    protected BundleDescription getBundleDescription(Map<String, String> manifest, String location, long id) throws BundleException {
        State state = this.getState();
        BundleDescription bundle = this.lookupBundle(state, manifest);
        if (bundle != null) {
            return bundle;
        }
        StateObjectFactory factory = StateObjectFactory.defaultFactory;
        Hashtable<String, String> dictionaryManifest = new Hashtable<String, String>(manifest);
        bundle = factory.createBundleDescription(state, dictionaryManifest, this.fLocation, id);
        state.addBundle(bundle);
        return bundle;
    }

    protected BundleDescription lookupBundle(State state, Map<String, String> manifest) throws BundleException {
        Version version = null;
        try {
            String ver = manifest.get("Bundle-Version");
            version = ver != null ? new Version(ver) : null;
        }
        catch (NumberFormatException numberFormatException) {}
        ManifestElement[] name = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)manifest.get("Bundle-SymbolicName"));
        if (name.length < 1) {
            return null;
        }
        return state.getBundle(name[0].getValue(), version);
    }

    protected boolean isBinary() {
        return true;
    }

    @Override
    protected IApiDescription createApiDescription() throws CoreException {
        BundleDescription[] fragments = this.getBundleDescription().getFragments();
        if (fragments.length == 0) {
            return this.createLocalApiDescription();
        }
        ArrayList<IApiDescription> descriptions = new ArrayList<IApiDescription>(fragments.length);
        descriptions.add(this.createLocalApiDescription());
        IApiComponent component = null;
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                component = this.getBaseline().getApiComponent(fragments[i].getSymbolicName());
                if (component != null) {
                    descriptions.add(component.getApiDescription());
                } else {
                    ApiPlugin.log((IStatus)new Status(2, "org.eclipse.pde.api.tools", NLS.bind((String)Messages.BundleComponent_failed_to_lookup_fragment, (Object)fragments[i].getSymbolicName())));
                }
            }
            ++i;
        }
        return new CompositeApiDescription(descriptions.toArray(new IApiDescription[descriptions.size()]));
    }

    protected IApiDescription createLocalApiDescription() throws CoreException {
        ApiDescription apiDesc = new ApiDescription(this.getSymbolicName());
        BundleComponent.initializeApiDescription(apiDesc, this.getBundleDescription(), this.getLocalPackageNames());
        try {
            String xml = this.loadApiDescription(new File(this.fLocation));
            this.setHasApiDescription(xml != null);
            if (xml != null) {
                ApiDescriptionProcessor.annotateApiSettings(null, apiDesc, xml);
            }
        }
        catch (IOException e) {
            this.abort("Unable to load .api_description file ", e);
        }
        return apiDesc;
    }

    protected Set<String> getLocalPackageNames() throws CoreException {
        HashSet<String> names = new HashSet<String>();
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        IApiComponent comp = null;
        IApiTypeContainer[] iApiTypeContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            comp = (IApiComponent)container.getAncestor(1);
            if (comp != null && comp.getSymbolicName().equals(this.getSymbolicName())) {
                String[] packageNames;
                String[] stringArray = packageNames = container.getPackageNames();
                int n3 = packageNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String packageName = stringArray[n4];
                    names.add(packageName);
                    ++n4;
                }
            }
            ++n2;
        }
        return names;
    }

    public static void initializeApiDescription(IApiDescription apiDesc, BundleDescription bundle, Set<String> packages) throws CoreException {
        for (String name : packages) {
            apiDesc.setVisibility(Factory.packageDescriptor(name), 2);
        }
        ArrayList<ExportPackageDescription> supplied = new ArrayList<ExportPackageDescription>();
        ExportPackageDescription[] exportPackages = bundle.getExportPackages();
        BundleComponent.addSuppliedPackages(packages, supplied, exportPackages);
        HostSpecification host = bundle.getHost();
        if (host != null) {
            BundleDescription[] hosts;
            BundleDescription[] bundleDescriptionArray = hosts = host.getHosts();
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundleDescription = bundleDescriptionArray[n2];
                BundleComponent.addSuppliedPackages(packages, supplied, bundleDescription.getExportPackages());
                ++n2;
            }
        }
        BundleDescription[] fragments = bundle.getFragments();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                BundleComponent.addSuppliedPackages(packages, supplied, fragments[i].getExportPackages());
            }
            ++i;
        }
        BundleComponent.annotateExportedPackages(apiDesc, supplied.toArray(new ExportPackageDescription[supplied.size()]));
    }

    protected static void addSuppliedPackages(Set<String> packages, List<ExportPackageDescription> supplied, ExportPackageDescription[] exportPackages) {
        ExportPackageDescription[] exportPackageDescriptionArray = exportPackages;
        int n = exportPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
            String name = pkg.getName();
            if (name.equals(".")) {
                name = "";
            }
            if (packages.contains(name)) {
                supplied.add(pkg);
            }
            ++n2;
        }
    }

    protected static void annotateExportedPackages(IApiDescription apiDesc, ExportPackageDescription[] exportedPackages) {
        ExportPackageDescription[] exportPackageDescriptionArray = exportedPackages;
        int n = exportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
            boolean internal = (Boolean)pkg.getDirective("x-internal");
            String[] friends = (String[])pkg.getDirective("x-friends");
            String pkgName = pkg.getName();
            if (pkgName.equals(".")) {
                pkgName = "";
            }
            IPackageDescriptor pkgDesc = Factory.packageDescriptor(pkgName);
            if (internal) {
                apiDesc.setVisibility(pkgDesc, 2);
            }
            if (friends != null) {
                apiDesc.setVisibility(pkgDesc, 2);
                String[] stringArray = friends;
                int n3 = friends.length;
                int n4 = 0;
                while (n4 < n3) {
                    String friend = stringArray[n4];
                    apiDesc.setAccessLevel(Factory.componentDescriptor(friend), Factory.packageDescriptor(pkgName), 1);
                    ++n4;
                }
            }
            if (!internal && friends == null) {
                apiDesc.setVisibility(pkgDesc, 1);
            }
            ++n2;
        }
    }

    @Override
    protected IApiFilterStore createApiFilterStore() throws CoreException {
        return new FilterStore(this);
    }

    @Override
    protected synchronized List<IApiTypeContainer> createApiTypeContainers() throws CoreException {
        ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>(5);
        ArrayList<IApiComponent> all = new ArrayList<IApiComponent>();
        all.add(this);
        boolean considerFragments = true;
        if ("org.eclipse.swt".equals(this.getSymbolicName())) {
            boolean bl = considerFragments = !this.isApiEnabled();
        }
        if (considerFragments) {
            BundleDescription[] fragments = this.getBundleDescription().getFragments();
            IApiComponent component = null;
            int i = 0;
            while (i < fragments.length) {
                if (fragments[i].isResolved() && (component = this.getBaseline().getApiComponent(fragments[i].getSymbolicName())) != null) {
                    component.getApiTypeContainers();
                    all.add(component);
                }
                ++i;
            }
        }
        Iterator iterator = all.iterator();
        HashSet<String> entryNames = new HashSet<String>(5);
        BundleComponent other = null;
        while (iterator.hasNext()) {
            BundleComponent component = (BundleComponent)iterator.next();
            Map<String, String> manifest = component.getManifest();
            if (manifest == null) continue;
            try {
                String[] paths;
                String[] stringArray = paths = this.getClasspathEntries(manifest);
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    if (".".equals(path) || !entryNames.contains(path)) {
                        IApiTypeContainer container = component.createApiTypeContainer(path);
                        if (container == null) {
                            for (IApiComponent iApiComponent : all) {
                                other = (BundleComponent)iApiComponent;
                                if (other == component) continue;
                                container = other.createApiTypeContainer(path);
                            }
                        }
                        if (container != null) {
                            containers.add(container);
                            if (!".".equals(path)) {
                                entryNames.add(path);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (BundleException e) {
                this.abort("Unable to parse bundle-classpath entry of manifest for bundle at " + component.getLocation(), e);
            }
        }
        return containers;
    }

    protected boolean isApiEnabled() {
        return false;
    }

    protected String[] getClasspathEntries(Map<String, String> manifest) throws BundleException {
        ManifestElement[] classpath = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)manifest.get("Bundle-ClassPath"));
        String[] elements = null;
        if (classpath == null) {
            elements = new String[]{"."};
        } else {
            elements = new String[classpath.length];
            int i = 0;
            while (i < classpath.length) {
                elements[i] = classpath[i].getValue();
                ++i;
            }
        }
        return elements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IApiTypeContainer createApiTypeContainer(String path) throws CoreException {
        try {
            File bundle = new File(this.fLocation);
            if (bundle.isDirectory()) {
                File entry = new File(bundle, path);
                if (!entry.exists()) return null;
                if (!entry.isFile()) return new DirectoryApiTypeContainer(this, entry.getCanonicalPath());
                return new ArchiveApiTypeContainer(this, entry.getCanonicalPath());
            }
            try (ZipFile zip = null;){
                if (path.equals(".")) {
                    ArchiveApiTypeContainer archiveApiTypeContainer = new ArchiveApiTypeContainer(this, this.fLocation);
                    return archiveApiTypeContainer;
                }
                zip = new ZipFile(this.fLocation);
                ZipEntry entry = zip.getEntry(path);
                if (entry == null) return null;
                File tmpfolder = new File(System.getProperty("java.io.tmpdir"));
                if (entry.isDirectory()) {
                    File dir = Util.createTempFile(TMP_API_FILE_PREFIX, TMP_API_FILE_POSTFIX);
                    if (dir.delete()) {
                        dir.mkdir();
                        FileManager.getManager().recordTempFileRoot(dir.getCanonicalPath());
                    }
                    this.extractDirectory(zip, entry.getName(), dir);
                    if (!dir.isDirectory()) return null;
                    if (!dir.exists()) return null;
                    DirectoryApiTypeContainer directoryApiTypeContainer = new DirectoryApiTypeContainer(this, dir.getCanonicalPath());
                    return directoryApiTypeContainer;
                }
                File file = this.extractEntry(zip, entry, tmpfolder);
                if (!Util.isArchive(file.getName())) return null;
                File parent = file.getParentFile();
                if (!parent.equals(tmpfolder)) {
                    FileManager.getManager().recordTempFileRoot(parent.getCanonicalPath());
                } else {
                    FileManager.getManager().recordTempFileRoot(file.getCanonicalPath());
                }
                ArchiveApiTypeContainer archiveApiTypeContainer = new ArchiveApiTypeContainer(this, file.getCanonicalPath());
                return archiveApiTypeContainer;
            }
        }
        catch (IOException e) {
            this.abort("Problem creating api type container for path " + path + " in bundle at " + this.fLocation, e);
        }
        return null;
    }

    void extractDirectory(ZipFile zip, String pathprefix, File parent) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        String prefix = pathprefix == null ? "" : pathprefix;
        ZipEntry entry = null;
        File file = null;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (!entry.getName().startsWith(prefix)) continue;
            file = new File(parent, entry.getName());
            if (entry.isDirectory()) {
                file.mkdir();
                continue;
            }
            this.extractEntry(zip, entry, parent);
        }
    }

    File extractEntry(ZipFile zip, ZipEntry entry, File parent) throws IOException {
        File file;
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = zip.getInputStream(entry);
            file = new File(parent, entry.getName());
            File lparent = file.getParentFile();
            if (!lparent.exists()) {
                lparent.mkdirs();
            }
            outputStream = new FileOutputStream(file);
            byte[] bytes = new byte[8096];
            while (inputStream.available() > 0) {
                int read = inputStream.read(bytes);
                if (read <= 0) continue;
                outputStream.write(bytes, 0, read);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return file;
    }

    public void closingZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
    }

    protected String readFileContents(String xmlFileName, File bundleLocation) {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry(xmlFileName);
                if (manifestEntry != null) {
                    stream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, xmlFileName);
                if (file.exists()) {
                    stream = new FileInputStream(file);
                }
            }
            if (stream == null) {
                this.closingZipFileAndStream(stream, jarFile);
                return null;
            }
            String string = new String(Util.getInputStreamAsCharArray(stream, -1, StandardCharsets.UTF_8));
            this.closingZipFileAndStream(stream, jarFile);
            return string;
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        finally {
            this.closingZipFileAndStream(stream, jarFile);
        }
        return null;
    }

    protected String loadApiDescription(File bundleLocation) throws IOException {
        String contents;
        InputStream stream;
        ZipFile jarFile;
        block7: {
            jarFile = null;
            stream = null;
            contents = null;
            try {
                String extension = new Path(bundleLocation.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry(".api_description");
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, ".api_description");
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                }
                if (stream != null) break block7;
                this.closingZipFileAndStream(stream, jarFile);
                return null;
            }
            catch (Throwable throwable) {
                this.closingZipFileAndStream(stream, jarFile);
                throw throwable;
            }
        }
        char[] charArray = Util.getInputStreamAsCharArray(stream, -1, StandardCharsets.UTF_8);
        contents = new String(charArray);
        this.closingZipFileAndStream(stream, jarFile);
        return contents;
    }

    protected URL getFileInBundle(File bundleLocation, String filePath) throws MalformedURLException {
        String extension = new Path(bundleLocation.getName()).getFileExtension();
        StringBuilder urlSt = new StringBuilder();
        if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
            urlSt.append("jar:file:");
            urlSt.append(bundleLocation.getAbsolutePath());
            urlSt.append("!/");
            urlSt.append(filePath);
        } else {
            urlSt.append("file:");
            urlSt.append(bundleLocation.getAbsolutePath());
            urlSt.append(File.separatorChar);
            urlSt.append(filePath);
        }
        return new URL(urlSt.toString());
    }

    @Override
    public synchronized String[] getExecutionEnvironments() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed(this.getBaseline());
        }
        return this.fBundleDescription.getExecutionEnvironments();
    }

    @Override
    public final String getSymbolicName() {
        this.init();
        return this.fSymbolicName;
    }

    @Override
    public synchronized IRequiredComponentDescription[] getRequiredComponents() throws CoreException {
        if (this.fBundleDescription == null) {
            this.baselineDisposed(this.getBaseline());
        }
        BundleSpecification[] requiredBundles = this.fBundleDescription.getRequiredBundles();
        IRequiredComponentDescription[] req = new IRequiredComponentDescription[requiredBundles.length];
        int i = 0;
        while (i < requiredBundles.length) {
            BundleSpecification bundle = requiredBundles[i];
            req[i] = new RequiredComponentDescription(bundle.getName(), new BundleVersionRange(bundle.getVersionRange()), bundle.isOptional(), bundle.isExported());
            ++i;
        }
        return req;
    }

    @Override
    public synchronized String getVersion() {
        this.init();
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.fVersion.getMajor()).append('.').append(this.fVersion.getMinor()).append('.').append(this.fVersion.getMicro());
        return String.valueOf(buffer);
    }

    @Override
    public String getName() {
        this.init();
        return super.getName();
    }

    public synchronized BundleDescription getBundleDescription() throws CoreException {
        this.init();
        if (this.fBundleDescription == null) {
            this.baselineDisposed(this.getBaseline());
        }
        return this.fBundleDescription;
    }

    public String toString() {
        if (this.fBundleDescription != null) {
            try {
                StringBuilder buffer = new StringBuilder();
                buffer.append(this.fBundleDescription.toString());
                buffer.append(" - ");
                buffer.append("[fragment: ").append(this.isFragment()).append("] ");
                buffer.append("[host: ").append(this.fBundleDescription.getFragments().length > 0).append("] ");
                buffer.append("[system bundle: ").append(this.isSystemComponent()).append("] ");
                buffer.append("[source bundle: ").append(this.isSourceComponent()).append("] ");
                buffer.append("[dev bundle: ").append(this.fWorkspaceBinary).append("]");
                return buffer.toString();
            }
            catch (CoreException coreException) {}
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Un-initialized Bundle Component");
            buffer.append("[location: ").append(this.fLocation).append("]");
            buffer.append("[dev bundle: ").append(this.fWorkspaceBinary).append("]");
            return buffer.toString();
        }
        return super.toString();
    }

    @Override
    public String getLocation() {
        return this.fLocation;
    }

    @Override
    public boolean isSystemComponent() {
        return false;
    }

    @Override
    public synchronized boolean isSourceComponent() throws CoreException {
        Map<String, String> manifest = this.getManifest();
        if (manifest == null) {
            this.baselineDisposed(this.getBaseline());
        }
        ManifestElement[] sourceBundle = null;
        try {
            sourceBundle = ManifestElement.parseHeader((String)"Eclipse-SourceBundle", (String)manifest.get("Eclipse-SourceBundle"));
        }
        catch (BundleException bundleException) {}
        if (sourceBundle != null) {
            return true;
        }
        String pluginXMLContents = this.readFileContents("plugin.xml", new File(this.getLocation()));
        if (pluginXMLContents != null && this.containsSourceExtensionPoint(pluginXMLContents)) {
            return true;
        }
        pluginXMLContents = this.readFileContents("fragment.xml", new File(this.getLocation()));
        return pluginXMLContents != null && this.containsSourceExtensionPoint(pluginXMLContents);
    }

    private boolean containsSourceExtensionPoint(String pluginXMLContents) {
        SAXParserFactory factory = null;
        try {
            factory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return false;
        }
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        if (saxParser == null) {
            return false;
        }
        InputSource inputSource = new InputSource(new BufferedReader(new StringReader(pluginXMLContents)));
        try {
            SourceDefaultHandler defaultHandler = new SourceDefaultHandler();
            saxParser.parse(inputSource, (DefaultHandler)defaultHandler);
            return defaultHandler.isSource();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    @Override
    public synchronized boolean isFragment() throws CoreException {
        this.init();
        if (this.fBundleDescription == null) {
            this.baselineDisposed(this.getBaseline());
        }
        return this.fBundleDescription.getHost() != null;
    }

    @Override
    public synchronized IApiComponent getHost() throws CoreException {
        HostSpecification host;
        this.init();
        if (this.fBundleDescription == null) {
            this.baselineDisposed(this.getBaseline());
        }
        if ((host = this.fBundleDescription.getHost()) != null) {
            return this.getBaseline().getApiComponent(host.getName());
        }
        return null;
    }

    @Override
    public synchronized boolean hasFragments() throws CoreException {
        return this.getBundleDescription().getFragments().length != 0;
    }

    protected void setHasApiDescription(boolean hasApiDescription) {
        this.fHasApiDescription = hasApiDescription;
    }

    @Override
    public boolean hasApiDescription() {
        try {
            this.getApiDescription();
        }
        catch (CoreException e) {
            ApiPlugin.log("Failed to create API description for " + this.getName(), e);
        }
        return this.fHasApiDescription;
    }

    @Override
    public String[] getLowestEEs() throws CoreException {
        if (this.lowestEEs != null) {
            return this.lowestEEs;
        }
        String[] temp = null;
        String[] executionEnvironments = this.getExecutionEnvironments();
        int length = executionEnvironments.length;
        switch (length) {
            case 0: {
                return null;
            }
            case 1: {
                temp = new String[]{executionEnvironments[0]};
                break;
            }
            default: {
                int tempLength;
                int values = 0;
                int i = 0;
                while (i < length) {
                    values |= ProfileModifiers.getValue(executionEnvironments[i]);
                    ++i;
                }
                if (ProfileModifiers.isJRE(values)) {
                    temp = ProfileModifiers.isJRE_1_1(values) ? new String[]{"JRE-1.1"} : (ProfileModifiers.isJ2SE_1_2(values) ? new String[]{"J2SE-1.2"} : (ProfileModifiers.isJ2SE_1_3(values) ? new String[]{"J2SE-1.3"} : (ProfileModifiers.isJ2SE_1_4(values) ? new String[]{"J2SE-1.4"} : (ProfileModifiers.isJ2SE_1_5(values) ? new String[]{"J2SE-1.5"} : (ProfileModifiers.isJAVASE_1_6(values) ? new String[]{"JavaSE-1.6"} : (ProfileModifiers.isJAVASE_1_7(values) ? new String[]{"JavaSE-1.7"} : (ProfileModifiers.isJAVASE_1_8(values) ? new String[]{"JavaSE-1.8"} : new String[]{"JavaSE-9"})))))));
                }
                if (ProfileModifiers.isCDC_Foundation(values)) {
                    temp = ProfileModifiers.isCDC_1_0_FOUNDATION_1_0(values) ? (temp != null ? new String[]{temp[0], "CDC-1.0/Foundation-1.0"} : new String[]{"CDC-1.0/Foundation-1.0"}) : (temp != null ? new String[]{temp[0], "CDC-1.1/Foundation-1.1"} : new String[]{"CDC-1.1/Foundation-1.1"});
                }
                if (!ProfileModifiers.isOSGi(values)) break;
                if (ProfileModifiers.isOSGI_MINIMUM_1_0(values)) {
                    if (temp != null) {
                        tempLength = temp.length;
                        String[] stringArray = temp;
                        temp = new String[tempLength + 1];
                        System.arraycopy(stringArray, 0, temp, 0, tempLength);
                        temp[tempLength] = "OSGi/Minimum-1.0";
                        break;
                    }
                    temp = new String[]{"OSGi/Minimum-1.0"};
                    break;
                }
                if (ProfileModifiers.isOSGI_MINIMUM_1_1(values)) {
                    if (temp != null) {
                        tempLength = temp.length;
                        String[] stringArray = temp;
                        temp = new String[tempLength + 1];
                        System.arraycopy(stringArray, 0, temp, 0, tempLength);
                        temp[tempLength] = "OSGi/Minimum-1.1";
                        break;
                    }
                    temp = new String[]{"OSGi/Minimum-1.1"};
                    break;
                }
                if (temp != null) {
                    tempLength = temp.length;
                    String[] stringArray = temp;
                    temp = new String[tempLength + 1];
                    System.arraycopy(stringArray, 0, temp, 0, tempLength);
                    temp[tempLength] = "OSGi/Minimum-1.2";
                    break;
                }
                temp = new String[]{"OSGi/Minimum-1.2"};
            }
        }
        this.lowestEEs = temp;
        return temp;
    }

    @Override
    public synchronized ResolverError[] getErrors() throws CoreException {
        this.init();
        ApiBaseline baseline = (ApiBaseline)this.getBaseline();
        if (this.fBundleDescription == null) {
            this.baselineDisposed(baseline);
        }
        if (baseline != null) {
            ResolverError[] resolverErrors = baseline.getState().getResolverErrors(this.fBundleDescription);
            if (resolverErrors.length == 0) {
                return null;
            }
            return resolverErrors;
        }
        return null;
    }

    protected void baselineDisposed(IApiBaseline baseline) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 123, NLS.bind((String)Messages.BundleApiComponent_baseline_disposed, (Object)baseline.getName()), null));
    }
}

