/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MatrixEditorWidget
extends Composite {
    private short rows;
    short dynrows;
    short columns;
    private String[] rowNames;
    private String[] colNames;
    private boolean fixedSize;
    private Color colRowHeaderColumns = new Color(null, 200, 200, 200);
    private Color textBackgroundColumns = new Color(null, 255, 255, 255);
    private Color textBorderColor = new Color(null, 0, 0, 0);
    ArrayList<Text> textWidgets = new ArrayList();
    ArrayList<String> textValues = new ArrayList();
    MatrixEditorValidator validator = null;
    private ArrayList<MatrixEditorListener> listeners = new ArrayList();
    Label status = null;
    Button currentPlusButton;
    Button currentMinusButton;
    ArrayList<Label> emptyLabels = new ArrayList();

    public MatrixEditorWidget(Composite parent, int style, short rows, short columns, String[] rownames, String[] columnNames, String[] existingVals, boolean fixedSize, MatrixEditorValidator validator) {
        super(parent, style);
        this.rows = rows;
        this.dynrows = rows;
        this.columns = columns;
        this.rowNames = rownames;
        this.colNames = columnNames;
        this.validator = validator;
        this.fixedSize = fixedSize;
        this.createContents(existingVals);
    }

    protected void createContents(String[] existingVals) {
        GridData gd;
        this.setBackground(new Color(null, 255, 255, 255));
        GridLayout layout = new GridLayout();
        layout.numColumns = this.columns + 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        this.setLayout((Layout)layout);
        this.status = new Label((Composite)this, 0);
        this.status.setForeground(new Color(null, 255, 0, 0));
        GridData sgd = new GridData();
        sgd.horizontalSpan = this.rowNames != null && this.rowNames.length > 0 || !this.fixedSize ? this.columns + 1 : (int)this.columns;
        this.status.setLayoutData((Object)sgd);
        this.status.setText("");
        if (this.rowNames != null && this.rowNames.length > 0 || !this.fixedSize) {
            Label lab = new Label((Composite)this, 0);
            lab.setText("");
            GridData gd2 = new GridData();
            lab.setLayoutData((Object)gd2);
        }
        if (this.colNames != null) {
            int c = 0;
            while (c < this.colNames.length) {
                Label lab = new Label((Composite)this, 2048);
                lab.setText(this.colNames[c]);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.grabExcessVerticalSpace = false;
                gd.horizontalIndent = 1;
                gd.verticalIndent = 1;
                gd.minimumWidth = 128;
                lab.setLayoutData((Object)gd);
                lab.setBackground(this.colRowHeaderColumns);
                this.addBorder((Control)lab);
                ++c;
            }
        }
        int r = 0;
        while (r < this.rows) {
            if (this.rowNames != null && this.rowNames.length > r || !this.fixedSize) {
                Label lab = new Label((Composite)this, 2048);
                if (this.fixedSize) {
                    lab.setText(this.rowNames[r]);
                } else {
                    lab.setText("");
                }
                gd = new GridData();
                gd.horizontalAlignment = 4;
                lab.setLayoutData((Object)gd);
                if (this.fixedSize) {
                    lab.setBackground(this.colRowHeaderColumns);
                } else {
                    lab.setBackground(new Color(null, 255, 255, 255));
                }
                if (this.fixedSize) {
                    this.addBorder((Control)lab);
                }
                this.emptyLabels.add(lab);
            }
            int c = 0;
            while (c < this.columns) {
                Text t = this.addTextField();
                int index = r * this.columns + c;
                if (existingVals != null && existingVals.length > index) {
                    t.setText(existingVals[index]);
                }
                ++c;
            }
            ++r;
        }
        if (!this.fixedSize) {
            this.currentPlusButton = this.addPlusButton();
            this.currentMinusButton = this.addMinusButton();
            if (this.rows < 2) {
                this.currentMinusButton.setEnabled(false);
            }
        }
    }

    Text addTextField() {
        final Text text = new Text((Composite)this, 0);
        text.setBackground(this.textBackgroundColumns);
        text.setForeground(this.textBorderColor);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = false;
        gd.horizontalIndent = 1;
        gd.verticalIndent = 1;
        text.setLayoutData((Object)gd);
        this.addBorder((Control)text);
        this.textWidgets.add(text);
        this.textValues.add("");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                boolean problem = false;
                for (Text t : MatrixEditorWidget.this.textWidgets) {
                    String val = t.getText().trim();
                    if (MatrixEditorWidget.this.validator.validateValue(val)) continue;
                    problem = true;
                    MatrixEditorWidget.this.status.setText(MessageFormat.format(Messages.getString("Matrix.invalid.value"), val));
                    MatrixEditorWidget.this.status.pack(true);
                    break;
                }
                if (!problem && !MatrixEditorWidget.this.validator.validateAllValues(MatrixEditorWidget.this.textWidgets)) {
                    problem = true;
                    MatrixEditorWidget.this.status.setText(Messages.getString("Matrix.invalid.sum"));
                    MatrixEditorWidget.this.status.pack(true);
                }
                if (!problem) {
                    MatrixEditorWidget.this.status.setText("");
                    MatrixEditorWidget.this.status.pack(true);
                    MatrixEditorWidget.this.fireEvent(new MatrixEditorEvent(STATUS.OKAY));
                } else {
                    MatrixEditorWidget.this.fireEvent(new MatrixEditorEvent(STATUS.INVALID_VALUE));
                }
                int index = MatrixEditorWidget.this.textWidgets.indexOf(text);
                MatrixEditorWidget.this.textValues.set(index, text.getText());
            }
        });
        return text;
    }

    Button addPlusButton() {
        Button plusButton = new Button((Composite)this, 0);
        GridData gd = new GridData();
        plusButton.setText(Messages.getString("Matrix.dialog.plus"));
        plusButton.setLayoutData((Object)gd);
        plusButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                MatrixEditorWidget.this.currentMinusButton.setEnabled(true);
                MatrixEditorWidget.this.dynrows = (short)(MatrixEditorWidget.this.dynrows + 1);
                Label lab = new Label((Composite)MatrixEditorWidget.this, 2048);
                lab.setText("");
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                lab.setLayoutData((Object)gd);
                lab.setBackground(new Color(null, 255, 255, 255));
                MatrixEditorWidget.this.emptyLabels.add(lab);
                Text lastText = null;
                int i = 0;
                while (i < MatrixEditorWidget.this.columns) {
                    lastText = MatrixEditorWidget.this.addTextField();
                    ++i;
                }
                MatrixEditorWidget.this.currentPlusButton.moveBelow((Control)lastText);
                MatrixEditorWidget.this.currentMinusButton.moveBelow((Control)MatrixEditorWidget.this.currentPlusButton);
                lastText.setText(lastText.getText());
                MatrixEditorWidget.this.layout(true);
                MatrixEditorWidget.this.pack(true);
                MatrixEditorWidget.this.getParent().pack(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return plusButton;
    }

    Button addMinusButton() {
        Button minusButton = new Button((Composite)this, 0);
        GridData gd = new GridData();
        minusButton.setText(Messages.getString("Matrix.dialog.minus"));
        minusButton.setLayoutData((Object)gd);
        minusButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int i = (MatrixEditorWidget.this.dynrows - 1) * MatrixEditorWidget.this.columns;
                while (i < (MatrixEditorWidget.this.dynrows - 1) * MatrixEditorWidget.this.columns + MatrixEditorWidget.this.columns) {
                    MatrixEditorWidget.this.textWidgets.get(i).dispose();
                    ++i;
                }
                i = 0;
                while (i < MatrixEditorWidget.this.columns) {
                    MatrixEditorWidget.this.textWidgets.remove((MatrixEditorWidget.this.dynrows - 1) * MatrixEditorWidget.this.columns);
                    MatrixEditorWidget.this.textValues.remove((MatrixEditorWidget.this.dynrows - 1) * MatrixEditorWidget.this.columns);
                    ++i;
                }
                Label elab = MatrixEditorWidget.this.emptyLabels.get(MatrixEditorWidget.this.dynrows - 1);
                Text lastText = MatrixEditorWidget.this.textWidgets.get((MatrixEditorWidget.this.dynrows - 2) * MatrixEditorWidget.this.columns + MatrixEditorWidget.this.columns - 1);
                MatrixEditorWidget.this.currentPlusButton.moveBelow((Control)lastText);
                MatrixEditorWidget.this.currentMinusButton.moveBelow((Control)MatrixEditorWidget.this.currentPlusButton);
                elab.dispose();
                MatrixEditorWidget.this.emptyLabels.remove(elab);
                MatrixEditorWidget.this.dynrows = (short)(MatrixEditorWidget.this.dynrows - 1);
                if (MatrixEditorWidget.this.dynrows == 1) {
                    MatrixEditorWidget.this.currentMinusButton.setEnabled(false);
                }
                lastText.setText(lastText.getText());
                MatrixEditorWidget.this.layout(true);
                MatrixEditorWidget.this.pack(true);
                MatrixEditorWidget.this.getParent().pack(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return minusButton;
    }

    private void addBorder(final Control t) {
        t.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                Point s = t.getSize();
                Color c = evt.gc.getForeground();
                evt.gc.setForeground(t.getDisplay().getSystemColor(2));
                evt.gc.drawRectangle(0, 0, s.x - 1, s.y - 1);
                evt.gc.setForeground(c);
            }
        });
    }

    public void addListener(MatrixEditorListener listener) {
        this.listeners.add(listener);
    }

    void fireEvent(MatrixEditorEvent evt) {
        for (MatrixEditorListener l : this.listeners) {
            l.eventReceived(evt);
        }
    }

    public ArrayList<String> getTextValues() {
        return this.textValues;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        FillLayout fl = new FillLayout();
        fl.type = 512;
        shell.setLayout((Layout)fl);
        String[] cn = new String[]{"Population Group"};
        MatrixEditorWidget m = new MatrixEditorWidget((Composite)shell, 8, 1, 1, null, cn, null, false, new MatrixEditorValidator(){

            @Override
            public boolean validateValue(String val) {
                if (val == null || val.trim().equals("")) {
                    return true;
                }
                try {
                    Double.parseDouble(val.trim());
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                return true;
            }

            @Override
            public boolean validateAllValues(List<Text> vals) {
                return true;
            }
        });
        m.addListener(new MatrixEditorListener(){

            @Override
            public void eventReceived(MatrixEditorEvent event) {
                if (event.status == STATUS.OKAY) {
                    Activator.logInformation("okay");
                } else {
                    Activator.logInformation("invalid");
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static class MatrixEditorEvent {
        public STATUS status;

        public MatrixEditorEvent(STATUS s) {
            this.status = s;
        }
    }

    public static interface MatrixEditorListener {
        public void eventReceived(MatrixEditorEvent var1);
    }

    public static interface MatrixEditorValidator {
        public boolean validateValue(String var1);

        public boolean validateAllValues(List<Text> var1);
    }

    public static enum STATUS {
        OKAY,
        INVALID_VALUE;

    }
}

