/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TreeCompoundTask;
import org.eclipse.birt.core.ui.i18n.Messages;
import org.eclipse.birt.core.ui.utils.UIHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;

public class SubtaskHistory {
    private ToolBarManager historyToolbar;
    private List historyList = new ArrayList();
    private int historyIndex = -1;
    private final TreeCompoundTask parentTask;

    public SubtaskHistory(TreeCompoundTask parentTask) {
        this.parentTask = parentTask;
    }

    private String getHistoryEntry(int index) {
        if (index >= 0 && index < this.historyList.size()) {
            return (String)this.historyList.get(index);
        }
        return null;
    }

    public void addHistoryEntry(String entry) {
        if (this.historyIndex == -1 || !this.historyList.get(this.historyIndex).equals(entry)) {
            this.historyList.subList(this.historyIndex + 1, this.historyList.size()).clear();
            this.historyList.add(entry);
            ++this.historyIndex;
            this.updateHistoryControls();
        }
    }

    public void clearHistory() {
        this.historyList.clear();
        this.historyIndex = -1;
        this.updateHistoryControls();
    }

    private void jumpToHistory(int index) {
        if (index >= 0 && index < this.historyList.size()) {
            this.historyIndex = index;
            this.parentTask.switchTo(this.getHistoryEntry(index));
        }
        this.updateHistoryControls();
    }

    private void updateHistoryControls() {
        if (this.historyToolbar != null) {
            this.historyToolbar.update(false);
            IContributionItem[] items = this.historyToolbar.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].update("enabled");
                items[i].update("toolTipText");
                ++i;
            }
        }
    }

    public ToolBar createHistoryControls(ToolBar historyBar, ToolBarManager manager) {
        this.historyToolbar = manager;
        abstract class HistoryNavigationAction
        extends Action
        implements IMenuCreator {
            private Menu lastMenu;
            protected static final int MAX_ENTRIES = 5;

            HistoryNavigationAction() {
                super("", 4);
            }

            public IMenuCreator getMenuCreator() {
                return this;
            }

            public void dispose() {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                    this.lastMenu = null;
                }
            }

            public Menu getMenu(Control parent) {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                }
                this.lastMenu = new Menu(parent);
                this.createEntries(this.lastMenu);
                return this.lastMenu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            protected void addActionToMenu(Menu parent, IAction action) {
                ActionContributionItem item = new ActionContributionItem(action);
                item.fill(parent, -1);
            }

            protected abstract void createEntries(Menu var1);
        }
        HistoryNavigationAction backward = new HistoryNavigationAction(this){
            {
            }

            public void run() {
                int index = historyIndex - 1;
                while (!this.isCurrentEntryAvailable(index)) {
                    --index;
                }
                this.jumpToHistory(index);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = historyIndex > 0;
                if (enabled) {
                    int index = historyIndex - 1;
                    this.setToolTipText(this.isCurrentEntryAvailable(index) ? Messages.getFormattedString("SubtaskHistory.Tooltip.Back", this.getItemText(index)) : "");
                }
                return enabled;
            }

            @Override
            protected void createEntries(Menu menu) {
                int i = historyIndex - 1;
                int j = 0;
                while (i >= 0 && j < 5) {
                    if (this.isCurrentEntryAvailable(i)) {
                        class HistoryItemAction
                        extends Action {
                            private final int index;

                            HistoryItemAction(int index, String label) {
                                super(label, 1);
                                this.index = index;
                            }

                            public void run() {
                                if (SubtaskHistory.this.isCurrentEntryAvailable(this.index)) {
                                    SubtaskHistory.this.jumpToHistory(this.index);
                                }
                            }
                        }
                        HistoryItemAction action = new HistoryItemAction(i, this.getItemText(i));
                        this.addActionToMenu(menu, (IAction)action);
                        ++j;
                    }
                    --i;
                }
            }
        };
        backward.setText(Messages.getString("SubtaskHistory.Text.Back"));
        backward.setActionDefinitionId("org.eclipse.ui.navigate.backwardHistory");
        backward.setImageDescriptor(ImageDescriptor.createFromURL((URL)UIHelper.getURL("icons/obj16/backward_nav.gif")));
        backward.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)UIHelper.getURL("icons/obj16/backward_nav_disabled.gif")));
        this.historyToolbar.add((IAction)backward);
        HistoryNavigationAction forward = new HistoryNavigationAction(this){
            {
            }

            public void run() {
                int index = historyIndex + 1;
                while (!this.isCurrentEntryAvailable(index)) {
                    ++index;
                }
                this.jumpToHistory(index);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = historyIndex < historyList.size() - 1;
                if (enabled) {
                    int index = historyIndex + 1;
                    this.setToolTipText(this.isCurrentEntryAvailable(index) ? Messages.getFormattedString("SubtaskHistory.Tooltip.Forward", this.getItemText(index)) : "");
                }
                return enabled;
            }

            @Override
            protected void createEntries(Menu menu) {
                int i = historyIndex + 1;
                int j = 0;
                while (i < historyList.size() && j < 5) {
                    if (this.isCurrentEntryAvailable(i)) {
                        HistoryItemAction action = new HistoryItemAction(i, this.getItemText(i));
                        this.addActionToMenu(menu, (IAction)action);
                        ++j;
                    }
                    ++i;
                }
            }
        };
        forward.setText(Messages.getString("SubtaskHistory.Text.Forward"));
        forward.setActionDefinitionId("org.eclipse.ui.navigate.forwardHistory");
        forward.setImageDescriptor(ImageDescriptor.createFromURL((URL)UIHelper.getURL("icons/obj16/forward_nav.gif")));
        forward.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)UIHelper.getURL("icons/obj16/forward_nav_disabled.gif")));
        this.historyToolbar.add((IAction)forward);
        return historyBar;
    }

    private boolean isCurrentEntryAvailable(int index) {
        return index >= 0 && index < this.historyList.size() && this.parentTask.getNavigatorTree().findTreeItem(this.getHistoryEntry(index)) != null;
    }

    private String getItemText(int index) {
        TreeItem item = this.parentTask.getNavigatorTree().findTreeItem(this.getHistoryEntry(index));
        if (item != null) {
            return item.getText();
        }
        return Messages.getString("SubtaskHistory.Text.Invalid");
    }
}

