/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.osgi.framework.BundleException;

public class MinimalState {
    protected State fState;
    protected long fId;
    private boolean fEEListChanged = false;
    private String[] fExecutionEnvironments;
    private boolean fNoProfile;
    protected static StateObjectFactory stateObjectFactory;
    protected static String DIR;
    protected String fSystemBundle = "org.eclipse.osgi";

    static {
        DIR = PDECore.getDefault().getStateLocation().toOSString();
        stateObjectFactory = Platform.getPlatformAdmin().getFactory();
    }

    protected MinimalState(MinimalState state) {
        this.fState = stateObjectFactory.createState(state.fState);
        this.fState.setPlatformProperties(state.fState.getPlatformProperties());
        this.fState.setResolver(Platform.getPlatformAdmin().createResolver());
        this.fId = state.fId;
        this.fEEListChanged = state.fEEListChanged;
        this.fExecutionEnvironments = state.fExecutionEnvironments;
        this.fNoProfile = state.fNoProfile;
        this.fSystemBundle = state.fSystemBundle;
    }

    protected MinimalState() {
    }

    public void addBundle(IPluginModelBase model, boolean update) {
        if (model == null) {
            return;
        }
        BundleDescription desc = model.getBundleDescription();
        long bundleId = desc == null || !update ? -1L : desc.getBundleId();
        try {
            BundleDescription newDesc = this.addBundle(new File(model.getInstallLocation()), bundleId);
            model.setBundleDescription(newDesc);
            if (newDesc == null && update) {
                this.fState.removeBundle(desc);
            }
        }
        catch (CoreException e) {
            PDECore.log(e);
            model.setBundleDescription(null);
        }
    }

    public BundleDescription addBundle(Map<String, String> manifest, File bundleLocation, long bundleId) throws CoreException {
        try {
            Hashtable<String, String> dictionaryManifest = new Hashtable<String, String>(manifest);
            BundleDescription descriptor = stateObjectFactory.createBundleDescription(this.fState, dictionaryManifest, bundleLocation.getAbsolutePath(), bundleId == -1L ? this.getNextId() : bundleId);
            if (bundleId == -1L) {
                this.fState.addBundle(descriptor);
            } else if (!this.fState.updateBundle(descriptor)) {
                this.fState.addBundle(descriptor);
            }
            return descriptor;
        }
        catch (BundleException e) {
            MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.toString()), null);
            status.add((IStatus)new Status(4, "org.eclipse.pde.core", e.getMessage()));
            throw new CoreException((IStatus)status);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    public BundleDescription addBundle(File bundleLocation, long bundleId) throws CoreException {
        Map<String, String> manifest = ManifestUtils.loadManifest(bundleLocation);
        TargetWeaver.weaveManifest(manifest);
        BundleDescription desc = this.addBundle(manifest, bundleLocation, bundleId);
        if (desc != null && manifest != null && "true".equals(manifest.get("Eclipse-SystemBundle"))) {
            this.fEEListChanged = true;
            this.fSystemBundle = desc.getSymbolicName();
        }
        if (desc != null) {
            this.addAuxiliaryData(desc, manifest, true);
        }
        return desc;
    }

    protected void addAuxiliaryData(BundleDescription desc, Map<String, String> manifest, boolean hasBundleStructure) {
    }

    public StateDelta resolveState(boolean incremental) {
        return this.internalResolveState(incremental);
    }

    public StateDelta resolveState(String[] symbolicNames) {
        if (this.initializePlatformProperties()) {
            return this.fState.resolve(false);
        }
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        String[] stringArray = symbolicNames;
        int n = symbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription[] descriptions;
            String symbolicName = stringArray[n2];
            BundleDescription[] bundleDescriptionArray = descriptions = this.fState.getBundles(symbolicName);
            int n3 = descriptions.length;
            int n4 = 0;
            while (n4 < n3) {
                BundleDescription description = bundleDescriptionArray[n4];
                bundles.add(description);
                ++n4;
            }
            ++n2;
        }
        return this.fState.resolve(bundles.toArray(new BundleDescription[bundles.size()]));
    }

    private synchronized StateDelta internalResolveState(boolean incremental) {
        boolean fullBuildRequired = this.initializePlatformProperties();
        return this.fState.resolve(incremental && !fullBuildRequired);
    }

    protected boolean initializePlatformProperties() {
        if (this.fExecutionEnvironments == null && !this.fNoProfile) {
            this.setExecutionEnvironments();
        }
        if (this.fEEListChanged) {
            this.fEEListChanged = false;
            return this.fState.setPlatformProperties((Dictionary[])this.getProfilePlatformProperties());
        }
        return false;
    }

    private Dictionary<String, String>[] getProfilePlatformProperties() {
        return TargetPlatformHelper.getPlatformProperties(this.fExecutionEnvironments, this);
    }

    public void removeBundleDescription(BundleDescription description) {
        if (description != null) {
            this.fState.removeBundle(description);
        }
    }

    public void updateBundleDescription(BundleDescription description) {
        if (description != null) {
            this.fState.updateBundle(description);
        }
    }

    public State getState() {
        return this.fState;
    }

    private void setExecutionEnvironments() {
        String jreProfile;
        String[] knownExecutionEnviroments = TargetPlatformHelper.getKnownExecutionEnvironments();
        if (knownExecutionEnviroments.length == 0 && (jreProfile = System.getProperty("pde.jreProfile")) != null && jreProfile.length() > 0 && "none".equals(jreProfile)) {
            this.fNoProfile = true;
        }
        if (!this.fNoProfile) {
            this.fExecutionEnvironments = knownExecutionEnviroments;
        }
        this.fEEListChanged = true;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        if (toAdd != null) {
            this.fState.addBundle(toAdd);
        }
    }

    public long getNextId() {
        return ++this.fId;
    }

    public String getSystemBundle() {
        return this.fSystemBundle;
    }
}

