/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.util.PropertyUtil;

public abstract class AbstractSessionBasedScope
extends AbstractScope {
    private final IFeatureScopeSession session;
    private final XAbstractFeatureCall featureCall;

    protected AbstractSessionBasedScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall featureCall) {
        super(parent, false);
        if (session == null) {
            throw new IllegalArgumentException("session may not be null");
        }
        this.session = session;
        this.featureCall = featureCall;
    }

    protected abstract List<IEObjectDescription> getAllLocalElements();

    protected IFeatureScopeSession getSession() {
        return this.session;
    }

    protected XAbstractFeatureCall getFeatureCall() {
        return this.featureCall;
    }

    protected void processFeatureNames(QualifiedName name, NameAcceptor acceptor) {
        acceptor.accept(name.toString(), 1);
    }

    protected List<JvmFeature> findAllFeaturesByName(JvmType type, String simpleName, IResolvedFeatures.Provider resolvedFeaturesProvider) {
        IResolvedFeatures resolvedFeatures = resolvedFeaturesProvider.getResolvedFeatures(type);
        return resolvedFeatures.getAllFeatures(simpleName);
    }

    protected void processAsPropertyNames(QualifiedName name, NameAcceptor acceptor) {
        String nameAsPropertyName = this.tryGetAsPropertyName(name.toString());
        if (nameAsPropertyName != null) {
            if (this.featureCall == null || this.featureCall instanceof XAssignment) {
                String aliasedSetter = "set" + nameAsPropertyName;
                acceptor.accept(aliasedSetter, 2);
            }
            if (!(this.featureCall instanceof XAssignment || this.featureCall != null && this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax())) {
                String aliasedGetter = "get" + nameAsPropertyName;
                acceptor.accept(aliasedGetter, 2);
                String aliasedBooleanGetter = "is" + nameAsPropertyName;
                acceptor.accept(aliasedBooleanGetter, 2);
            }
        }
    }

    protected String toProperty(String methodName, JvmFeature feature) {
        return this.toProperty(methodName, feature, 0, 1);
    }

    protected String toProperty(String methodName, JvmFeature feature, int getterParams, int setterParams) {
        return PropertyUtil.getPropertyName(feature, methodName, getterParams, setterParams);
    }

    protected String tryGetAsPropertyName(String name) {
        if (name.length() == 1) {
            if (Character.isUpperCase(name.charAt(0))) {
                return null;
            }
            return name.toUpperCase(Locale.ENGLISH);
        }
        if (name.length() > 1) {
            if (Character.isUpperCase(name.charAt(1))) {
                if (Character.isUpperCase(name.charAt(0))) {
                    return name;
                }
                return null;
            }
            if (Character.isUpperCase(name.charAt(0))) {
                return null;
            }
            return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        }
        return null;
    }

    protected void addToList(IEObjectDescription description, List<IEObjectDescription> result) {
        result.add(description);
    }

    protected void addToList(List<IEObjectDescription> descriptions, List<IEObjectDescription> result) {
        result.addAll(descriptions);
    }

    protected abstract List<IEObjectDescription> getLocalElementsByName(QualifiedName var1);

    public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
        Iterable localElements = this.getLocalElementsByName(name);
        if (localElements.isEmpty()) {
            return this.getParent().getElements(name);
        }
        Iterable parentElements = this.getParentElements((Provider)new Provider<Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> get() {
                return AbstractSessionBasedScope.this.getParent().getElements(name);
            }
        });
        Iterable result = Iterables.concat((Iterable)localElements, (Iterable)parentElements);
        return result;
    }

    protected Iterable<IEObjectDescription> getLocalElementsByEObject(final EObject object, final URI uri) {
        Iterable localElements = this.getAllLocalElements();
        Iterable result = Iterables.filter((Iterable)localElements, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return this.canBeFoundByNameAndShadowingKey(input);
                }
                if (uri.equals(input.getEObjectURI())) {
                    return this.canBeFoundByNameAndShadowingKey(input);
                }
                return false;
            }

            public boolean canBeFoundByNameAndShadowingKey(IEObjectDescription input) {
                Iterable lookUp = AbstractSessionBasedScope.this.getLocalElementsByName(input.getName());
                String myShadowingKey = AbstractSessionBasedScope.this.getShadowingKey(input);
                for (IEObjectDescription other : lookUp) {
                    if (!myShadowingKey.equals(AbstractSessionBasedScope.this.getShadowingKey(other))) continue;
                    if (other == input) {
                        return true;
                    }
                    if (other.getEObjectOrProxy() == object) {
                        return true;
                    }
                    return uri.equals(other.getEObjectURI());
                }
                return false;
            }
        });
        return result;
    }

    protected String getShadowingKey(IEObjectDescription description) {
        if (description instanceof BucketedEObjectDescription) {
            return ((BucketedEObjectDescription)description).getShadowingKey();
        }
        return description.getName().toString();
    }

    protected boolean isShadowed(IEObjectDescription fromParent) {
        Iterable localElements = this.getLocalElementsByName(fromParent.getName());
        if (localElements.isEmpty()) {
            return false;
        }
        String shadowingKey = this.getShadowingKey(fromParent);
        for (IEObjectDescription local : localElements) {
            if (!shadowingKey.equals(this.getShadowingKey(local))) continue;
            return true;
        }
        return false;
    }

    protected static interface NameAcceptor {
        public void accept(String var1, int var2);
    }
}

