/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.headless;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.headless.WorkspaceImporter;
import org.eclipse.stem.util.loggers.util.Util;
import org.eclipse.stem.util.loggers.views.CustomCSVLogger;

public class HeadlessSimulationRunner {
    private static final String PROJECT_SCENARIOS_FOLDER_NAME = "scenarios";
    private static final String SCENARIO_FILE_EXTENSION = ".scenario";
    private static final SimulationManager MANAGER = SimulationManager.getManager();
    private final HeadlessSimulationStatusLogger logger = new HeadlessSimulationStatusLogger();
    private final Set<URI> scenariosUrisToRun = new HashSet<URI>();
    private boolean log = false;
    private String logDirectory = null;

    public HeadlessSimulationRunner(boolean log, String logDirectory) {
        this.log = log;
        this.logDirectory = logDirectory;
        this.refreshWorkspace();
    }

    private void refreshWorkspace() {
        WorkspaceImporter.importProjects();
    }

    public void run(Map<String, List<String>> args) {
        this.collectScenariosToRun(args);
        this.runScenarios();
        this.waitForSimulations();
    }

    private void collectScenariosToRun(Map<String, List<String>> args) {
        if (args.containsKey("uri")) {
            this.addScenariosForUris(args.get("uri"));
        }
        if (args.containsKey("project") && args.get("project").size() > 0) {
            if (args.containsKey("scenario")) {
                this.addScenarios(args.get("project").get(0), args.get("scenario"));
            } else {
                this.addScenariosForProject(args.get("project").get(0));
            }
        }
    }

    private void addScenarios(String projectName, List<String> scenarioNames) {
        for (String scenarioName : scenarioNames) {
            if (!scenarioName.endsWith(SCENARIO_FILE_EXTENSION)) {
                scenarioName = scenarioName.concat(SCENARIO_FILE_EXTENSION);
            }
            this.scenariosUrisToRun.add(HeadlessSimulationRunner.createUriForScenario(projectName, scenarioName));
        }
    }

    private void addScenariosForUris(List<String> uris) {
        for (String uri : uris) {
            try {
                this.scenariosUrisToRun.add(URI.createURI((String)uri));
            }
            catch (IllegalArgumentException iae) {
                System.err.println("URI " + uri + " is invalid");
            }
        }
    }

    private void addLogger(ISimulation sim) {
        String logDir = this.logDirectory;
        if (logDir == null) {
            logDir = Util.getLoggingFolder((String)sim.getScenario().getURI().toString());
        }
        String uniqueID = null;
        if (sim != null) {
            uniqueID = sim.getUniqueIDString();
        } else {
            Date creationTime = Calendar.getInstance().getTime();
            String winSafestmp = DublinCoreImpl.createISO8601DateStringSeconds((Date)creationTime);
            uniqueID = winSafestmp.replace(":", "_");
        }
        String directoryName = String.valueOf(logDir) + File.separator + uniqueID + File.separator;
        File dir = new File(directoryName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        EList decorators = sim.getScenario().getCanonicalGraph().getDecorators();
        for (Decorator dec : decorators) {
            if (!(dec instanceof IntegrationDecorator)) continue;
            CustomCSVLogger customCSVLogger = new CustomCSVLogger(directoryName, sim, (IntegrationDecorator)dec);
        }
    }

    private void runScenarios() {
        System.out.println("Scenarios selected: " + this.scenariosUrisToRun);
        for (URI scenarioUri : this.scenariosUrisToRun) {
            try {
                System.out.println("Creating simulation for " + scenarioUri);
                Scenario simulationScenario = (Scenario)Utility.getIdentifiable((URI)scenarioUri);
                if (simulationScenario != null) {
                    ISimulation sim = MANAGER.createSimulation(simulationScenario, (IProgressMonitor)new NullProgressMonitor());
                    if (this.log) {
                        this.addLogger(sim);
                    }
                    System.out.println("Running simulation " + sim.getUniqueIDString() + " for " + scenarioUri);
                    sim.addSimulationListenerSync((ISimulationListenerSync)this.logger);
                    sim.run();
                    continue;
                }
                System.err.println("Scenario " + scenarioUri + " not fond");
            }
            catch (Exception e) {
                System.err.println("Error creating simulation for URI " + scenarioUri);
                e.printStackTrace(System.err);
            }
        }
    }

    private static URI createUriForScenario(String projectName, String scenarioName) {
        return URI.createURI((String)("platform:/resource/" + projectName + "/" + PROJECT_SCENARIOS_FOLDER_NAME + "/" + scenarioName));
    }

    private void addScenariosForProject(String projectName) {
        IProject project = HeadlessSimulationRunner.getProjectForName(projectName);
        try {
            IFolder scneariosFolder = project.getFolder(PROJECT_SCENARIOS_FOLDER_NAME);
            if (scneariosFolder.exists()) {
                IResource[] folderMembers;
                IResource[] iResourceArray = folderMembers = scneariosFolder.members();
                int n = folderMembers.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (r.getName().endsWith(SCENARIO_FILE_EXTENSION)) {
                        this.scenariosUrisToRun.add(HeadlessSimulationRunner.createUriForScenario(projectName, r.getName()));
                    }
                    ++n2;
                }
            } else {
                System.err.println("Project " + projectName + " is not a valid STEM project");
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
    }

    private static IProject getProjectForName(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private void waitForSimulations() {
        while (MANAGER.getActiveSimulations().size() > 0) {
            int activeCount = MANAGER.getActiveSimulations().size();
            for (ISimulation sim : MANAGER.getActiveSimulations()) {
                if (sim.getSimulationState() == SimulationState.STOPPED) {
                    --activeCount;
                    continue;
                }
                try {
                    sim.join();
                    sim.stop();
                    --activeCount;
                }
                catch (InterruptedException e) {
                    System.err.println("Simulation interrupted.");
                }
            }
            if (activeCount == 0) break;
        }
    }

    private class HeadlessSimulationStatusLogger
    implements ISimulationListenerSync {
        long initialTime;
        long lastTime;

        HeadlessSimulationStatusLogger() {
            this.initialTime = this.lastTime = System.currentTimeMillis();
        }

        public void simulationChangedSync(SimulationEvent event) {
            Sequencer sequencer = event.getSimulation().getScenario().getSequencer();
            switch (event.getSimulationState()) {
                case COMPLETED_CYCLE: {
                    long time = System.currentTimeMillis();
                    System.out.println("[" + event.getSimulation().getUniqueIDString() + "] " + sequencer.getWorkComplete() + "% " + sequencer.getCurrentTime() + "/" + sequencer.getEndTime() + " " + "(" + (time - this.lastTime) + " ms)");
                    this.lastTime = time;
                    break;
                }
                case COMPLETED_SEQUENCE: {
                    System.out.println("[" + event.getSimulation().getUniqueIDString() + "] Finished (" + (this.lastTime - this.initialTime) + " ms)");
                    break;
                }
            }
        }
    }
}

