/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ApiImageDescriptor
extends CompositeImageDescriptor {
    public static final int ERROR = 1;
    public static final int SUCCESS = 2;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public ApiImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ApiImageDescriptor)) {
            return false;
        }
        ApiImageDescriptor other = (ApiImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    private ImageData getImageData(String imageDescriptorKey) {
        return ApiUIPlugin.getImageDescriptor(imageDescriptorKey).getImageData();
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((flags & 1) != 0) {
            x = 0;
            y = this.getSize().y;
            data = this.getImageData("IMG_OVR_ERROR");
            this.drawImage(data, x, y -= data.height);
        } else if ((flags & 2) != 0) {
            x = 0;
            y = this.getSize().y;
            data = this.getImageData("IMG_OVR_SUCCESS");
            this.drawImage(data, x, y -= data.height);
        }
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

