/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ProjectClasspathPreferenceChangeListener
implements IEclipsePreferences.IPreferenceChangeListener,
IResourceChangeListener {
    private final IJavaProject project;
    private final ProjectScope scope;

    public ProjectClasspathPreferenceChangeListener(IJavaProject project) {
        this.project = project;
        this.scope = new ProjectScope(project.getProject());
        this.scope.getNode("org.eclipse.pde.ds.annotations").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 6);
        this.requestClasspathUpdate();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (ProjectClasspathPreferenceChangeListener.requiresClasspathUpdate(event)) {
            this.requestClasspathUpdate();
        }
    }

    private void requestClasspathUpdate() {
        WorkspaceJob job = new WorkspaceJob(Messages.ProjectClasspathPreferenceChangeListener_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectClasspathPreferenceChangeListener.updateClasspathContainer(ProjectClasspathPreferenceChangeListener.this.project, monitor);
                return Status.OK_STATUS;
            }
        };
        Display display = Display.getCurrent();
        if (display != null) {
            PlatformUI.getWorkbench().getProgressService().showInDialog(display.getActiveShell(), (Job)job);
        }
        job.schedule();
    }

    static boolean requiresClasspathUpdate(IEclipsePreferences.PreferenceChangeEvent event) {
        return "classpath".equals(event.getKey()) || "dsVersion".equals(event.getKey()) || "enabled".equals(event.getKey());
    }

    static void updateClasspathContainer(IJavaProject project, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(project.getElementName(), 1);
        }
        try {
            IPluginModelBase model;
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH.segment(0));
            if (initializer != null && initializer.canUpdateClasspathContainer(PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, project) && (model = PluginRegistry.findModel((IProject)project.getProject())) != null) {
                try {
                    initializer.requestClasspathContainerUpdate(PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, project, (IClasspathContainer)new RequiredPluginsClasspathContainer(model, ClasspathUtilCore.getBuild((IPluginModelBase)model)));
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if ((event.getType() == 2 || event.getType() == 4) && this.project.getProject().equals((Object)event.getResource())) {
            Activator.getDefault().disposeProjectClasspathPreferenceChangeListener(this.project);
        }
    }

    public void dispose() {
        this.scope.getNode("org.eclipse.pde.ds.annotations").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

