/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_path_data_t;
import org.eclipse.swt.internal.cairo.cairo_path_t;

public class Path
extends Resource {
    public int handle;
    boolean moved;
    boolean closed = true;

    public Path(Device device) {
        super(device);
        this.device.checkCairo();
        int surface = Cairo.cairo_image_surface_create(0, 1, 1);
        if (surface == 0) {
            SWT.error(2);
        }
        this.handle = Cairo.cairo_create(surface);
        Cairo.cairo_surface_destroy(surface);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, Path path, float flatness) {
        super(device);
        int copy;
        int surface;
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        if ((surface = Cairo.cairo_image_surface_create(0, 1, 1)) == 0) {
            SWT.error(2);
        }
        this.handle = Cairo.cairo_create(surface);
        Cairo.cairo_surface_destroy(surface);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if ((flatness = Math.max(0.0f, flatness)) == 0.0f) {
            copy = Cairo.cairo_copy_path(path.handle);
        } else {
            double tolerance = Cairo.cairo_get_tolerance(path.handle);
            Cairo.cairo_set_tolerance(path.handle, flatness);
            copy = Cairo.cairo_copy_path_flat(path.handle);
            Cairo.cairo_set_tolerance(path.handle, tolerance);
        }
        if (copy == 0) {
            Cairo.cairo_destroy(this.handle);
            SWT.error(2);
        }
        Cairo.cairo_append_path(this.handle, copy);
        Cairo.cairo_path_destroy(copy);
        this.init();
    }

    public Path(Device device, PathData data) {
        this(device);
        if (data == null) {
            SWT.error(4);
        }
        this.init(data);
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.moved = true;
        if (width == height) {
            float angle = -startAngle * (float)Compatibility.PI / 180.0f;
            if (this.closed) {
                Cairo.cairo_move_to(this.handle, (double)(x + width / 2.0f) + (double)(width / 2.0f) * Math.cos(angle), (double)(y + height / 2.0f) + (double)(height / 2.0f) * Math.sin(angle));
            }
            if (arcAngle >= 0.0f) {
                Cairo.cairo_arc_negative(this.handle, x + width / 2.0f, y + height / 2.0f, width / 2.0f, angle, -(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f);
            } else {
                Cairo.cairo_arc(this.handle, x + width / 2.0f, y + height / 2.0f, width / 2.0f, angle, -(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f);
            }
        } else {
            Cairo.cairo_save(this.handle);
            Cairo.cairo_translate(this.handle, x + width / 2.0f, y + height / 2.0f);
            Cairo.cairo_scale(this.handle, width / 2.0f, height / 2.0f);
            float angle = -startAngle * (float)Compatibility.PI / 180.0f;
            if (this.closed) {
                Cairo.cairo_move_to(this.handle, Math.cos(angle), Math.sin(angle));
            }
            if (arcAngle >= 0.0f) {
                Cairo.cairo_arc_negative(this.handle, 0.0, 0.0, 1.0, angle, -(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f);
            } else {
                Cairo.cairo_arc(this.handle, 0.0, 0.0, 1.0, angle, -(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f);
            }
            Cairo.cairo_restore(this.handle);
        }
        this.closed = false;
        if (Math.abs(arcAngle) >= 360.0f) {
            this.close();
        }
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.moved = false;
        int copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(this.handle, copy);
        Cairo.cairo_path_destroy(copy);
        this.closed = path.closed;
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.moved = false;
        Cairo.cairo_rectangle(this.handle, x, y, width, height);
        this.closed = true;
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.moved = false;
        GC.addCairoString(this.handle, string, x, y, font);
        this.closed = true;
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_close_path(this.handle);
        this.moved = false;
        this.closed = true;
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        gc.initCairo();
        gc.checkGC(120);
        boolean result = false;
        int cairo = gc.data.cairo;
        int copy = Cairo.cairo_copy_path(this.handle);
        if (copy == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        result = outline ? Cairo.cairo_in_stroke(cairo, x, y) != 0 : Cairo.cairo_in_fill(cairo, x, y) != 0;
        Cairo.cairo_new_path(cairo);
        return result;
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.moved) {
            double[] currentX = new double[1];
            double[] currentY = new double[1];
            Cairo.cairo_get_current_point(this.handle, currentX, currentY);
            Cairo.cairo_move_to(this.handle, currentX[0], currentY[0]);
            this.moved = true;
        }
        Cairo.cairo_curve_to(this.handle, cx1, cy1, cx2, cy2, x, y);
        this.closed = false;
    }

    public void getBounds(float[] bounds) {
        int copy;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        if ((copy = Cairo.cairo_copy_path(this.handle)) == 0) {
            SWT.error(2);
        }
        cairo_path_t path = new cairo_path_t();
        Cairo.memmove(path, copy, cairo_path_t.sizeof);
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        if (path.num_data > 0) {
            minY = Double.POSITIVE_INFINITY;
            minX = Double.POSITIVE_INFINITY;
            maxY = Double.NEGATIVE_INFINITY;
            maxX = Double.NEGATIVE_INFINITY;
            int i = 0;
            double[] points = new double[6];
            cairo_path_data_t data = new cairo_path_data_t();
            while (i < path.num_data) {
                int offset = path.data + i * cairo_path_data_t.sizeof;
                Cairo.memmove(data, offset, cairo_path_data_t.sizeof);
                switch (data.type) {
                    case 0: {
                        Cairo.memmove(points, offset + cairo_path_data_t.sizeof, cairo_path_data_t.sizeof);
                        minX = Math.min(minX, points[0]);
                        minY = Math.min(minY, points[1]);
                        maxX = Math.max(maxX, points[0]);
                        maxY = Math.max(maxY, points[1]);
                        break;
                    }
                    case 1: {
                        Cairo.memmove(points, offset + cairo_path_data_t.sizeof, cairo_path_data_t.sizeof);
                        minX = Math.min(minX, points[0]);
                        minY = Math.min(minY, points[1]);
                        maxX = Math.max(maxX, points[0]);
                        maxY = Math.max(maxY, points[1]);
                        break;
                    }
                    case 2: {
                        Cairo.memmove(points, offset + cairo_path_data_t.sizeof, cairo_path_data_t.sizeof * 3);
                        minX = Math.min(minX, points[0]);
                        minY = Math.min(minY, points[1]);
                        maxX = Math.max(maxX, points[0]);
                        maxY = Math.max(maxY, points[1]);
                        minX = Math.min(minX, points[2]);
                        minY = Math.min(minY, points[3]);
                        maxX = Math.max(maxX, points[2]);
                        maxY = Math.max(maxY, points[3]);
                        minX = Math.min(minX, points[4]);
                        minY = Math.min(minY, points[5]);
                        maxX = Math.max(maxX, points[4]);
                        maxY = Math.max(maxY, points[5]);
                        break;
                    }
                }
                i += data.length;
            }
        }
        bounds[0] = (float)minX;
        bounds[1] = (float)minY;
        bounds[2] = (float)(maxX - minX);
        bounds[3] = (float)(maxY - minY);
        Cairo.cairo_path_destroy(copy);
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        double[] x = new double[1];
        double[] y = new double[1];
        Cairo.cairo_get_current_point(this.handle, x, y);
        point[0] = (float)x[0];
        point[1] = (float)y[0];
    }

    public PathData getPathData() {
        int copy;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((copy = Cairo.cairo_copy_path(this.handle)) == 0) {
            SWT.error(2);
        }
        cairo_path_t path = new cairo_path_t();
        Cairo.memmove(path, copy, cairo_path_t.sizeof);
        byte[] types = new byte[path.num_data];
        float[] pts = new float[path.num_data * 6];
        int typeIndex = 0;
        int ptsIndex = 0;
        if (path.num_data > 0) {
            int i = 0;
            double[] points = new double[6];
            cairo_path_data_t data = new cairo_path_data_t();
            while (i < path.num_data) {
                int offset = path.data + i * cairo_path_data_t.sizeof;
                Cairo.memmove(data, offset, cairo_path_data_t.sizeof);
                switch (data.type) {
                    case 0: {
                        types[typeIndex++] = 1;
                        Cairo.memmove(points, offset + cairo_path_data_t.sizeof, cairo_path_data_t.sizeof);
                        pts[ptsIndex++] = (float)points[0];
                        pts[ptsIndex++] = (float)points[1];
                        break;
                    }
                    case 1: {
                        types[typeIndex++] = 2;
                        Cairo.memmove(points, offset + cairo_path_data_t.sizeof, cairo_path_data_t.sizeof);
                        pts[ptsIndex++] = (float)points[0];
                        pts[ptsIndex++] = (float)points[1];
                        break;
                    }
                    case 2: {
                        types[typeIndex++] = 4;
                        Cairo.memmove(points, offset + cairo_path_data_t.sizeof, cairo_path_data_t.sizeof * 3);
                        pts[ptsIndex++] = (float)points[0];
                        pts[ptsIndex++] = (float)points[1];
                        pts[ptsIndex++] = (float)points[2];
                        pts[ptsIndex++] = (float)points[3];
                        pts[ptsIndex++] = (float)points[4];
                        pts[ptsIndex++] = (float)points[5];
                        break;
                    }
                    case 3: {
                        types[typeIndex++] = 5;
                    }
                }
                i += data.length;
            }
        }
        if (typeIndex != types.length) {
            byte[] newTypes = new byte[typeIndex];
            System.arraycopy(types, 0, newTypes, 0, typeIndex);
            types = newTypes;
        }
        if (ptsIndex != pts.length) {
            float[] newPts = new float[ptsIndex];
            System.arraycopy(pts, 0, newPts, 0, ptsIndex);
            pts = newPts;
        }
        Cairo.cairo_path_destroy(copy);
        PathData result = new PathData();
        result.types = types;
        result.points = pts;
        return result;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.moved) {
            double[] currentX = new double[1];
            double[] currentY = new double[1];
            Cairo.cairo_get_current_point(this.handle, currentX, currentY);
            Cairo.cairo_move_to(this.handle, currentX[0], currentY[0]);
            this.moved = true;
        }
        Cairo.cairo_line_to(this.handle, x, y);
        this.closed = false;
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.moved = true;
        Cairo.cairo_move_to(this.handle, x, y);
        this.closed = true;
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        double[] currentX = new double[1];
        double[] currentY = new double[1];
        Cairo.cairo_get_current_point(this.handle, currentX, currentY);
        if (!this.moved) {
            Cairo.cairo_move_to(this.handle, currentX[0], currentY[0]);
            this.moved = true;
        }
        float x0 = (float)currentX[0];
        float y0 = (float)currentY[0];
        float cx1 = x0 + 2.0f * (cx - x0) / 3.0f;
        float cy1 = y0 + 2.0f * (cy - y0) / 3.0f;
        float cx2 = cx1 + (x - x0) / 3.0f;
        float cy2 = cy1 + (y - y0) / 3.0f;
        Cairo.cairo_curve_to(this.handle, cx1, cy1, cx2, cy2, x, y);
        this.closed = false;
    }

    void destroy() {
        Cairo.cairo_destroy(this.handle);
        this.handle = 0;
    }

    void init(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

