/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.BTreeValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineValueList<K, V>
implements BTreeValues<V> {
    private BTree<K, V> btree;
    private int valueCount;
    private InlineValue firstValue;
    private InlineValue lastValue;
    private int valueSize;

    InlineValueList(BTree<K, V> btree) {
        this.btree = btree;
        this.valueSize = 8;
        this.valueCount = 0;
        this.firstValue = null;
        this.lastValue = null;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public BTreeValues.Value<V> append(BTreeValue<V> v) throws IOException {
        InlineValue value = new InlineValue(v);
        if (this.lastValue == null) {
            value.setPrev(null);
            value.setNext(null);
            this.firstValue = value;
            this.lastValue = value;
        } else {
            value.setPrev(this.lastValue);
            value.setNext(null);
            this.lastValue.setNext(value);
            this.lastValue = value;
        }
        ++this.valueCount;
        this.valueSize += this.btree.getValueSize(v);
        return value;
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.valueSize = in.readInt();
        this.valueCount = in.readInt();
        int i = 0;
        while (i < this.valueCount) {
            BTreeValue<V> v = this.btree.readValue(in);
            InlineValue value = new InlineValue(v);
            if (this.lastValue == null) {
                this.firstValue = value;
                this.lastValue = value;
            } else {
                this.lastValue.setNext(value);
                value.setPrev(this.lastValue);
                this.lastValue = value;
            }
            ++i;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.valueSize);
        out.writeInt(this.valueCount);
        BTreeValues.Value value = this.firstValue;
        while (value != null) {
            this.btree.writeValue(out, value.getValue());
            value = value.getNext();
        }
    }

    @Override
    public BTreeValues.Value<V> getFirstValue() {
        return this.firstValue;
    }

    @Override
    public BTreeValues.Value<V> getLastValue() {
        return this.lastValue;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public int getValueSize() {
        return this.valueSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InlineValue
    implements BTreeValues.Value<V> {
        InlineValue next;
        InlineValue prev;
        BTreeValue<V> value;

        InlineValue(BTreeValue<V> value) {
            this.value = value;
        }

        @Override
        public BTreeValues.Value<V> getNext() throws IOException {
            return this.next;
        }

        @Override
        public BTreeValues.Value<V> getPrev() throws IOException {
            return this.prev;
        }

        @Override
        public BTreeValue<V> getValue() throws IOException {
            return this.value;
        }

        public void setNext(InlineValue next) {
            this.next = next;
        }

        public void setPrev(InlineValue prev) {
            this.prev = prev;
        }
    }
}

