/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.multipopulation.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.StringValue;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSEIRDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultipopulationPackage;
import org.eclipse.stem.diseasemodels.multipopulation.impl.MultiPopulationSIRDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SEIRLabel;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;

public class MultiPopulationSEIRDiseaseModelImpl
extends MultiPopulationSIRDiseaseModelImpl
implements MultiPopulationSEIRDiseaseModel {
    protected DoubleValueList incubationRate;

    @Override
    protected EClass eStaticClass() {
        return MultipopulationPackage.Literals.MULTI_POPULATION_SEIR_DISEASE_MODEL;
    }

    @Override
    public DoubleValueList getIncubationRate() {
        return this.incubationRate;
    }

    public NotificationChain basicSetIncubationRate(DoubleValueList newIncubationRate, NotificationChain msgs) {
        this.incubationRate = newIncubationRate;
        return msgs;
    }

    @Override
    public void setIncubationRate(DoubleValueList newIncubationRate) {
        if (newIncubationRate != this.incubationRate) {
            NotificationChain msgs = null;
            if (this.incubationRate != null) {
                msgs = ((InternalEObject)this.incubationRate).eInverseRemove((InternalEObject)this, -25, null, msgs);
            }
            if (newIncubationRate != null) {
                msgs = ((InternalEObject)newIncubationRate).eInverseAdd((InternalEObject)this, -25, null, msgs);
            }
            if ((msgs = this.basicSetIncubationRate(newIncubationRate, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 24: {
                return this.basicSetIncubationRate(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SEIRLabelValue currentSEIR = (SEIRLabelValue)currentState;
            String thisPopulation = diseaseLabel.getPopulationModelLabel().getPopulationIdentifier();
            double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta, thisPopulation);
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSEIR.getI();
            int populationIndex = this.getPopulationIndex(thisPopulation);
            EList transmissionVector = ((DoubleValueList)this.getTransmissionRate().getValueLists().get(populationIndex)).getValues();
            double thisRecoveryRate = 0.0;
            if (this.getRecoveryRate() != null) {
                thisRecoveryRate = ((DoubleValue)this.getRecoveryRate().getValues().get(populationIndex)).getValue();
            }
            double thisImmunityLossRate = 0.0;
            if (this.getImmunityLossRate() != null) {
                thisImmunityLossRate = ((DoubleValue)this.getImmunityLossRate().getValues().get(populationIndex)).getValue();
            }
            double thisIncubationRate = 0.0;
            if (this.getIncubationRate() != null) {
                thisIncubationRate = ((DoubleValue)this.getIncubationRate().getValues().get(populationIndex)).getValue();
            }
            double numberOfSusceptibleToExposed = 0.0;
            double numberSusceptible = currentSEIR.getS();
            Node thisNode = diseaseLabel.getNode();
            EList groupList = this.getPopulationGroups().getValues();
            int i = 0;
            while (i < transmissionVector.size()) {
                String nextPop = ((StringValue)groupList.get(i)).getValue();
                double specificTransmission = ((DoubleValue)transmissionVector.get(i)).getValue();
                double adjustedTransmission = this.getAdjustedTransmissionRate(specificTransmission, timeDelta);
                if (!this.isFrequencyDependent()) {
                    adjustedTransmission *= this.getTransmissionRateScaleFactor(diseaseLabel);
                }
                EList nodeLabels = thisNode.getLabels();
                int j = 0;
                while (j < nodeLabels.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    String otherPopulation;
                    NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                    if (nlabel instanceof SEIRLabel && this == ((SEIRLabel)label).getDecorator() && (otherPopulation = (otherDiseaseLabel = (StandardDiseaseModelLabel)nlabel).getPopulationModelLabel().getPopulationIdentifier()).equals(nextPop)) {
                        double onsiteInfectious = ((SEIRLabelValue)otherDiseaseLabel.getTempValue()).getI();
                        double effectiveInfectious = this.getNormalizedEffectiveInfectious(thisNode, otherDiseaseLabel, onsiteInfectious, StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                        numberOfSusceptibleToExposed += adjustedTransmission * numberSusceptible * effectiveInfectious;
                    }
                    ++j;
                }
                ++i;
            }
            double numberOfInfectedToRecovered = this.getAdjustedRecoveryRate(thisRecoveryRate, timeDelta) * currentSEIR.getI();
            double numberOfRecoveredToSusceptible = this.getAdjustedImmunityLossRate(thisImmunityLossRate, timeDelta) * currentSEIR.getR();
            double numberOfExposedToInfected = this.getAdjustedIncubationRate(thisIncubationRate, timeDelta) * currentSEIR.getE();
            double deltaS = -numberOfSusceptibleToExposed + numberOfRecoveredToSusceptible;
            double deltaE = numberOfSusceptibleToExposed - numberOfExposedToInfected;
            double deltaI = numberOfExposedToInfected - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            SEIRLabelValueImpl ret = (SEIRLabelValueImpl)deltaValue;
            Exchange seExchange = (Exchange)ExchangePool.POOL.get();
            seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            seExchange.setCount(numberOfSusceptibleToExposed);
            seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)seExchange);
            Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
            eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            eiExchange.setCount(numberOfExposedToInfected);
            eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)eiExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            ret.setS(deltaS);
            ret.setE(deltaE);
            ret.setI(deltaI);
            ret.setR(deltaR);
            ret.setIncidence(numberOfSusceptibleToExposed);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    public double getAdjustedIncubationRate(double specificIncRate, long timeDelta) {
        return specificIncRate * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSEIRLabel();
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSEIRLabelValue();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 24: {
                return this.getIncubationRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 24: {
                this.setIncubationRate((DoubleValueList)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 24: {
                this.setIncubationRate(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 24: {
                return this.incubationRate != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

