/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.util;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.util.DeclarationVisitor;

class DeclarationScanner
implements DeclarationVisitor {
    protected DeclarationVisitor pre;
    protected DeclarationVisitor post;

    DeclarationScanner(DeclarationVisitor pre, DeclarationVisitor post) {
        this.pre = pre;
        this.post = post;
    }

    public void visitDeclaration(Declaration d) {
        d.accept(this.pre);
        d.accept(this.post);
    }

    public void visitPackageDeclaration(PackageDeclaration d) {
        d.accept(this.pre);
        for (ClassDeclaration classDecl : d.getClasses()) {
            classDecl.accept(this);
        }
        for (InterfaceDeclaration interfaceDecl : d.getInterfaces()) {
            interfaceDecl.accept(this);
        }
        d.accept(this.post);
    }

    public void visitMemberDeclaration(MemberDeclaration d) {
        this.visitDeclaration(d);
    }

    public void visitTypeDeclaration(TypeDeclaration d) {
        d.accept(this.pre);
        for (TypeParameterDeclaration typeParameterDeclaration : d.getFormalTypeParameters()) {
            typeParameterDeclaration.accept(this);
        }
        for (FieldDeclaration fieldDeclaration : d.getFields()) {
            fieldDeclaration.accept(this);
        }
        for (MethodDeclaration methodDeclaration : d.getMethods()) {
            methodDeclaration.accept(this);
        }
        for (TypeDeclaration typeDeclaration : d.getNestedTypes()) {
            typeDeclaration.accept(this);
        }
        d.accept(this.post);
    }

    public void visitClassDeclaration(ClassDeclaration d) {
        d.accept(this.pre);
        for (TypeParameterDeclaration tpDecl : d.getFormalTypeParameters()) {
            tpDecl.accept(this);
        }
        for (FieldDeclaration fieldDecl : d.getFields()) {
            fieldDecl.accept(this);
        }
        for (MethodDeclaration methodDecl : d.getMethods()) {
            methodDecl.accept(this);
        }
        for (TypeDeclaration typeDecl : d.getNestedTypes()) {
            typeDecl.accept(this);
        }
        for (ConstructorDeclaration ctorDecl : d.getConstructors()) {
            ctorDecl.accept(this);
        }
        d.accept(this.post);
    }

    public void visitEnumDeclaration(EnumDeclaration d) {
        this.visitClassDeclaration(d);
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration d) {
        this.visitTypeDeclaration(d);
    }

    public void visitAnnotationTypeDeclaration(AnnotationTypeDeclaration d) {
        this.visitInterfaceDeclaration(d);
    }

    public void visitFieldDeclaration(FieldDeclaration d) {
        this.visitMemberDeclaration(d);
    }

    public void visitEnumConstantDeclaration(EnumConstantDeclaration d) {
        this.visitFieldDeclaration(d);
    }

    public void visitExecutableDeclaration(ExecutableDeclaration d) {
        d.accept(this.pre);
        for (TypeParameterDeclaration tpDecl : d.getFormalTypeParameters()) {
            tpDecl.accept(this);
        }
        for (ParameterDeclaration pDecl : d.getParameters()) {
            pDecl.accept(this);
        }
        d.accept(this.post);
    }

    public void visitConstructorDeclaration(ConstructorDeclaration d) {
        this.visitExecutableDeclaration(d);
    }

    public void visitMethodDeclaration(MethodDeclaration d) {
        this.visitExecutableDeclaration(d);
    }

    public void visitAnnotationTypeElementDeclaration(AnnotationTypeElementDeclaration d) {
        this.visitMethodDeclaration(d);
    }

    public void visitParameterDeclaration(ParameterDeclaration d) {
        this.visitDeclaration(d);
    }

    public void visitTypeParameterDeclaration(TypeParameterDeclaration d) {
        this.visitDeclaration(d);
    }
}

