/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.vector.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.STEMObjectPool;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.math.BinomialDistributionUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.vector.DengueModelHostLabelValue;
import org.eclipse.stem.diseasemodels.vector.DengueModelVectorLabelValue;
import org.eclipse.stem.diseasemodels.vector.DengueUtil;
import org.eclipse.stem.diseasemodels.vector.SimpleDengueModelHostLabelValue;
import org.eclipse.stem.diseasemodels.vector.VectorFactory;
import org.eclipse.stem.diseasemodels.vector.VectorPackage;
import org.eclipse.stem.diseasemodels.vector.VerySimpleDengueModel;

public class VerySimpleDengueModelImpl
extends StandardDiseaseModelImpl
implements VerySimpleDengueModel {
    protected STEMObjectPool dArrayObjectPool = new STEMObjectPool(5, 5){

        protected Object createNewObject() {
            return new double[16];
        }

        protected void resetObject(Object o) {
        }
    };
    protected DengueUtil dengueUtil = new DengueUtil();
    protected static final double TRANSMISSION_RATE_EDEFAULT = 0.55;
    protected double transmissionRate = 0.55;
    protected static final double RECOVERY_RATE_EDEFAULT = 0.274;
    protected double recoveryRate = 0.274;
    protected static final double IMMUNITY_LOSS_RATE_EDEFAULT = 0.0055;
    protected double immunityLossRate = 0.0055;
    protected static final double ADE_FACTOR_EDEFAULT = 1.0;
    protected double adeFactor = 1.0;
    protected static final double IMMUNITY_STRENGTH_EDEFAULT = 0.0;
    protected double immunityStrength = 0.0;
    protected static final double PRIMARY_DEATH_RATE_EDEFAULT = 0.0;
    protected double primaryDeathRate = 0.0;
    protected static final double SECONDARY_DEATH_RATE_EDEFAULT = 0.0;
    protected double secondaryDeathRate = 0.0;

    protected EClass eStaticClass() {
        return VectorPackage.Literals.VERY_SIMPLE_DENGUE_MODEL;
    }

    @Override
    public double getTransmissionRate() {
        return this.transmissionRate;
    }

    @Override
    public void setTransmissionRate(double newTransmissionRate) {
        this.transmissionRate = newTransmissionRate;
    }

    @Override
    public double getRecoveryRate() {
        return this.recoveryRate;
    }

    @Override
    public void setRecoveryRate(double newRecoveryRate) {
        this.recoveryRate = newRecoveryRate;
    }

    @Override
    public double getImmunityLossRate() {
        return this.immunityLossRate;
    }

    @Override
    public void setImmunityLossRate(double newImmunityLossRate) {
        this.immunityLossRate = newImmunityLossRate;
    }

    @Override
    public double getAdeFactor() {
        return this.adeFactor;
    }

    @Override
    public void setAdeFactor(double newAdeFactor) {
        this.adeFactor = newAdeFactor;
    }

    @Override
    public double getImmunityStrength() {
        return this.immunityStrength;
    }

    @Override
    public void setImmunityStrength(double newImmunityStrength) {
        this.immunityStrength = newImmunityStrength;
    }

    @Override
    public double getPrimaryDeathRate() {
        return this.primaryDeathRate;
    }

    @Override
    public void setPrimaryDeathRate(double newPrimaryDeathRate) {
        this.primaryDeathRate = newPrimaryDeathRate;
    }

    @Override
    public double getSecondaryDeathRate() {
        return this.secondaryDeathRate;
    }

    @Override
    public void setSecondaryDeathRate(double newSecondaryDeathRate) {
        this.secondaryDeathRate = newSecondaryDeathRate;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getTransmissionRate();
            }
            case 20: {
                return this.getRecoveryRate();
            }
            case 21: {
                return this.getImmunityLossRate();
            }
            case 22: {
                return this.getAdeFactor();
            }
            case 23: {
                return this.getImmunityStrength();
            }
            case 24: {
                return this.getPrimaryDeathRate();
            }
            case 25: {
                return this.getSecondaryDeathRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.setTransmissionRate((Double)newValue);
                return;
            }
            case 20: {
                this.setRecoveryRate((Double)newValue);
                return;
            }
            case 21: {
                this.setImmunityLossRate((Double)newValue);
                return;
            }
            case 22: {
                this.setAdeFactor((Double)newValue);
                return;
            }
            case 23: {
                this.setImmunityStrength((Double)newValue);
                return;
            }
            case 24: {
                this.setPrimaryDeathRate((Double)newValue);
                return;
            }
            case 25: {
                this.setSecondaryDeathRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.setTransmissionRate(0.55);
                return;
            }
            case 20: {
                this.setRecoveryRate(0.274);
                return;
            }
            case 21: {
                this.setImmunityLossRate(0.0055);
                return;
            }
            case 22: {
                this.setAdeFactor(1.0);
                return;
            }
            case 23: {
                this.setImmunityStrength(0.0);
                return;
            }
            case 24: {
                this.setPrimaryDeathRate(0.0);
                return;
            }
            case 25: {
                this.setSecondaryDeathRate(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return this.transmissionRate != 0.55;
            }
            case 20: {
                return this.recoveryRate != 0.274;
            }
            case 21: {
                return this.immunityLossRate != 0.0055;
            }
            case 22: {
                return this.adeFactor != 1.0;
            }
            case 23: {
                return this.immunityStrength != 0.0;
            }
            case 24: {
                return this.primaryDeathRate != 0.0;
            }
            case 25: {
                return this.secondaryDeathRate != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (transmissionRate: ");
        result.append(this.transmissionRate);
        result.append(", recoveryRate: ");
        result.append(this.recoveryRate);
        result.append(", immunityLossRate: ");
        result.append(this.immunityLossRate);
        result.append(", adeFactor: ");
        result.append(this.adeFactor);
        result.append(", immunityStrength: ");
        result.append(this.immunityStrength);
        result.append(", primaryDeathRate: ");
        result.append(this.primaryDeathRate);
        result.append(", secondaryDeathRate: ");
        result.append(this.secondaryDeathRate);
        result.append(')');
        return result.toString();
    }

    public void applyExternalDeltas(STEMTime currentTime, double continuousTime, long timeDelta, EList<DynamicLabel> labels) {
        super.applyExternalDeltas(currentTime, continuousTime, timeDelta, labels);
    }

    public void doStochasticProcess(IntegrationLabel iLabel, long timeDelta) {
        IntegrationLabelValue nextVal = (IntegrationLabelValue)iLabel.getNextValue();
        EList attrs = nextVal.eClass().getEAllAttributes();
        int i = 0;
        while (i < attrs.size()) {
            EAttribute attr = (EAttribute)attrs.get(i);
            if (attr.getEType().getClassifierID() == 31 && attr.isChangeable()) {
                nextVal.eSetDouble(attr.getFeatureID(), (double)Math.round(nextVal.eGetDouble(attr.getFeatureID())));
            }
            ++i;
        }
        if (this.getBinomialDistribution() == null) {
            this.setBinomialDistribution(new BinomialDistributionUtil(this.getRandomSeed()));
        }
        if (iLabel.getNextValue() instanceof DengueModelHostLabelValue) {
            DengueModelHostLabelValue nextDHLV = (DengueModelHostLabelValue)iLabel.getNextValue();
            DengueModelHostLabelValue previousDHLV = (DengueModelHostLabelValue)iLabel.getCurrentValue();
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence1(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E1(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence2(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E2(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence3(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E3(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence4(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E4(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R1(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence12(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E12(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R1(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence13(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E13(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R1(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence14(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E14(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R2(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence21(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E21(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R2(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence23(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E23(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R2(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence24(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E24(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R3(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence31(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E31(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R3(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence32(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E32(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R3(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence34(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E34(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R4(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence41(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E41(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R4(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence42(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E42(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDHLV, (IntegrationLabelValue)nextDHLV, VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R4(), VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence43(), VectorPackage.eINSTANCE.getDengueModelHostLabelValue_E43(), 1.0);
            nextDHLV.setIncidence(nextDHLV.getIncidence1() + nextDHLV.getIncidence2() + nextDHLV.getIncidence3() + nextDHLV.getIncidence4() + nextDHLV.getIncidence12() + nextDHLV.getIncidence13() + nextDHLV.getIncidence14() + nextDHLV.getIncidence21() + nextDHLV.getIncidence23() + nextDHLV.getIncidence24() + nextDHLV.getIncidence31() + nextDHLV.getIncidence32() + nextDHLV.getIncidence34() + nextDHLV.getIncidence41() + nextDHLV.getIncidence42() + nextDHLV.getIncidence43());
        } else if (iLabel.getNextValue() instanceof DengueModelVectorLabelValue) {
            DengueModelVectorLabelValue nextDVLV = (DengueModelVectorLabelValue)iLabel.getNextValue();
            DengueModelVectorLabelValue previousDVLV = (DengueModelVectorLabelValue)iLabel.getCurrentValue();
            this.addNoise((IntegrationLabelValue)previousDVLV, (IntegrationLabelValue)nextDVLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_Incidence1(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_E1(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDVLV, (IntegrationLabelValue)nextDVLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_Incidence2(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_E2(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDVLV, (IntegrationLabelValue)nextDVLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_Incidence3(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_E3(), 1.0);
            this.addNoise((IntegrationLabelValue)previousDVLV, (IntegrationLabelValue)nextDVLV, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_Incidence4(), VectorPackage.eINSTANCE.getDengueModelVectorLabelValue_E4(), 1.0);
            nextDVLV.setIncidence(nextDVLV.getIncidence1() + nextDVLV.getIncidence2() + nextDVLV.getIncidence3() + nextDVLV.getIncidence4());
        }
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedTransmissionRate = this.getTransmissionRate() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustedRecoveryRate = this.getRecoveryRate() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustedImmunityLossRate = this.getImmunityLossRate() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustedPrimaryDeathRate = this.getPrimaryDeathRate() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustedSecondaryDeathRate = this.getSecondaryDeathRate() * (double)timeDelta / (double)this.getTimePeriod();
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SimpleDengueModelHostLabelValue host = (SimpleDengueModelHostLabelValue)currentState;
            double hostPopulationCount = host.getPopulationCount();
            if (hostPopulationCount != 0.0) {
                double[] effectives = (double[])this.dArrayObjectPool.get();
                this.determineMixingStrategy();
                this.dengueUtil.getNormalizedEffectiveInfectious(this, diseaseLabel, effectives, this.doCommonBorderMixing, this.edgeListObjectPool, this.characteristicMixingDistance, this.roadNetworkInfectiousProportion, this.getPopulationIdentifier(), this.isFrequencyDependent());
                double effectiveI1 = effectives[0];
                double effectiveI12 = effectives[1];
                double effectiveI13 = effectives[2];
                double effectiveI14 = effectives[3];
                double effectiveI2 = effectives[4];
                double effectiveI21 = effectives[5];
                double effectiveI23 = effectives[6];
                double effectiveI24 = effectives[7];
                double effectiveI3 = effectives[8];
                double effectiveI31 = effectives[9];
                double effectiveI32 = effectives[10];
                double effectiveI34 = effectives[11];
                double effectiveI4 = effectives[12];
                double effectiveI41 = effectives[13];
                double effectiveI42 = effectives[14];
                double effectiveI43 = effectives[15];
                this.dArrayObjectPool.release((Object)effectives);
                double effectiveIX1 = effectiveI21 + effectiveI31 + effectiveI41;
                double effectiveIX2 = effectiveI12 + effectiveI32 + effectiveI42;
                double effectiveIX3 = effectiveI13 + effectiveI23 + effectiveI43;
                double effectiveIX4 = effectiveI14 + effectiveI24 + effectiveI34;
                double fromStoI1 = adjustedTransmissionRate * (effectiveI1 + this.getAdeFactor() * effectiveIX1) * host.getS();
                double fromStoI2 = adjustedTransmissionRate * (effectiveI2 + this.getAdeFactor() * effectiveIX2) * host.getS();
                double fromStoI3 = adjustedTransmissionRate * (effectiveI3 + this.getAdeFactor() * effectiveIX3) * host.getS();
                double fromStoI4 = adjustedTransmissionRate * (effectiveI4 + this.getAdeFactor() * effectiveIX4) * host.getS();
                double fromI1toC1 = adjustedRecoveryRate * host.getI1();
                double fromI2toC2 = adjustedRecoveryRate * host.getI2();
                double fromI3toC3 = adjustedRecoveryRate * host.getI3();
                double fromI4toC4 = adjustedRecoveryRate * host.getI4();
                double fromC1toR1 = adjustedImmunityLossRate * host.getC1();
                double fromC2toR2 = adjustedImmunityLossRate * host.getC2();
                double fromC3toR3 = adjustedImmunityLossRate * host.getC3();
                double fromC4toR4 = adjustedImmunityLossRate * host.getC4();
                double fromC1toI12 = adjustedTransmissionRate * (host.getI2() + this.adeFactor * effectiveIX2) * (1.0 - this.getImmunityStrength()) * host.getC1() / hostPopulationCount;
                double fromC1toI13 = adjustedTransmissionRate * (host.getI3() + this.adeFactor * effectiveIX3) * (1.0 - this.getImmunityStrength()) * host.getC1() / hostPopulationCount;
                double fromC1toI14 = adjustedTransmissionRate * (host.getI4() + this.adeFactor * effectiveIX4) * (1.0 - this.getImmunityStrength()) * host.getC1() / hostPopulationCount;
                double fromC2toI21 = adjustedTransmissionRate * (host.getI1() + this.adeFactor * effectiveIX1) * (1.0 - this.getImmunityStrength()) * host.getC2() / hostPopulationCount;
                double fromC2toI23 = adjustedTransmissionRate * (host.getI3() + this.adeFactor * effectiveIX3) * (1.0 - this.getImmunityStrength()) * host.getC2() / hostPopulationCount;
                double fromC2toI24 = adjustedTransmissionRate * (host.getI4() + this.adeFactor * effectiveIX4) * (1.0 - this.getImmunityStrength()) * host.getC2() / hostPopulationCount;
                double fromC3toI31 = adjustedTransmissionRate * (host.getI1() + this.adeFactor * effectiveIX1) * (1.0 - this.getImmunityStrength()) * host.getC3() / hostPopulationCount;
                double fromC3toI32 = adjustedTransmissionRate * (host.getI2() + this.adeFactor * effectiveIX2) * (1.0 - this.getImmunityStrength()) * host.getC3() / hostPopulationCount;
                double fromC3toI34 = adjustedTransmissionRate * (host.getI4() + this.adeFactor * effectiveIX4) * (1.0 - this.getImmunityStrength()) * host.getC3() / hostPopulationCount;
                double fromC4toI41 = adjustedTransmissionRate * (host.getI1() + this.adeFactor * effectiveIX1) * (1.0 - this.getImmunityStrength()) * host.getC4() / hostPopulationCount;
                double fromC4toI42 = adjustedTransmissionRate * (host.getI2() + this.adeFactor * effectiveIX2) * (1.0 - this.getImmunityStrength()) * host.getC4() / hostPopulationCount;
                double fromC4toI43 = adjustedTransmissionRate * (host.getI3() + this.adeFactor * effectiveIX3) * (1.0 - this.getImmunityStrength()) * host.getC4() / hostPopulationCount;
                double fromR1toI12 = adjustedTransmissionRate * (host.getI2() + this.adeFactor * effectiveIX2) * host.getR1() / hostPopulationCount;
                double fromR1toI13 = adjustedTransmissionRate * (host.getI3() + this.adeFactor * effectiveIX3) * host.getR1() / hostPopulationCount;
                double fromR1toI14 = adjustedTransmissionRate * (host.getI4() + this.adeFactor * effectiveIX4) * host.getR1() / hostPopulationCount;
                double fromR2toI21 = adjustedTransmissionRate * (host.getI1() + this.adeFactor * effectiveIX1) * host.getR2() / hostPopulationCount;
                double fromR2toI23 = adjustedTransmissionRate * (host.getI3() + this.adeFactor * effectiveIX3) * host.getR2() / hostPopulationCount;
                double fromR2toI24 = adjustedTransmissionRate * (host.getI4() + this.adeFactor * effectiveIX4) * host.getR2() / hostPopulationCount;
                double fromR3toI31 = adjustedTransmissionRate * (host.getI1() + this.adeFactor * effectiveIX1) * host.getR3() / hostPopulationCount;
                double fromR3toI32 = adjustedTransmissionRate * (host.getI2() + this.adeFactor * effectiveIX2) * host.getR3() / hostPopulationCount;
                double fromR3toI34 = adjustedTransmissionRate * (host.getI4() + this.adeFactor * effectiveIX4) * host.getR3() / hostPopulationCount;
                double fromR4toI41 = adjustedTransmissionRate * (host.getI1() + this.adeFactor * effectiveIX1) * host.getR4() / hostPopulationCount;
                double fromR4toI42 = adjustedTransmissionRate * (host.getI2() + this.adeFactor * effectiveIX2) * host.getR4() / hostPopulationCount;
                double fromR4toI43 = adjustedTransmissionRate * (host.getI4() + this.adeFactor * effectiveIX3) * host.getR4() / hostPopulationCount;
                double fromI12toR = adjustedRecoveryRate * host.getI12();
                double fromI13toR = adjustedRecoveryRate * host.getI13();
                double fromI14toR = adjustedRecoveryRate * host.getI14();
                double fromI21toR = adjustedRecoveryRate * host.getI21();
                double fromI23toR = adjustedRecoveryRate * host.getI23();
                double fromI24toR = adjustedRecoveryRate * host.getI24();
                double fromI31toR = adjustedRecoveryRate * host.getI31();
                double fromI32toR = adjustedRecoveryRate * host.getI32();
                double fromI34toR = adjustedRecoveryRate * host.getI34();
                double fromI41toR = adjustedRecoveryRate * host.getI41();
                double fromI42toR = adjustedRecoveryRate * host.getI42();
                double fromI43toR = adjustedRecoveryRate * host.getI43();
                double deathsI1 = adjustedPrimaryDeathRate * host.getI1();
                double deathsI2 = adjustedPrimaryDeathRate * host.getI2();
                double deathsI3 = adjustedPrimaryDeathRate * host.getI3();
                double deathsI4 = adjustedPrimaryDeathRate * host.getI4();
                double deathsI12 = adjustedSecondaryDeathRate * host.getI12();
                double deathsI13 = adjustedSecondaryDeathRate * host.getI13();
                double deathsI14 = adjustedSecondaryDeathRate * host.getI14();
                double deathsI21 = adjustedSecondaryDeathRate * host.getI21();
                double deathsI23 = adjustedSecondaryDeathRate * host.getI23();
                double deathsI24 = adjustedSecondaryDeathRate * host.getI24();
                double deathsI31 = adjustedSecondaryDeathRate * host.getI31();
                double deathsI32 = adjustedSecondaryDeathRate * host.getI32();
                double deathsI34 = adjustedSecondaryDeathRate * host.getI34();
                double deathsI41 = adjustedSecondaryDeathRate * host.getI41();
                double deathsI42 = adjustedSecondaryDeathRate * host.getI42();
                double deathsI43 = adjustedSecondaryDeathRate * host.getI43();
                Exchange fromStoI1Exchange = (Exchange)ExchangePool.POOL.get();
                fromStoI1Exchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                fromStoI1Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I1());
                fromStoI1Exchange.setCount(fromStoI1);
                fromStoI1Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence1());
                fromStoI1Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromStoI1Exchange);
                Exchange fromStoI2Exchange = (Exchange)ExchangePool.POOL.get();
                fromStoI2Exchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                fromStoI2Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I2());
                fromStoI2Exchange.setCount(fromStoI2);
                fromStoI2Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence2());
                fromStoI2Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromStoI2Exchange);
                Exchange fromStoI3Exchange = (Exchange)ExchangePool.POOL.get();
                fromStoI3Exchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                fromStoI3Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I3());
                fromStoI3Exchange.setCount(fromStoI3);
                fromStoI3Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence3());
                fromStoI3Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromStoI3Exchange);
                Exchange fromStoI4Exchange = (Exchange)ExchangePool.POOL.get();
                fromStoI4Exchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                fromStoI4Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I4());
                fromStoI4Exchange.setCount(fromStoI4);
                fromStoI4Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence4());
                fromStoI4Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromStoI4Exchange);
                Exchange fromI1toC1Exchange = (Exchange)ExchangePool.POOL.get();
                fromI1toC1Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I1());
                fromI1toC1Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C1());
                fromI1toC1Exchange.setCount(fromI1toC1);
                fromI1toC1Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI1toC1Exchange);
                Exchange fromI2toC2Exchange = (Exchange)ExchangePool.POOL.get();
                fromI2toC2Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I2());
                fromI2toC2Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C2());
                fromI2toC2Exchange.setCount(fromI2toC2);
                fromI2toC2Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI2toC2Exchange);
                Exchange fromI3toC3Exchange = (Exchange)ExchangePool.POOL.get();
                fromI3toC3Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I3());
                fromI3toC3Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C3());
                fromI3toC3Exchange.setCount(fromI3toC3);
                fromI3toC3Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI3toC3Exchange);
                Exchange fromI4toC4Exchange = (Exchange)ExchangePool.POOL.get();
                fromI4toC4Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I4());
                fromI4toC4Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C4());
                fromI4toC4Exchange.setCount(fromI4toC4);
                fromI4toC4Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI4toC4Exchange);
                Exchange fromC1toR1Exchange = (Exchange)ExchangePool.POOL.get();
                fromC1toR1Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C1());
                fromC1toR1Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R1());
                fromC1toR1Exchange.setCount(fromC1toR1);
                fromC1toR1Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC1toR1Exchange);
                Exchange fromC2toR2Exchange = (Exchange)ExchangePool.POOL.get();
                fromC2toR2Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C2());
                fromC2toR2Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R2());
                fromC2toR2Exchange.setCount(fromC2toR2);
                fromC2toR2Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC2toR2Exchange);
                Exchange fromC3toR3Exchange = (Exchange)ExchangePool.POOL.get();
                fromC3toR3Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C3());
                fromC3toR3Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R3());
                fromC3toR3Exchange.setCount(fromC3toR3);
                fromC3toR3Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC3toR3Exchange);
                Exchange fromC4toR4Exchange = (Exchange)ExchangePool.POOL.get();
                fromC4toR4Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C4());
                fromC4toR4Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R4());
                fromC4toR4Exchange.setCount(fromC4toR4);
                fromC4toR4Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC4toR4Exchange);
                Exchange fromC1toI12Exchange = (Exchange)ExchangePool.POOL.get();
                fromC1toI12Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C1());
                fromC1toI12Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I12());
                fromC1toI12Exchange.setCount(fromC1toI12);
                fromC1toI12Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence12());
                fromC1toI12Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC1toI12Exchange);
                Exchange fromC1toI13Exchange = (Exchange)ExchangePool.POOL.get();
                fromC1toI13Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C1());
                fromC1toI13Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I13());
                fromC1toI13Exchange.setCount(fromC1toI13);
                fromC1toI13Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence13());
                fromC1toI13Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC1toI13Exchange);
                Exchange fromC1toI14Exchange = (Exchange)ExchangePool.POOL.get();
                fromC1toI14Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C1());
                fromC1toI14Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I13());
                fromC1toI14Exchange.setCount(fromC1toI13);
                fromC1toI14Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence14());
                fromC1toI14Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC1toI14Exchange);
                Exchange fromC2toI21Exchange = (Exchange)ExchangePool.POOL.get();
                fromC2toI21Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C2());
                fromC2toI21Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I21());
                fromC2toI21Exchange.setCount(fromC2toI21);
                fromC2toI21Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence21());
                fromC2toI21Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC2toI21Exchange);
                Exchange fromC2toI23Exchange = (Exchange)ExchangePool.POOL.get();
                fromC2toI23Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C2());
                fromC2toI23Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I23());
                fromC2toI23Exchange.setCount(fromC2toI23);
                fromC2toI23Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence23());
                fromC2toI23Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC2toI23Exchange);
                Exchange fromC2toI24Exchange = (Exchange)ExchangePool.POOL.get();
                fromC2toI24Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C2());
                fromC2toI24Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I24());
                fromC2toI24Exchange.setCount(fromC2toI24);
                fromC2toI24Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence24());
                fromC2toI24Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC2toI24Exchange);
                Exchange fromC3toI31Exchange = (Exchange)ExchangePool.POOL.get();
                fromC3toI31Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C3());
                fromC3toI31Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I31());
                fromC3toI31Exchange.setCount(fromC3toI31);
                fromC3toI31Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence31());
                fromC3toI31Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC3toI31Exchange);
                Exchange fromC3toI32Exchange = (Exchange)ExchangePool.POOL.get();
                fromC3toI32Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C3());
                fromC3toI32Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I32());
                fromC3toI32Exchange.setCount(fromC3toI32);
                fromC3toI32Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence32());
                fromC3toI32Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC3toI32Exchange);
                Exchange fromC3toI34Exchange = (Exchange)ExchangePool.POOL.get();
                fromC3toI34Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C3());
                fromC3toI34Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I34());
                fromC3toI34Exchange.setCount(fromC3toI34);
                fromC3toI34Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence34());
                fromC3toI34Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC3toI34Exchange);
                Exchange fromC4toI41Exchange = (Exchange)ExchangePool.POOL.get();
                fromC4toI41Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C4());
                fromC4toI41Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I41());
                fromC4toI41Exchange.setCount(fromC4toI41);
                fromC4toI41Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence41());
                fromC4toI41Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC4toI41Exchange);
                Exchange fromC4toI42Exchange = (Exchange)ExchangePool.POOL.get();
                fromC4toI42Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C4());
                fromC4toI42Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I42());
                fromC4toI42Exchange.setCount(fromC4toI42);
                fromC4toI42Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence42());
                fromC4toI42Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC4toI42Exchange);
                Exchange fromC4toI43Exchange = (Exchange)ExchangePool.POOL.get();
                fromC4toI43Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_C4());
                fromC4toI43Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I43());
                fromC4toI43Exchange.setCount(fromC4toI43);
                fromC4toI43Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence43());
                fromC4toI43Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromC4toI43Exchange);
                Exchange fromR1toI12Exchange = (Exchange)ExchangePool.POOL.get();
                fromR1toI12Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R1());
                fromR1toI12Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I12());
                fromR1toI12Exchange.setCount(fromR1toI12);
                fromR1toI12Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence12());
                fromR1toI12Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR1toI12Exchange);
                Exchange fromR1toI13Exchange = (Exchange)ExchangePool.POOL.get();
                fromR1toI13Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R1());
                fromR1toI13Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I13());
                fromR1toI13Exchange.setCount(fromR1toI13);
                fromR1toI13Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence13());
                fromR1toI13Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR1toI13Exchange);
                Exchange fromR1toI14Exchange = (Exchange)ExchangePool.POOL.get();
                fromR1toI14Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R1());
                fromR1toI14Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I14());
                fromR1toI14Exchange.setCount(fromR1toI14);
                fromR1toI14Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence14());
                fromR1toI14Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR1toI14Exchange);
                Exchange fromR2toI21Exchange = (Exchange)ExchangePool.POOL.get();
                fromR2toI21Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R2());
                fromR2toI21Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I21());
                fromR2toI21Exchange.setCount(fromR2toI21);
                fromR2toI21Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence21());
                fromR2toI21Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR2toI21Exchange);
                Exchange fromR2toI23Exchange = (Exchange)ExchangePool.POOL.get();
                fromR2toI23Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R2());
                fromR2toI23Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I23());
                fromR2toI23Exchange.setCount(fromR2toI23);
                fromR2toI23Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence23());
                fromR2toI23Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR2toI23Exchange);
                Exchange fromR2toI24Exchange = (Exchange)ExchangePool.POOL.get();
                fromR2toI24Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R2());
                fromR2toI24Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I24());
                fromR2toI24Exchange.setCount(fromR2toI24);
                fromR2toI24Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence24());
                fromR2toI24Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR2toI24Exchange);
                Exchange fromR3toI31Exchange = (Exchange)ExchangePool.POOL.get();
                fromR3toI31Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R3());
                fromR3toI31Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I31());
                fromR3toI31Exchange.setCount(fromR3toI31);
                fromR3toI31Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence31());
                fromR3toI31Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR3toI31Exchange);
                Exchange fromR3toI32Exchange = (Exchange)ExchangePool.POOL.get();
                fromR3toI32Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R3());
                fromR3toI32Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I32());
                fromR3toI32Exchange.setCount(fromR3toI32);
                fromR3toI32Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence32());
                fromR3toI32Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR3toI32Exchange);
                Exchange fromR3toI34Exchange = (Exchange)ExchangePool.POOL.get();
                fromR3toI34Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R3());
                fromR3toI34Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I34());
                fromR3toI34Exchange.setCount(fromR3toI34);
                fromR3toI34Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence34());
                fromR3toI34Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR3toI34Exchange);
                Exchange fromR4toI41Exchange = (Exchange)ExchangePool.POOL.get();
                fromR4toI41Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R4());
                fromR4toI41Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I41());
                fromR4toI41Exchange.setCount(fromR4toI41);
                fromR4toI41Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence41());
                fromR4toI41Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR4toI41Exchange);
                Exchange fromR4toI42Exchange = (Exchange)ExchangePool.POOL.get();
                fromR4toI42Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R4());
                fromR4toI42Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I42());
                fromR4toI42Exchange.setCount(fromR4toI42);
                fromR4toI42Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence42());
                fromR4toI42Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR4toI42Exchange);
                Exchange fromR4toI43Exchange = (Exchange)ExchangePool.POOL.get();
                fromR4toI43Exchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R4());
                fromR4toI43Exchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I43());
                fromR4toI43Exchange.setCount(fromR4toI43);
                fromR4toI43Exchange.getForIncidence().add((Object)VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_Incidence43());
                fromR4toI43Exchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromR4toI43Exchange);
                Exchange fromI12toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI12toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I12());
                fromI12toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI12toRExchange.setCount(fromI12toR);
                fromI12toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI12toRExchange);
                Exchange fromI13toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI13toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I13());
                fromI13toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI13toRExchange.setCount(fromI13toR);
                fromI13toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI13toRExchange);
                Exchange fromI14toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI14toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I14());
                fromI14toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI14toRExchange.setCount(fromI14toR);
                fromI14toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI14toRExchange);
                Exchange fromI21toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI21toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I21());
                fromI21toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI21toRExchange.setCount(fromI21toR);
                fromI21toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI21toRExchange);
                Exchange fromI23toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI23toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I23());
                fromI23toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI23toRExchange.setCount(fromI23toR);
                fromI23toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI23toRExchange);
                Exchange fromI24toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI24toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I24());
                fromI24toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI24toRExchange.setCount(fromI24toR);
                fromI24toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI24toRExchange);
                Exchange fromI31toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI31toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I31());
                fromI31toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI31toRExchange.setCount(fromI31toR);
                fromI31toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI31toRExchange);
                Exchange fromI32toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI32toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I32());
                fromI32toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI32toRExchange.setCount(fromI32toR);
                fromI32toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI32toRExchange);
                Exchange fromI34toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI34toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I34());
                fromI34toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI34toRExchange.setCount(fromI34toR);
                fromI34toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI34toRExchange);
                Exchange fromI41toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI41toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I41());
                fromI41toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI41toRExchange.setCount(fromI41toR);
                fromI41toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI41toRExchange);
                Exchange fromI42toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI42toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I42());
                fromI42toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI42toRExchange.setCount(fromI42toR);
                fromI42toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI42toRExchange);
                Exchange fromI43toRExchange = (Exchange)ExchangePool.POOL.get();
                fromI43toRExchange.setSource(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_I43());
                fromI43toRExchange.setTarget(VectorPackage.eINSTANCE.getSimpleDengueModelHostLabelValue_R());
                fromI43toRExchange.setCount(fromI43toR);
                fromI43toRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)fromI43toRExchange);
                SimpleDengueModelHostLabelValue hostDelta = (SimpleDengueModelHostLabelValue)deltaValue;
                hostDelta.setS(-fromStoI1 - fromStoI2 - fromStoI3 - fromStoI4);
                hostDelta.setI1(fromStoI1 - fromI1toC1 - deathsI1);
                hostDelta.setI2(fromStoI2 - fromI2toC2 - deathsI2);
                hostDelta.setI3(fromStoI3 - fromI3toC3 - deathsI3);
                hostDelta.setI4(fromStoI4 - fromI4toC4 - deathsI4);
                hostDelta.setC1(fromI1toC1 - fromC1toI12 - fromC1toI13 - fromC1toI14 - fromC1toR1);
                hostDelta.setC2(fromI2toC2 - fromC2toI21 - fromC2toI23 - fromC2toI24 - fromC2toR2);
                hostDelta.setC3(fromI3toC3 - fromC3toI31 - fromC3toI32 - fromC3toI34 - fromC3toR3);
                hostDelta.setC4(fromI4toC4 - fromC4toI41 - fromC4toI42 - fromC4toI43 - fromC4toR4);
                hostDelta.setR1(fromC1toR1 - fromR1toI12 - fromR1toI13 - fromR1toI14);
                hostDelta.setR2(fromC2toR2 - fromR2toI21 - fromR2toI23 - fromR2toI24);
                hostDelta.setR3(fromC3toR3 - fromR3toI31 - fromR3toI32 - fromR3toI34);
                hostDelta.setR4(fromC4toR4 - fromR4toI41 - fromR4toI42 - fromR4toI43);
                hostDelta.setI12(fromC1toI12 + fromR1toI12 - fromI12toR - deathsI12);
                hostDelta.setI13(fromC1toI13 + fromR1toI13 - fromI13toR - deathsI13);
                hostDelta.setI14(fromC1toI14 + fromR1toI14 - fromI14toR - deathsI14);
                hostDelta.setI21(fromC2toI21 + fromR2toI21 - fromI21toR - deathsI21);
                hostDelta.setI23(fromC2toI23 + fromR2toI23 - fromI23toR - deathsI23);
                hostDelta.setI24(fromC2toI24 + fromR2toI24 - fromI24toR - deathsI24);
                hostDelta.setI31(fromC3toI31 + fromR3toI31 - fromI31toR - deathsI31);
                hostDelta.setI32(fromC3toI32 + fromR3toI32 - fromI32toR - deathsI32);
                hostDelta.setI34(fromC3toI34 + fromR3toI34 - fromI34toR - deathsI34);
                hostDelta.setI41(fromC4toI41 + fromR4toI41 - fromI41toR - deathsI41);
                hostDelta.setI42(fromC4toI42 + fromR4toI42 - fromI42toR - deathsI42);
                hostDelta.setI43(fromC4toI43 + fromR4toI43 - fromI43toR - deathsI43);
                hostDelta.setR(fromI12toR + fromI13toR + fromI14toR + fromI21toR + fromI23toR + fromI24toR + fromI31toR + fromI32toR + fromI34toR + fromI41toR + fromI42toR + fromI43toR);
                hostDelta.setIncidence1(fromStoI1);
                hostDelta.setIncidence2(fromStoI2);
                hostDelta.setIncidence3(fromStoI3);
                hostDelta.setIncidence4(fromStoI4);
                hostDelta.setIncidence12(fromR1toI12 + fromC1toI12);
                hostDelta.setIncidence13(fromR1toI13 + fromC1toI13);
                hostDelta.setIncidence14(fromR1toI14 + fromC1toI14);
                hostDelta.setIncidence21(fromR2toI21 + fromC2toI21);
                hostDelta.setIncidence23(fromR2toI23 + fromC2toI23);
                hostDelta.setIncidence24(fromR2toI24 + fromC2toI24);
                hostDelta.setIncidence31(fromR3toI31 + fromC3toI31);
                hostDelta.setIncidence32(fromR3toI32 + fromC3toI32);
                hostDelta.setIncidence34(fromR3toI34 + fromC3toI34);
                hostDelta.setIncidence41(fromR4toI41 + fromC4toI41);
                hostDelta.setIncidence42(fromR4toI42 + fromC4toI42);
                hostDelta.setIncidence43(fromR4toI43 + fromC4toI43);
                hostDelta.setIncidence(hostDelta.getIncidence1() + hostDelta.getIncidence2() + hostDelta.getIncidence3() + hostDelta.getIncidence4() + hostDelta.getIncidence12() + hostDelta.getIncidence13() + hostDelta.getIncidence14() + hostDelta.getIncidence21() + hostDelta.getIncidence23() + hostDelta.getIncidence24() + hostDelta.getIncidence31() + hostDelta.getIncidence32() + hostDelta.getIncidence34() + hostDelta.getIncidence41() + hostDelta.getIncidence42() + hostDelta.getIncidence43());
                hostDelta.setDiseaseDeaths1(deathsI1);
                hostDelta.setDiseaseDeaths2(deathsI2);
                hostDelta.setDiseaseDeaths3(deathsI3);
                hostDelta.setDiseaseDeaths4(deathsI4);
                hostDelta.setDiseaseDeaths12(deathsI12);
                hostDelta.setDiseaseDeaths13(deathsI13);
                hostDelta.setDiseaseDeaths14(deathsI14);
                hostDelta.setDiseaseDeaths21(deathsI21);
                hostDelta.setDiseaseDeaths23(deathsI23);
                hostDelta.setDiseaseDeaths24(deathsI24);
                hostDelta.setDiseaseDeaths31(deathsI31);
                hostDelta.setDiseaseDeaths32(deathsI32);
                hostDelta.setDiseaseDeaths34(deathsI34);
                hostDelta.setDiseaseDeaths41(deathsI41);
                hostDelta.setDiseaseDeaths42(deathsI42);
                hostDelta.setDiseaseDeaths43(deathsI43);
                hostDelta.setDiseaseDeaths(deathsI1 + deathsI2 + deathsI3 + deathsI4 + deathsI12 + deathsI13 + deathsI14 + deathsI21 + deathsI23 + deathsI24 + deathsI31 + deathsI32 + deathsI34 + deathsI41 + deathsI42 + deathsI43);
                this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            }
            ++_i;
        }
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return VectorFactory.eINSTANCE.createSimpleDengueModelHostLabel();
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return VectorFactory.eINSTANCE.createSimpleDengueModelHostLabelValue();
    }

    public Infector createInfector() {
        SIInfector retValue = StandardFactory.eINSTANCE.createSIInfector();
        retValue.setDiseaseName(this.getDiseaseName());
        retValue.setPopulationIdentifier(this.getPopulationIdentifier());
        return retValue;
    }
}

