/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.JvmTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConformanceResult {
    private static final Logger log = Logger.getLogger(TypeConformanceResult.class);
    public static final TypeConformanceResult SUCCESS = new TypeConformanceResult(Kind.SUCCESS);
    public static final TypeConformanceResult SUBTYPE = new TypeConformanceResult(Kind.SUBTYPE);
    public static final TypeConformanceResult FAILED = new TypeConformanceResult(Kind.FAILED);
    private final EnumSet<Kind> kinds;
    private JvmTypeReference from;
    private JvmTypeReference to;
    private int synonymIndex;
    private final Exception trace;

    public static TypeConformanceResult merge(TypeConformanceResult first, TypeConformanceResult second) {
        TypeConformanceResult result = new TypeConformanceResult(first.getKinds(), null);
        result.getKinds().addAll(second.getKinds());
        result.from = first.from;
        result.to = first.to;
        result.synonymIndex = first.synonymIndex;
        return result;
    }

    public TypeConformanceResult(Kind kind) {
        this(EnumSet.of(kind), null);
    }

    public TypeConformanceResult(Kind kind, Exception trace) {
        this(EnumSet.of(kind), trace);
    }

    public TypeConformanceResult(EnumSet<Kind> kinds, Exception trace) {
        this.kinds = EnumSet.copyOf(kinds);
        this.trace = log.isDebugEnabled() && trace == null ? new Exception("trace") : trace;
    }

    public boolean isConformant() {
        return !this.kinds.contains((Object)Kind.FAILED) && !this.kinds.contains((Object)Kind.EXCEPTION);
    }

    protected void setConversion(JvmTypeReference from, JvmTypeReference to) {
        this.from = from;
        this.to = to;
    }

    protected void setSynonymIndex(int synonymIndex) {
        this.synonymIndex = synonymIndex;
    }

    public JvmTypeReference getConvertFrom() {
        return this.from;
    }

    public JvmTypeReference getConvertTo() {
        return this.to;
    }

    public EnumSet<Kind> getKinds() {
        return this.kinds;
    }

    public int getSynonymIndex() {
        return this.synonymIndex;
    }

    public Exception getTrace() {
        return this.trace;
    }

    public String toString() {
        return "TypeConformanceResult [kinds=" + this.kinds + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        SUCCESS,
        SUBTYPE,
        PRIMITIVE_WIDENING,
        BOXING,
        UNBOXING,
        SYNONYM,
        DEMAND_CONVERSION,
        FAILED,
        EXCEPTION;

    }
}

