/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VariableInputDialog
extends Dialog {
    private static String DIALOG_SETTINGS_SECTION = "RuntimeClasspathAction.VariableInputDialog";
    private Text fText;
    private String fVariableString;

    public VariableInputDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    protected Control createDialogArea(Composite parent) {
        Composite inner = (Composite)super.createDialogArea(parent);
        ((GridLayout)inner.getLayout()).numColumns = 2;
        Label label = new Label(inner, 0);
        label.setText(AntLaunchConfigurationMessages.AddVariableStringAction_2);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fText = new Text(inner, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 200;
        this.fText.setLayoutData((Object)gd);
        Button button = new Button(inner, 8);
        button.setText(AntLaunchConfigurationMessages.AddVariableStringAction_3);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                VariableInputDialog.this.getVariable();
            }
        });
        VariableInputDialog.applyDialogFont((Control)parent);
        return inner;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(AntLaunchConfigurationMessages.AddVariableStringAction_4);
    }

    private void getVariable() {
        String variable;
        StringVariableSelectionDialog variableDialog = new StringVariableSelectionDialog(this.getShell());
        int returnCode = variableDialog.open();
        if (returnCode == 0 && (variable = variableDialog.getVariableExpression()) != null) {
            this.fText.insert(variable);
        }
    }

    protected void okPressed() {
        String variableString = this.fText.getText();
        this.fVariableString = variableString != null && variableString.trim().length() > 0 ? variableString : null;
        super.okPressed();
    }

    public String getVariableString() {
        return this.fVariableString;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = AntUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }
}

