/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaSourcePackageFragmentRootCompletionProcessor;
import org.eclipse.jdt.internal.ui.refactoring.nls.SourceChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class SourceFolderSelectionDialogButtonField
extends StringButtonDialogField
implements IDialogFieldListener {
    private IPackageFragmentRoot fRoot;
    private SourceChangeListener fListener;
    private IDialogFieldListener fUpdateListener;

    public SourceFolderSelectionDialogButtonField(String descriptionLabel, String browseLabel, IStringButtonAdapter adapter) {
        super(adapter);
        this.setContentAssistProcessor(new JavaSourcePackageFragmentRootCompletionProcessor());
        this.setLabelText(descriptionLabel);
        this.setButtonLabel(browseLabel);
        this.setDialogFieldListener(this);
    }

    public void dialogFieldChanged(DialogField field) {
        this.setRoot(this.getRootFromString(this.getText()));
    }

    public void setUpdateListener(IDialogFieldListener updateListener) {
        this.fUpdateListener = updateListener;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns, int textWidth) {
        Control[] res = super.doFillIntoGrid(parent, nColumns);
        Text text = this.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, textWidth);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        return res;
    }

    public void setSourceChangeListener(SourceChangeListener listener) {
        this.fListener = listener;
    }

    private IPackageFragmentRoot getRootFromString(String rootString) {
        if (rootString.length() == 0) {
            return null;
        }
        Path path = new Path(rootString);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = workspaceRoot.findMember((IPath)path);
        if (res == null) {
            return null;
        }
        int resType = res.getType();
        if (resType == 4 || resType == 2) {
            IProject proj = res.getProject();
            if (!proj.isOpen()) {
                return null;
            }
            IJavaProject jproject = JavaCore.create((IProject)proj);
            IPackageFragmentRoot root = jproject.getPackageFragmentRoot(res);
            if (root.exists()) {
                return root;
            }
        }
        return null;
    }

    public void setRoot(IPackageFragmentRoot root) {
        this.fRoot = root;
        if (this.fRoot != null) {
            String str = this.getRootString();
            if (!this.getText().equals(str)) {
                this.setText(str);
            }
        }
        this.fListener.sourceRootChanged(this.fRoot);
        if (this.fUpdateListener != null) {
            this.fUpdateListener.dialogFieldChanged(this);
        }
    }

    public IPackageFragmentRoot getRoot() {
        return this.fRoot;
    }

    private String getRootString() {
        return this.fRoot == null ? "" : this.fRoot.getPath().makeRelative().toString();
    }
}

