/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.JavadocHelpContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.ui.IWorkbenchPart;

public class JavaUIHelp {
    public static void setHelp(StructuredViewer viewer, String contextId) {
        JavaUIHelpListener listener = new JavaUIHelpListener(viewer, contextId);
        viewer.getControl().addHelpListener((HelpListener)listener);
    }

    public static void setHelp(JavaEditor editor, StyledText text, String contextId) {
        JavaUIHelpListener listener = new JavaUIHelpListener(editor, contextId);
        text.addHelpListener((HelpListener)listener);
    }

    public static IContextProvider getHelpContextProvider(IWorkbenchPart part, String contextId) {
        IStructuredSelection selection;
        try {
            selection = SelectionConverter.getStructuredSelection(part);
        }
        catch (JavaModelException ex) {
            JavaPlugin.log(ex);
            selection = StructuredSelection.EMPTY;
        }
        Object[] elements = selection.toArray();
        return new JavaUIHelpContextProvider(contextId, elements);
    }

    private static class JavaUIHelpContextProvider
    implements IContextProvider {
        private String fId;
        private Object[] fSelected;

        public JavaUIHelpContextProvider(String id, Object[] selected) {
            this.fId = id;
            this.fSelected = selected;
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object target) {
            Object context;
            block3: {
                context = HelpSystem.getContext((String)this.fId);
                if (this.fSelected != null && this.fSelected.length > 0) {
                    try {
                        context = new JavadocHelpContext((IContext)context, this.fSelected);
                    }
                    catch (JavaModelException e) {
                        if (e.isDoesNotExist()) break block3;
                        JavaPlugin.log(e);
                    }
                }
            }
            return context;
        }

        public String getSearchExpression(Object target) {
            return null;
        }
    }

    private static class JavaUIHelpListener
    implements HelpListener {
        private StructuredViewer fViewer;
        private String fContextId;
        private JavaEditor fEditor;

        public JavaUIHelpListener(StructuredViewer viewer, String contextId) {
            this.fViewer = viewer;
            this.fContextId = contextId;
        }

        public JavaUIHelpListener(JavaEditor editor, String contextId) {
            this.fContextId = contextId;
            this.fEditor = editor;
        }

        public void helpRequested(HelpEvent e) {
            try {
                ITypeRoot input;
                Object[] selected = null;
                if (this.fViewer != null) {
                    ISelection selection = this.fViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        selected = ((IStructuredSelection)selection).toArray();
                    }
                } else if (this.fEditor != null && (input = SelectionConverter.getInput(this.fEditor)) != null && ActionUtil.isOnBuildPath((IJavaElement)input)) {
                    selected = SelectionConverter.codeResolve(this.fEditor);
                }
                JavadocHelpContext.displayHelp(this.fContextId, selected);
            }
            catch (CoreException x) {
                JavaPlugin.log(x);
            }
        }
    }
}

