/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.RefreshAction;

public class SynchronizeAndRefreshAction
extends Action {
    private ISynchronizeView fView;

    public SynchronizeAndRefreshAction(ISynchronizeView view) {
        this.fView = view;
    }

    public void run() {
        ISynchronizeParticipant current = this.fView.getParticipant();
        if (current != null) {
            this.refreshLocal();
            current.run((IWorkbenchPart)this.fView);
        }
    }

    private void refreshLocal() {
        ISelectionProvider selectionProvider = this.fView.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        RefreshAction refreshAction = new RefreshAction((IShellProvider)this.fView.getSite());
        if (selection.isEmpty()) {
            refreshAction.refreshAll();
        } else {
            refreshAction.selectionChanged((IStructuredSelection)selection);
            refreshAction.run();
        }
    }
}

