/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.ActualTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameter;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboundTypeParameterAwareTypeArgumentCollector
extends ActualTypeArgumentCollector {
    public UnboundTypeParameterAwareTypeArgumentCollector(List<JvmTypeParameter> parametersToBeMapped, CommonTypeComputationServices services) {
        super(parametersToBeMapped, services);
    }

    @Override
    protected TypeParameterSubstitutor createTypeParameterSubstitutor(Map<JvmTypeParameter, JvmTypeReference> mapping) {
        return new UnboundTypeParameterPreservingSubstitutor(mapping, this.getServices());
    }

    @Override
    public Void doVisitComputedTypeReference(XComputedTypeReference reference, JvmTypeReference param) {
        if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
            UnboundTypeParameter unboundTypeParameter = (UnboundTypeParameter)reference.getTypeProvider();
            unboundTypeParameter.acceptHint(param);
            return null;
        }
        return (Void)super.doVisitComputedTypeReference(reference, param);
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser(this){

            public Void doVisitComputedTypeReference(XComputedTypeReference reference, JvmParameterizedTypeReference declaration) {
                if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
                    UnboundTypeParameter unboundTypeParameter = (UnboundTypeParameter)reference.getTypeProvider();
                    JvmType type = declaration.getType();
                    if (type instanceof JvmTypeParameter) {
                        if (type != unboundTypeParameter.getTypeParameter() && UnboundTypeParameterAwareTypeArgumentCollector.this.getParametersToProcess().contains(type)) {
                            JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                            UnboundTypeParameterAwareTypeArgumentCollector.this.processTypeParameter(typeParameter, (JvmTypeReference)reference);
                        }
                    } else {
                        unboundTypeParameter.acceptHint((JvmTypeReference)declaration);
                    }
                    return null;
                }
                return (Void)super.doVisitComputedTypeReference(reference, declaration);
            }
        };
    }

    @Override
    protected AbstractTypeReferencePairWalker.WildcardTypeReferenceTraverser createWildcardTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.WildcardTypeReferenceTraverser(this){

            public Void doVisitComputedTypeReference(XComputedTypeReference reference, JvmWildcardTypeReference param) {
                if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
                    return super.doVisitTypeReference((JvmTypeReference)reference, param);
                }
                return (Void)super.doVisitComputedTypeReference(reference, param);
            }
        };
    }

    @Override
    protected JvmTypeParameter findMappedParameter(JvmTypeParameter parameter, Map<JvmTypeParameter, JvmTypeReference> mapping, Collection<JvmTypeParameter> visited) {
        for (Map.Entry<JvmTypeParameter, JvmTypeReference> entry : mapping.entrySet()) {
            JvmTypeReference reference = entry.getValue();
            JvmType type = null;
            if (reference instanceof XComputedTypeReference) {
                IJvmTypeReferenceProvider typeProvider = ((XComputedTypeReference)reference).getTypeProvider();
                if (typeProvider instanceof UnboundTypeParameter) {
                    type = ((UnboundTypeParameter)typeProvider).getTypeParameter();
                }
            } else {
                type = reference.getType();
            }
            if (parameter != type) continue;
            if (visited.add(entry.getKey())) {
                return entry.getKey();
            }
            return null;
        }
        return null;
    }
}

