/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.impl;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.impl.EdgeImpl;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.impl.PhysicalRelationshipLabelImpl;

public class CommonBorderRelationshipLabelImpl
extends PhysicalRelationshipLabelImpl
implements CommonBorderRelationshipLabel {
    protected CommonBorderRelationshipLabelImpl() {
        this.setCurrentValue(LabelsFactory.eINSTANCE.createCommonBorderRelationshipLabelValue());
    }

    public static Edge createCommonBorderRelationship(Node nodeA, Node nodeB, double borderLength) {
        Edge retValue = EdgeImpl.createEdge((Node)nodeA, (Node)nodeB);
        CommonBorderRelationshipLabel label = LabelsFactory.eINSTANCE.createCommonBorderRelationshipLabel();
        label.setURIOfIdentifiableToBeLabeled(retValue.getURI());
        CommonBorderRelationshipLabelValue labelValue = (CommonBorderRelationshipLabelValue)label.getCurrentValue();
        labelValue.setBorderLength(borderLength);
        retValue.setLabel((EdgeLabel)label);
        return retValue;
    }

    public static void getCommonBorderEdgesFromNode(Node node, List<Edge> result) {
        if (node == null || node.getEdges() == null) {
            return;
        }
        EList cEdges = node.getEdges();
        int i = 0;
        while (i < cEdges.size()) {
            Edge edge = (Edge)cEdges.get(i);
            EdgeLabel edgeLabel = edge.getLabel();
            if (edgeLabel instanceof CommonBorderRelationshipLabel) {
                result.add(edge);
            }
            ++i;
        }
    }

    @Override
    protected EClass eStaticClass() {
        return LabelsPackage.Literals.COMMON_BORDER_RELATIONSHIP_LABEL;
    }
}

