/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.UserDataSetHints;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxesAdjuster;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.computation.withaxes.ValueAxesHelper;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.NullDataSet;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.NumberUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public final class PlotWith2DAxes
extends PlotWithAxes {
    private StackedSeriesLookup ssl = null;
    private int iMarginPercent = 0;
    private Bounds boPlotWithMargin = goFactory.createBounds(0.0, 0.0, 100.0, 100.0);

    public PlotWith2DAxes(IDisplayServer _ids, ChartWithAxes _cwa, RunTimeContext _rtc) throws IllegalArgumentException, ChartException {
        super(_ids, _rtc, _cwa);
        this.ssl = new StackedSeriesLookup(_rtc);
        this.buildAxes();
        this.initAlignZeroHelper();
    }

    final void buildAxes() throws IllegalArgumentException, ChartException {
        ChartWithAxes cwa = this.getModel();
        Axis[] axa = cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        this.validateAxis(axPrimaryBase);
        Axis axPrimaryOrthogonal = cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        this.validateAxis(axPrimaryOrthogonal);
        Axis[] axaOverlayOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, false);
        this.aax = new AllAxes(goFactory.scaleInsets(cwa.getPlot().getClientArea().getInsets(), this.dPointToPixel));
        this.insCA = this.aax.getInsets();
        boolean isTransposed = cwa.isTransposed();
        this.aax.swapAxes(isTransposed);
        OneAxis oaxPrimaryBase = new OneAxis(axPrimaryBase);
        oaxPrimaryBase.set(this.getOrientation(1), this.transposeLabelPosition(1, PlotWith2DAxes.getLabelPosition(axPrimaryBase.getLabelPosition())), this.transposeLabelPosition(1, PlotWith2DAxes.getLabelPosition(axPrimaryBase.getTitlePosition())), axPrimaryBase.isCategoryAxis(), axPrimaryBase.getScale().isTickBetweenCategories());
        oaxPrimaryBase.setGridProperties(axPrimaryBase.getMajorGrid().getLineAttributes(), axPrimaryBase.getMinorGrid().getLineAttributes(), axPrimaryBase.getMajorGrid().getTickAttributes(), axPrimaryBase.getMinorGrid().getTickAttributes(), this.transposeTickStyle(1, PlotWith2DAxes.getTickStyle(axPrimaryBase, 0)), this.transposeTickStyle(1, PlotWith2DAxes.getTickStyle(axPrimaryBase, 1)), axPrimaryBase.getScale().getMinorGridsPerUnit());
        oaxPrimaryBase.set(axPrimaryBase.getLabel(), axPrimaryBase.getTitle());
        oaxPrimaryBase.set(PlotWith2DAxes.getIntersection(axPrimaryBase));
        oaxPrimaryBase.set(axPrimaryBase.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryBase);
        OneAxis oaxPrimaryOrthogonal = new OneAxis(axPrimaryOrthogonal);
        oaxPrimaryOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axPrimaryOrthogonal.getLabelPosition() : axPrimaryOrthogonal.getLabelPosition())), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axPrimaryOrthogonal.getTitlePosition() : axPrimaryOrthogonal.getTitlePosition())), axPrimaryOrthogonal.isCategoryAxis(), axPrimaryOrthogonal.getScale().isTickBetweenCategories());
        oaxPrimaryOrthogonal.setGridProperties(axPrimaryOrthogonal.getMajorGrid().getLineAttributes(), axPrimaryOrthogonal.getMinorGrid().getLineAttributes(), axPrimaryOrthogonal.getMajorGrid().getTickAttributes(), axPrimaryOrthogonal.getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 0) : PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 0)), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 1) : PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 1)), axPrimaryOrthogonal.getScale().getMinorGridsPerUnit());
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLabel(), axPrimaryOrthogonal.getTitle());
        oaxPrimaryOrthogonal.set(PlotWith2DAxes.getIntersection(axPrimaryOrthogonal));
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryOrthogonal);
        this.aax.initOverlays(axaOverlayOrthogonal.length, this.getOrientation(2));
        int i = 0;
        while (i < axaOverlayOrthogonal.length) {
            this.validateAxis(axaOverlayOrthogonal[i]);
            OneAxis oaxOverlayOrthogonal = new OneAxis(axaOverlayOrthogonal[i]);
            oaxOverlayOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axaOverlayOrthogonal[i].getLabelPosition() : axaOverlayOrthogonal[i].getLabelPosition())), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? axaOverlayOrthogonal[i].getTitlePosition() : axaOverlayOrthogonal[i].getTitlePosition())), axaOverlayOrthogonal[i].isCategoryAxis(), axaOverlayOrthogonal[i].getScale().isTickBetweenCategories());
            oaxOverlayOrthogonal.setGridProperties(axaOverlayOrthogonal[i].getMajorGrid().getLineAttributes(), axaOverlayOrthogonal[i].getMinorGrid().getLineAttributes(), axaOverlayOrthogonal[i].getMajorGrid().getTickAttributes(), axaOverlayOrthogonal[i].getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 0) : PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 0)), this.transposeTickStyle(2, !isTransposed ? PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 1) : PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 1)), axaOverlayOrthogonal[i].getScale().getMinorGridsPerUnit());
            oaxOverlayOrthogonal.set(axaOverlayOrthogonal[i].getLabel(), axaOverlayOrthogonal[i].getTitle());
            oaxOverlayOrthogonal.set(axaOverlayOrthogonal[i].getLineAttributes());
            oaxOverlayOrthogonal.set(PlotWith2DAxes.getIntersection(axaOverlayOrthogonal[i]));
            this.aax.defineOverlay(i, oaxOverlayOrthogonal);
            ++i;
        }
        this.ssl = StackedSeriesLookup.create(cwa, this.rtc);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected final Object getMinMax(Axis ax, int iType) throws ChartException, IllegalArgumentException {
        if (ax.getType().getValue() == 0 && ax.isAligned() && this.azHelper != null && (minmax = this.azHelper.getCachedMinMax(ax)) != null) {
            return minmax;
        }
        cwa = this.getModel();
        sea = ax.getRuntimeSeries();
        iSeriesCount = sea.length;
        oMin /* !! */  = null;
        oMax /* !! */  = null;
        ps = PluginSettings.instance();
        iDSP = null;
        bAnyStacked = false;
        i = 0;
        while (i < iSeriesCount) {
            if (!sea[i].isStacked()) ** GOTO lbl18
            if (sea[i].canBeStacked()) {
                bAnyStacked = true;
            } else {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.unstackable.is.stacked"), new Object[]{sea[i]}));
lbl18:
                // 1 sources

                iDSP = ps.getDataSetProcessor(sea[i].getClass());
                ds = sea[i].getDataSet();
                if (ds instanceof NullDataSet && this.rtc.getSharedScale() != null) {
                    oMin /* !! */  = this.rtc.getSharedScale().getScaleContext().getMin();
                    oMax /* !! */  = this.rtc.getSharedScale().getScaleContext().getMax();
                } else {
                    oV1 = iDSP.getMinimum(ds);
                    oV2 = iDSP.getMaximum(ds);
                    if ((iType & 1) == 1) {
                        try {
                            if (oV1 != null) {
                                if (oMin /* !! */  == null) {
                                    oMin /* !! */  = oV1;
                                } else if (NumberUtil.isBigNumber(oV1)) {
                                    oMin /* !! */  = ((BigNumber)oMin /* !! */ ).min((BigNumber)oV1);
                                } else {
                                    dV1 = PlotWith2DAxes.asDouble(oV1);
                                    if (Math.min(PlotWith2DAxes.asDouble((Object)oMin /* !! */ ), dV1) == dV1) {
                                        oMin /* !! */  = oV1;
                                    }
                                }
                            }
                            if (oV2 == null) ** GOTO lbl70
                            if (oMax /* !! */  == null) {
                                oMax /* !! */  = oV2;
                            }
                            if (NumberUtil.isBigNumber(oV2)) {
                                oMax /* !! */  = ((BigNumber)oMax /* !! */ ).max((BigNumber)oV2);
                            }
                            dV2 = PlotWith2DAxes.asDouble(oV2);
                            if (Math.max(PlotWith2DAxes.asDouble((Object)oMax /* !! */ ), dV2) != dV2) ** GOTO lbl70
                            oMax /* !! */  = oV2;
                        }
                        catch (ClassCastException v0) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
                        }
                    } else if ((iType & 8) == 8) {
                        try {
                            if (oV1 != null) {
                                if (oMin /* !! */  == null) {
                                    oMin /* !! */  = oV1;
                                } else {
                                    cdtV1 = PlotWith2DAxes.asDateTime(oV1);
                                    if (cdtV1.before((Object)(cdtMin = PlotWith2DAxes.asDateTime((Object)oMin /* !! */ )))) {
                                        oMin /* !! */  = cdtV1;
                                    }
                                }
                            }
                            if (oV2 != null) {
                                if (oMax /* !! */  == null) {
                                    oMax /* !! */  = oV2;
                                } else {
                                    cdtV2 = PlotWith2DAxes.asDateTime(oV2);
                                    if (cdtV2.after((Object)(cdtMax = PlotWith2DAxes.asDateTime((Object)oMax /* !! */ )))) {
                                        oMax /* !! */  = cdtV2;
                                    }
                                }
                            }
                        }
                        catch (ClassCastException v1) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
                        }
                    }
                }
            }
lbl70:
            // 11 sources

            ++i;
        }
        isbignumber = false;
        bigDivisor = null;
        if (bAnyStacked || ax.isPercent()) {
            if (ax.getType().getValue() == 3) {
                throw new IllegalArgumentException(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.stacked.datetime.axis.series"));
            }
            dPercentMax = 0.0;
            dPercentMin = 0.0;
            dAxisMin = 1.7976931348623157E308;
            dAxisMax = -1.7976931348623157E308;
            alSeriesGroupsPerAxis = this.ssl.getStackGroups(ax);
            dsi = new DataSetIterator[this.ssl.getSeriesCount(ax)];
            if (alSeriesGroupsPerAxis == null) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.internal.stack.series.setup", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            PlotWith2DAxes.logger.log(1, Messages.getString("info.processing.stacked.info", new Object[]{ax}, this.rtc.getULocale()));
            iDataSetCount = this.ssl.getUnitCount();
            k = 0;
            while (k < iDataSetCount) {
                iSeriesIndex = 0;
                i = 0;
                while (i < alSeriesGroupsPerAxis.size()) {
                    sg = alSeriesGroupsPerAxis.get(i);
                    alSeriesPerGroup = sg.getSeries();
                    iSeriesPerGroup = alSeriesPerGroup.size();
                    if (iSeriesPerGroup > 0 && !((ds = (se = alSeriesPerGroup.get(0)).getDataSet()) instanceof NullDataSet)) {
                        if (dsi[iSeriesIndex] == null) {
                            dsi[iSeriesIndex] = new DataSetIterator(ds);
                            dsi[iSeriesIndex].reverse(cwa.isReverseCategory());
                            if ((dsi[iSeriesIndex].getDataType() & 1) != 1) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.percent.stacked.non.numerical", Messages.getResourceBundle(this.rtc.getULocale()));
                            }
                        }
                        iDataSetCount = dsi[iSeriesIndex].size();
                        au = this.ssl.getSubUnit(sg, k);
                        j = 0;
                        while (j < iSeriesPerGroup) {
                            se = alSeriesPerGroup.get(j);
                            if (j > 0 && dsi[iSeriesIndex] == null) {
                                ds = se.getDataSet();
                                dsi[iSeriesIndex] = new DataSetIterator(ds);
                                dsi[iSeriesIndex].reverse(cwa.isReverseCategory());
                                if ((dsi[iSeriesIndex].getDataType() & 1) != 1) {
                                    throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.percent.stacked.non.numerical", Messages.getResourceBundle(this.rtc.getULocale()));
                                }
                            }
                            if ((oValue = dsi[iSeriesIndex].next()) != null) {
                                dValue = ((Number)oValue).doubleValue();
                                au.computeTotal(dValue);
                                if (NumberUtil.isBigNumber(oValue) && !isbignumber) {
                                    isbignumber = true;
                                    bigDivisor = ((BigNumber)oValue).getDivisor();
                                }
                            }
                            ++iSeriesIndex;
                            ++j;
                        }
                        if (ax.isPercent()) {
                            dAbsTotal = au.getPositiveTotal() - au.getNegativeTotal();
                            if (dAbsTotal != 0.0) {
                                dPercentMax = Math.max(au.getTotalMax() / dAbsTotal * 100.0, dPercentMax);
                                dPercentMin = Math.min(au.getTotalMin() / dAbsTotal * 100.0, dPercentMin);
                            }
                        } else {
                            dAxisMax = Math.max(au.getTotalMax(), dAxisMax);
                            dAxisMin = Math.min(au.getTotalMin(), dAxisMin);
                        }
                    }
                    ++i;
                }
                ++k;
            }
            if (ax.isPercent()) {
                if (dPercentMax > 100.0) {
                    dPercentMax = 100.0;
                }
                if (dPercentMin < -100.0) {
                    dPercentMin = -100.0;
                }
                if (dPercentMax == 0.0 && dPercentMin == 0.0) {
                    dPercentMax = 100.0;
                }
                dAxisMin = dPercentMin;
                dAxisMax = dPercentMax;
            }
            if ((iType & 4) == 4) {
                dAxisMin = 1.0;
            }
            if (dAxisMin != 1.7976931348623157E308 && (oMin /* !! */  == null || Double.compare(dAxisMin, ((Number)oMin /* !! */ ).doubleValue()) < 0)) {
                oMin /* !! */  = isbignumber != false && ax.isPercent() == false ? new BigNumber(BigDecimal.valueOf((double)dAxisMin).multiply(bigDivisor, NumberUtil.DEFAULT_MATHCONTEXT), bigDivisor) : new Double(dAxisMin);
            }
            if (dAxisMax != -1.7976931348623157E308 && (oMax /* !! */  == null || Double.compare(dAxisMax, ((Number)oMax /* !! */ ).doubleValue()) > 0)) {
                oMax /* !! */  = isbignumber != false && ax.isPercent() == false ? new BigNumber(BigDecimal.valueOf((double)dAxisMax).multiply(bigDivisor, NumberUtil.DEFAULT_MATHCONTEXT), bigDivisor) : new Double(dAxisMax);
            }
        }
        if (oMin /* !! */  == null && oMax /* !! */  == null) {
            if (iType == 8) {
                year = Calendar.getInstance().get(1);
                oMin /* !! */  = new CDateTime(year, 1, 1);
                oMax /* !! */  = new CDateTime(year, 12, 31);
            } else if ((iType & 1) == 1) {
                if ((iType & 32) == 32) {
                    oMin /* !! */  = new Double(0.0);
                    oMax /* !! */  = new Double(100.0);
                } else if ((iType & 4) == 4) {
                    oMin /* !! */  = new Double(1.0);
                    oMax /* !! */  = new Double(1000.0);
                } else {
                    oMin /* !! */  = new Double(-1.0);
                    oMax /* !! */  = new Double(1.0);
                }
            }
        }
        if (iType == 8) {
            try {
                dtMin = PlotWith2DAxes.asDateTime(oMin /* !! */ );
                dtMax = PlotWith2DAxes.asDateTime(oMax /* !! */ );
                return new Calendar[]{dtMin, dtMax};
            }
            catch (ClassCastException v2) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        if ((iType & 1) == 1) {
            try {
                return this.adjustMinMax((Object)oMin /* !! */ , (Object)oMax /* !! */ );
            }
            catch (ClassCastException v3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        return null;
    }

    private Object adjustMinMax(Object oMin, Object oMax) {
        double dMax;
        if (NumberUtil.isBigNumber(oMin) || NumberUtil.isBigNumber(oMax)) {
            if (((BigNumber)oMin).compareTo(oMax) == 0) {
                if (((BigNumber)oMin).getValue().compareTo(BigDecimal.ZERO) > 0) {
                    oMin = new BigNumber(BigDecimal.ZERO, ((BigNumber)oMin).getDivisor());
                }
                if (((BigNumber)oMax).getValue().compareTo(BigDecimal.ZERO) < 0) {
                    oMax = new BigNumber(BigDecimal.ZERO, ((BigNumber)oMax).getDivisor());
                }
            }
            return new BigNumber[]{(BigNumber)oMin, (BigNumber)oMax};
        }
        double dMin = PlotWith2DAxes.asDouble(oMin);
        if (dMin == (dMax = PlotWith2DAxes.asDouble(oMax).doubleValue())) {
            if (dMin > 0.0) {
                dMin = 0.0;
            }
            if (dMax < 0.0) {
                dMax = 0.0;
            }
        }
        return new double[]{dMin, dMax};
    }

    private void computeWithStudyLayout() throws ChartException, IllegalArgumentException {
        ChartWithAxes cwa = this.getModel();
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        this.updatePrimaryBaseAxis(axPrimaryBase, this.boPlot);
        ValueAxesHelper valueAxesHelper = new ValueAxesHelper(this, this.aax, this.boPlot);
        this.updateValueAxes(valueAxesHelper, cwa);
        new AxesAdjuster(this, valueAxesHelper, this.boPlot).adjust();
        this.computePlotBackground(this.aax.getPrimaryBase(), valueAxesHelper.getValueAxes());
        this.boPlotWithMargin = this.boPlotBackground.copyInstance();
    }

    private void initInnerFields(Bounds bo, ChartWithAxes cwa) {
        this.boPlot = goFactory.scaleBounds(bo, this.dPointToPixel);
        this.dSeriesThickness = (double)this.ids.getDpiResolution() / 72.0 * cwa.getSeriesThickness();
        this.dSeriesThickness = cwa.getPlot().getClientArea().isVisible() ? this.dSeriesThickness : 0.0;
        this.boPlot.adjust(this.insCA);
        double dY = this.boPlot.getTop();
        double dW = this.boPlot.getWidth();
        double dH = this.boPlot.getHeight();
        this.iDimension = PlotWith2DAxes.getDimension(cwa.getDimension());
        this.dXAxisPlotSpacing = (double)cwa.getPlot().getHorizontalSpacing() * this.dPointToPixel;
        this.dYAxisPlotSpacing = (double)cwa.getPlot().getVerticalSpacing() * this.dPointToPixel;
        if (this.iDimension == 1) {
            dY += this.dSeriesThickness;
            dH -= this.dSeriesThickness;
            dW -= this.dSeriesThickness;
        }
        this.boPlot.setTop(dY);
        this.boPlot.setHeight(Math.max(dH, 0.0));
        this.boPlot.setWidth(Math.max(dW, 0.0));
    }

    private void updateValueAxes(ValueAxesHelper valueAxesHelper, ChartWithAxes cwa) throws ChartException {
        OneAxis[] allYAxes = valueAxesHelper.getValueAxes();
        int i = 0;
        OneAxis[] oneAxisArray = allYAxes;
        int n = allYAxes.length;
        int n2 = 0;
        while (n2 < n) {
            OneAxis axis = oneAxisArray[n2];
            this.updateValueAxis(axis, valueAxesHelper.getStart(i), valueAxesHelper.getEnd(i), cwa.isReverseCategory());
            ++i;
            ++n2;
        }
    }

    public final void compute(Bounds bo) throws ChartException, IllegalArgumentException {
        ChartWithAxes cwa = this.getModel();
        this.initInnerFields(bo, cwa);
        if (this.boPlot.getWidth() < 0.0 || this.boPlot.getHeight() < 0.0) {
            return;
        }
        if (ChartUtil.isStudyLayout(this.getModel())) {
            this.computeWithStudyLayout();
        } else {
            this.computeCommon();
        }
    }

    private void updatePrimaryBaseAxis(Axis axPrimaryBase, Bounds boPlot) throws ChartException {
        double dX = boPlot.getLeft();
        double dY = boPlot.getTop();
        double dW = boPlot.getWidth();
        double dH = boPlot.getHeight();
        OneAxis oaxPrimaryBase = this.aax.getPrimaryBase();
        int iAxisType = PlotWith2DAxes.getAxisType(axPrimaryBase);
        Object oaData = null;
        if (iAxisType == 16 || oaxPrimaryBase.isCategoryScale()) {
            oaData = this.getTypedDataSet(axPrimaryBase, iAxisType, 0);
        } else if ((iAxisType & 1) == 1) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        } else if ((iAxisType & 8) == 8) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        }
        DataSetIterator dsi = oaData instanceof DataSetIterator ? oaData : new DataSetIterator(oaData, iAxisType);
        double dStart = this.aax.areAxesSwapped() ? dY + dH : dX;
        double dEnd = this.aax.areAxesSwapped() ? dY : dStart + dW;
        this.updateAxisScale(oaxPrimaryBase, iAxisType, dsi, dStart, dEnd);
    }

    private void computeCommon() throws ChartException, IllegalArgumentException {
        ChartWithAxes cwa = this.getModel();
        double dX = this.boPlot.getLeft();
        double dY = this.boPlot.getTop();
        double dW = this.boPlot.getWidth();
        double dH = this.boPlot.getHeight();
        if (this.aax.getOverlayCount() > 0) {
            if (this.aax.areAxesSwapped()) {
                this.updateOverlayScales(this.aax, dX, dX + dW, dY, dH);
                dY = this.aax.getStart();
                dH = this.aax.getLength();
            } else {
                this.updateOverlayScales(this.aax, dY - dH, dY, dX, dW);
                dX = this.aax.getStart();
                dW = this.aax.getLength();
            }
        }
        Axis[] axa = cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis axPrimaryOrthogonal = cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        AutoScale scPrimaryBase = null;
        OneAxis oaxPrimaryBase = this.aax.getPrimaryBase();
        int iAxisType = PlotWith2DAxes.getAxisType(axPrimaryBase);
        Object oaData = null;
        if (iAxisType == 16 || oaxPrimaryBase.isCategoryScale()) {
            oaData = this.getTypedDataSet(axPrimaryBase, iAxisType, 0);
        } else if ((iAxisType & 1) == 1) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        } else if ((iAxisType & 8) == 8) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        }
        DataSetIterator dsi = oaData instanceof DataSetIterator ? oaData : new DataSetIterator(oaData, iAxisType);
        oaData = null;
        double dStart = this.aax.areAxesSwapped() ? dY + dH : dX;
        double dEnd = this.aax.areAxesSwapped() ? dY : dStart + dW;
        int iDirection = 0;
        scPrimaryBase = AutoScale.computeScale(this.ids, oaxPrimaryBase, dsi, iAxisType, dStart, dEnd, this.rtc, iDirection, 1.0, this.iMarginPercent, this);
        oaxPrimaryBase.set(scPrimaryBase);
        AutoScale scPrimaryOrthogonal = null;
        OneAxis oaxPrimaryOrthogonal = this.aax.getPrimaryOrthogonal();
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
        oaData = null;
        if ((iAxisType & 1) != 1 && (iAxisType & 8) != 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.orthogonal.axis.numerical.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        Object minMax = this.getMinMax(axPrimaryOrthogonal, iAxisType);
        dsi = this.rtc.getSharedScale() != null ? this.getSharedScaleMinMax(iAxisType, minMax) : new DataSetIterator(minMax, iAxisType);
        dsi.reverse(cwa.isReverseCategory());
        dStart = this.aax.areAxesSwapped() ? dX : dY + dH;
        dEnd = this.aax.areAxesSwapped() ? dX + dW : dY;
        scPrimaryOrthogonal = AutoScale.computeScale(this.ids, oaxPrimaryOrthogonal, dsi, iAxisType, dStart, dEnd, oaxPrimaryBase.getModelAxis().getOrigin(), this.rtc, 0, 1.0, this.iMarginPercent, this);
        oaxPrimaryOrthogonal.set(scPrimaryOrthogonal);
        double dYAxisLocation = this.adjustHorizontal(dX, dW, this.aax, this.aax.getPrimaryOrthogonal());
        double dXAxisLocation = this.adjustVerticalDueToHorizontal(dY, dH, this.aax, this.aax.getPrimaryOrthogonal());
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
        oaData = this.getTypedDataSet(axPrimaryOrthogonal, iAxisType, 0);
        scPrimaryOrthogonal.setData(dsi);
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryBase);
        if (iAxisType != 16) {
            scPrimaryBase.setData(this.getTypedDataSet(axPrimaryBase, iAxisType, 0));
        }
        scPrimaryBase.resetShifts();
        scPrimaryOrthogonal.resetShifts();
        this.updateOverlayAxes(this.aax);
        this.growBaseAxis(this.aax, goFactory.createBounds(dX, dY, dW, dH));
        this.adjustOverlayAxesDueToEndShifts();
        OneAxis axPH = this.aax.areAxesSwapped() ? this.aax.getPrimaryOrthogonal() : this.aax.getPrimaryBase();
        OneAxis axPV = this.aax.areAxesSwapped() ? this.aax.getPrimaryBase() : this.aax.getPrimaryOrthogonal();
        axPH.setAxisCoordinate(dXAxisLocation);
        axPV.setAxisCoordinate(dYAxisLocation);
        this.computePlotBackground(this.aax.getPrimaryBase(), new OneAxis[]{this.aax.getPrimaryOrthogonal()});
        this.computePlotWithMargin(axPH, axPV);
    }

    private void adjustOverlayAxesDueToEndShifts() {
        if (this.aax != null && this.aax.getOverlayCount() > 0 && !this.aax.getPrimaryBase().isCategoryScale()) {
            int iCount = this.aax.getOverlayCount();
            AutoScale scBase = this.aax.getPrimaryBase().getScale();
            int i = 0;
            while (i < iCount) {
                OneAxis oax = this.aax.getOverlay(i);
                if (oax.getIntersectionValue() == IntersectionValue.MAX_VALUE) {
                    oax.setAxisCoordinate(oax.getAxisCoordinate() - scBase.getEndShift());
                }
                ++i;
            }
        }
    }

    private void computePlotWithMargin(OneAxis axPH, OneAxis axPV) {
        double[] daX = axPH.getScale().getEndPoints();
        this.boPlotWithMargin = goFactory.copyOf(this.boPlotBackground);
        if (this.iMarginPercent > 0) {
            double factor;
            AutoScale scale = axPH.getScale();
            if ((scale.getMaxWithMargin() != null || scale.getMinWithMargin() != null) && (scale.getType() & 2) == 2) {
                factor = Math.abs(daX[1] - daX[0]) / (PlotWith2DAxes.asDouble(scale.getMaximum()) - PlotWith2DAxes.asDouble(scale.getMinimum()));
                if (scale.getMinWithMargin() != null) {
                    this.boPlotWithMargin.setLeft(this.boPlotWithMargin.getLeft() - factor * (PlotWith2DAxes.asDouble(scale.getMinimum()) - PlotWith2DAxes.asDouble(scale.getMinWithMargin())));
                }
                this.boPlotWithMargin.setWidth(factor * (PlotWith2DAxes.asDouble(scale.getMaxWithMargin() == null ? scale.getMaximum() : scale.getMaxWithMargin()) - PlotWith2DAxes.asDouble(scale.getMinWithMargin() == null ? scale.getMinimum() : scale.getMinWithMargin())) + this.insCA.getLeft() + this.insCA.getRight() + 1.0);
            }
            if (((scale = axPV.getScale()).getMaxWithMargin() != null || scale.getMinWithMargin() != null) && (scale.getType() & 2) == 2) {
                factor = Math.abs(daX[1] - daX[0]) / (PlotWith2DAxes.asDouble(scale.getMaximum()) - PlotWith2DAxes.asDouble(scale.getMinimum()));
                if (scale.getMaxWithMargin() != null) {
                    this.boPlotWithMargin.setTop(this.boPlotWithMargin.getTop() - factor * (PlotWith2DAxes.asDouble(scale.getMaxWithMargin()) - PlotWith2DAxes.asDouble(scale.getMaximum())));
                }
                this.boPlotWithMargin.setHeight(factor * (PlotWith2DAxes.asDouble(scale.getMaxWithMargin() == null ? scale.getMaximum() : scale.getMaxWithMargin()) - PlotWith2DAxes.asDouble(scale.getMinWithMargin() == null ? scale.getMinimum() : scale.getMinWithMargin())) + this.insCA.getTop() + this.insCA.getBottom() + 1.0);
            }
        }
    }

    private void computePlotBackground(OneAxis axPrimaryBase, OneAxis[] axOrthogonals) {
        double height;
        double top;
        double width;
        double left;
        if (!this.aax.areAxesSwapped()) {
            int size = axOrthogonals.length;
            double yAxesLength = size > 1 ? axOrthogonals[0].getScale().getEndPoints()[0] - axOrthogonals[size - 1].getScale().getEndPoints()[1] : axOrthogonals[0].getScale().getEndPoints()[0] - axOrthogonals[0].getScale().getEndPoints()[1];
            double[] point = axPrimaryBase.getScale().getEndPoints();
            if (axPrimaryBase.getScale().getDirection() != -1) {
                left = point[0] - this.insCA.getLeft();
                width = point[1] - point[0] + this.insCA.getLeft() + this.insCA.getRight() + 1.0;
            } else {
                left = point[1] - this.insCA.getLeft();
                width = point[0] - point[1] + this.insCA.getLeft() + this.insCA.getRight() + 1.0;
            }
            if (axOrthogonals[0].getScale().getDirection() == 1) {
                top = axOrthogonals[axOrthogonals.length - 1].getScale().getEndPoints()[0] - this.insCA.getTop();
                height = -yAxesLength + this.insCA.getTop() + this.insCA.getBottom() + 1.0;
            } else {
                top = axOrthogonals[axOrthogonals.length - 1].getScale().getEndPoints()[1] - this.insCA.getTop();
                height = yAxesLength + this.insCA.getTop() + this.insCA.getBottom() + 1.0;
            }
        } else {
            int size = axOrthogonals.length;
            double yAxesLength = size > 1 ? axOrthogonals[size - 1].getScale().getEndPoints()[1] - axOrthogonals[0].getScale().getEndPoints()[0] : axOrthogonals[0].getScale().getEndPoints()[1] - axOrthogonals[0].getScale().getEndPoints()[0];
            if (axOrthogonals[0].getScale().getDirection() != -1) {
                left = axOrthogonals[0].getScale().getEndPoints()[0] - this.insCA.getLeft();
                width = yAxesLength + this.insCA.getLeft() + this.insCA.getRight() + 1.0;
            } else {
                left = axOrthogonals[axOrthogonals.length - 1].getScale().getEndPoints()[0] - this.insCA.getLeft();
                width = -yAxesLength + this.insCA.getLeft() + this.insCA.getRight() + 1.0;
            }
            if (axPrimaryBase.getScale().getDirection() == 1) {
                top = axPrimaryBase.getScale().getEndPoints()[0] - this.insCA.getTop();
                height = axPrimaryBase.getScale().getEndPoints()[1] - axPrimaryBase.getScale().getEndPoints()[0] + this.insCA.getTop() + this.insCA.getBottom() + 1.0;
            } else {
                top = axPrimaryBase.getScale().getEndPoints()[1] - this.insCA.getTop();
                height = axPrimaryBase.getScale().getEndPoints()[0] - axPrimaryBase.getScale().getEndPoints()[1] + this.insCA.getTop() + this.insCA.getBottom() + 1.0;
            }
        }
        this.boPlotBackground.setLeft(left);
        this.boPlotBackground.setTop(top);
        this.boPlotBackground.setWidth(width);
        this.boPlotBackground.setHeight(height);
        if (this.iDimension == 1) {
            this.boPlotBackground.delta(this.dSeriesThickness, -this.dSeriesThickness, 0.0, 0.0);
        }
    }

    public final Bounds getPlotBoundsWithMargin() {
        return this.boPlotWithMargin;
    }

    private final void growBaseAxis(AllAxes aax, Bounds bo) throws ChartException {
        OneAxis oaxBase = aax.getPrimaryBase();
        OneAxis oaxOrthogonal = aax.getPrimaryOrthogonal();
        AutoScale scBase = oaxBase.getScale();
        if (aax.getOverlayCount() <= 0) {
            return;
        }
        if (!aax.areAxesSwapped()) {
            if (oaxOrthogonal.getIntersectionValue().getType() != 1) {
                if (aax.anyOverlayPositionedAt(1)) {
                    scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 0, oaxBase.getLabelPosition(), aax);
                    double dRightThreshold = bo.getLeft() + bo.getWidth();
                    double dEnd = scBase.getEnd();
                    double dEndShift = scBase.getEndShift();
                    if (dEnd + dEndShift < dRightThreshold) {
                        scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, scBase.getStart(), dEnd += dEndShift, false, null);
                    }
                }
            } else if (oaxOrthogonal.getIntersectionValue().getType() != 2 && aax.anyOverlayPositionedAt(2)) {
                scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 0, oaxBase.getLabelPosition(), aax);
                double dLeftThreshold = bo.getLeft();
                double dStart = scBase.getStart();
                double dEndShift = scBase.getEndShift();
                double dStartShift = scBase.getStartShift();
                if (dStart - dStartShift > dLeftThreshold) {
                    double dEnd = scBase.getEnd() + dEndShift;
                    scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, dStart -= dStartShift, dEnd, false, null);
                }
            }
        } else if (oaxOrthogonal.getIntersectionValue().getType() != 1) {
            if (aax.anyOverlayPositionedAt(1)) {
                scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 1, oaxBase.getLabelPosition(), aax);
                double dTopThreshold = bo.getTop();
                double dEnd = scBase.getEnd();
                double dEndShift = Math.floor(scBase.getEndShift());
                if (dEnd - dEndShift > dTopThreshold) {
                    double dStart = scBase.getStart();
                    scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart, dEnd -= dEndShift, false, null);
                }
            }
        } else if (oaxOrthogonal.getIntersectionValue().getType() != 2 && aax.anyOverlayPositionedAt(2)) {
            scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 1, oaxBase.getLabelPosition(), aax);
            double dBottomThreshold = bo.getTop() + bo.getHeight();
            double dStart = scBase.getStart();
            double dStartShift = scBase.getStartShift();
            if (dStart + dStartShift < dBottomThreshold) {
                double dEnd = scBase.getEnd();
                scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart += dStartShift, dEnd, false, null);
            }
        }
    }

    private final void updateOverlayScales(AllAxes aax, double dAxisStart, double dAxisEnd, double dBlockStart, double dBlockLength) throws ChartException, IllegalArgumentException {
        Axis[] axa = ((ChartWithAxesImpl)this.getModel()).getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis[] axaOrthogonal = ((ChartWithAxesImpl)this.getModel()).getOrthogonalAxes(axPrimaryBase, false);
        AutoScale sc = null;
        OneAxis oaxOverlay = null;
        int iOverlayCount = aax.getOverlayCount();
        int iOrientation = aax.getOrientation();
        Series[] sea = this.getModel().getSeries(2);
        Map<Series, LegendItemRenderingHints> seriesRenderingHints = this.rtc.getSeriesRenderers();
        int i = 0;
        while (i < iOverlayCount) {
            double dDelta;
            double dWTotal;
            double maxWidth;
            double maxHeight;
            int j = iOverlayCount - i - 1;
            oaxOverlay = aax.getOverlay(j);
            int iTickStyle = oaxOverlay.getCombinedTickStyle();
            int iTitleLocation = oaxOverlay.getTitlePosition();
            Label laAxisTitle = oaxOverlay.getTitle();
            int iAxisType = PlotWith2DAxes.getAxisType(axaOrthogonal[j]);
            sc = AutoScale.computeScale(this.ids, oaxOverlay, new DataSetIterator(this.getMinMax(axaOrthogonal[j], iAxisType), iAxisType), iAxisType, dAxisStart, dAxisEnd, this.rtc, 0, 1.0, this.iMarginPercent, this);
            oaxOverlay.set(sc);
            IntersectionValue iv = oaxOverlay.getIntersectionValue();
            double dStart = sc.getStart();
            double dEnd = sc.getEnd();
            sc.computeTicks(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition(), iOrientation, dStart, dEnd, true, null);
            if (!sc.isStepFixed()) {
                Object[] oaMinMax = sc.getMinMax();
                while (!sc.checkFit(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition())) {
                    if (!sc.zoomOut()) break;
                    sc.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    sc.computeTicks(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition(), iOrientation, dStart, dEnd, true, null);
                }
            }
            double dAxisLabelsThickness = sc.computeAxisLabelThickness(this.ids, oaxOverlay.getLabel(), iOrientation);
            double[] dDecorationThickness = new double[]{0.0, 0.0};
            int t = 0;
            while (t < sea.length) {
                IAxesDecorator iad;
                LegendItemRenderingHints lirh = seriesRenderingHints.get(sea[t]);
                if (lirh != null && lirh.getRenderer() instanceof AxesRenderer && (iad = ((AxesRenderer)lirh.getRenderer()).getAxesDecorator(oaxOverlay)) != null) {
                    double[] thickness = iad.computeDecorationThickness(this.ids, oaxOverlay);
                    if (thickness[0] > dDecorationThickness[0]) {
                        dDecorationThickness[0] = thickness[0];
                    }
                    if (thickness[1] > dDecorationThickness[1]) {
                        dDecorationThickness[1] = thickness[1];
                    }
                }
                ++t;
            }
            double dAxisTitleThickness = 0.0;
            sc.resetShifts();
            if (iOrientation == 1) {
                double dFixedLabelThickness;
                double dX = 0.0;
                double dX1 = 0.0;
                double dX2 = 0.0;
                boolean bTicksLeft = (iTickStyle & 1) == 1;
                boolean bTicksRight = (iTickStyle & 2) == 2;
                double dAppliedYAxisPlotSpacing = this.dYAxisPlotSpacing;
                if (laAxisTitle.isVisible()) {
                    String sPreviousValue = laAxisTitle.getCaption().getValue();
                    laAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
                    maxHeight = this.boPlot.getHeight();
                    maxWidth = this.boPlot.getWidth() * 0.3;
                    LabelLimiter lbLimit = new LabelLimiter(maxWidth, maxHeight, 0.0);
                    lbLimit.computeWrapping(this.ids, laAxisTitle);
                    lbLimit = lbLimit.limitLabelSize(this.cComp, this.ids, laAxisTitle, EnumSet.of(LabelLimiter.Option.FIX_HEIGHT));
                    dAxisTitleThickness = lbLimit.getMaxWidth();
                    this.putLabelLimiter(oaxOverlay.getModelAxis().getTitle(), lbLimit);
                    laAxisTitle.getCaption().setValue(sPreviousValue);
                }
                if (oaxOverlay.getModelAxis().isSetLabelSpan() && (dFixedLabelThickness = oaxOverlay.getModelAxis().getLabelSpan() * this.dPointToPixel) < (dWTotal = dBlockLength) - 2.0 * this.getTickSize()) {
                    if (dAxisLabelsThickness + dAxisTitleThickness > dFixedLabelThickness) {
                        oaxOverlay.setShowLabels(false);
                    }
                    if (dAxisTitleThickness > dFixedLabelThickness) {
                        laAxisTitle.setVisible(false);
                        dAxisTitleThickness = 0.0;
                    }
                    dAxisLabelsThickness = dFixedLabelThickness;
                }
                if (iv.getType() == 2) {
                    dX = dBlockStart;
                    dX1 = dX -= dAppliedYAxisPlotSpacing;
                    dX2 = dX;
                    if (bTicksLeft) {
                        dX1 -= this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 1) {
                        dX1 -= Math.max(dAxisLabelsThickness, dDecorationThickness[0]);
                        dX2 += Math.max(bTicksRight ? this.getTickSize() : 0.0, dAppliedYAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 2) {
                        dX1 -= dDecorationThickness[0];
                        dX2 += Math.max((bTicksRight ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedYAxisPlotSpacing);
                    }
                    if (iTitleLocation == 1) {
                        dX1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 2) {
                        dX2 += dAxisTitleThickness;
                    }
                    if (dX1 < dBlockStart) {
                        double dDelta2 = dBlockStart - dX1;
                        dX1 = dBlockStart;
                        dX += dDelta2;
                        dX2 += dDelta2;
                    }
                    dBlockStart += dX2 - dX1;
                } else if (iv.getType() == 1) {
                    dX = dBlockStart + dBlockLength;
                    dX1 = dX += dAppliedYAxisPlotSpacing;
                    dX2 = dX;
                    if (bTicksRight) {
                        dX2 += this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 2) {
                        dX2 += Math.max(dAxisLabelsThickness, dDecorationThickness[1]);
                        dX1 -= Math.max(bTicksLeft ? this.getTickSize() : 0.0, dAppliedYAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 1) {
                        dX1 -= Math.max((bTicksLeft ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedYAxisPlotSpacing);
                        dX2 += dDecorationThickness[1];
                    }
                    if (iTitleLocation == 1) {
                        dX1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 2) {
                        dX2 += dAxisTitleThickness;
                    }
                    if (dX2 > dBlockStart + dBlockLength) {
                        double dDelta3 = dX2 - (dBlockStart + dBlockLength);
                        dX2 = dBlockStart + dBlockLength;
                        dX -= dDelta3;
                        dX1 -= dDelta3;
                    }
                } else {
                    if (oaxOverlay.getLabelPosition() == 2) {
                        dX2 += Math.max(dAxisLabelsThickness, dDecorationThickness[1]);
                        dX1 -= Math.max(bTicksLeft ? this.getTickSize() : 0.0, dAppliedYAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 1) {
                        dX1 -= Math.max((bTicksLeft ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedYAxisPlotSpacing);
                        dX2 += dDecorationThickness[1];
                    }
                    if (iTitleLocation == 1) {
                        dX1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 2) {
                        dX2 += dAxisTitleThickness;
                    }
                }
                dBlockLength -= dX2 - dX1;
                dDelta = 0.0;
                if (iv.getType() == 2) {
                    dDelta = -this.insCA.getLeft();
                } else if (iv.getType() == 1) {
                    dDelta = this.insCA.getRight();
                }
                oaxOverlay.setAxisCoordinate(dX + dDelta);
                oaxOverlay.setTitleCoordinate(iTitleLocation == 1 ? dX1 + dDelta - 1.0 : dX2 + 1.0 - dAxisTitleThickness + dDelta);
            } else if (iOrientation == 0) {
                double dFixedLabelThickness;
                double dY;
                double dY1 = dY = 0.0;
                double dY2 = dY;
                boolean bTicksAbove = (iTickStyle & 1) == 1;
                boolean bTicksBelow = (iTickStyle & 2) == 2;
                double dAppliedXAxisPlotSpacing = this.dXAxisPlotSpacing;
                if (laAxisTitle.isVisible()) {
                    String sPreviousValue = laAxisTitle.getCaption().getValue();
                    laAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
                    maxHeight = this.boPlot.getHeight() * 0.3;
                    maxWidth = this.boPlot.getWidth();
                    Label laAxisTitleV = aax.getPrimaryOrthogonal().getTitle();
                    if (laAxisTitleV.isVisible()) {
                        laAxisTitleV = goFactory.copyOf(laAxisTitleV);
                        laAxisTitleV.getCaption().setValue(this.rtc.externalizedMessage(laAxisTitleV.getCaption().getValue()));
                        LabelLimiter lbLimitV = new LabelLimiter(this.boPlot.getWidth() * 0.3, this.boPlot.getWidth(), 0.0);
                        lbLimitV.computeWrapping(this.ids, laAxisTitleV);
                        lbLimitV.limitLabelSize(this.cComp, this.ids, laAxisTitleV);
                        maxWidth -= lbLimitV.getMaxWidth();
                    }
                    LabelLimiter lbLimit = new LabelLimiter(maxWidth, maxHeight, 0.0);
                    lbLimit.computeWrapping(this.ids, laAxisTitle);
                    lbLimit = lbLimit.limitLabelSize(this.cComp, this.ids, laAxisTitle, EnumSet.of(LabelLimiter.Option.FIX_WIDTH));
                    dAxisTitleThickness = lbLimit.getMaxHeight();
                    this.putLabelLimiter(oaxOverlay.getModelAxis().getTitle(), lbLimit);
                    laAxisTitle.getCaption().setValue(sPreviousValue);
                }
                if (oaxOverlay.getModelAxis().isSetLabelSpan() && (dFixedLabelThickness = oaxOverlay.getModelAxis().getLabelSpan() * this.dPointToPixel) < (dWTotal = dBlockLength) - 2.0 * this.getTickSize()) {
                    if (dAxisLabelsThickness + dAxisTitleThickness > dFixedLabelThickness) {
                        oaxOverlay.setShowLabels(false);
                    }
                    if (dAxisTitleThickness > dFixedLabelThickness) {
                        laAxisTitle.setVisible(false);
                        dAxisTitleThickness = 0.0;
                    }
                    dAxisLabelsThickness = dFixedLabelThickness;
                }
                if (iv.getType() == 1) {
                    dY = dBlockStart;
                    dY1 = dY -= dAppliedXAxisPlotSpacing;
                    dY2 = dY;
                    if (bTicksAbove) {
                        dY1 -= this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 4) {
                        dY1 -= Math.max(dAxisLabelsThickness, dDecorationThickness[0]);
                        dY2 += Math.max(bTicksBelow ? this.getTickSize() : 0.0, dAppliedXAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 8) {
                        dY1 -= dDecorationThickness[0];
                        dY2 += Math.max((bTicksBelow ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedXAxisPlotSpacing);
                    }
                    if (iTitleLocation == 4) {
                        dY1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 8) {
                        dY2 += dAxisTitleThickness;
                    }
                    if (dY1 < dBlockStart) {
                        double dDelta4 = dBlockStart - dY1;
                        dY1 = dBlockStart;
                        dY += dDelta4;
                        dY2 += dDelta4;
                    }
                    dBlockStart += dY2 - dY1;
                } else if (iv.getType() == 2) {
                    dY = dBlockStart + dBlockLength;
                    dY1 = dY += dAppliedXAxisPlotSpacing;
                    dY2 = dY;
                    if (bTicksBelow) {
                        dY2 += this.getTickSize();
                    }
                    if (oaxOverlay.getLabelPosition() == 8) {
                        dY2 += Math.max(dAxisLabelsThickness, dDecorationThickness[1]);
                        dY1 -= Math.max(bTicksAbove ? this.getTickSize() : 0.0, dAppliedXAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 4) {
                        dY1 -= Math.max((bTicksAbove ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedXAxisPlotSpacing);
                        dY2 += dDecorationThickness[1];
                    }
                    if (iTitleLocation == 4) {
                        dY1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 8) {
                        dY2 += dAxisTitleThickness;
                    }
                    if (dY2 > dBlockStart + dBlockLength) {
                        double dDelta5 = dY2 - (dBlockStart + dBlockLength);
                        dY2 = dBlockStart + dBlockLength;
                        dY -= dDelta5;
                        dY1 -= dDelta5;
                    }
                } else {
                    if (oaxOverlay.getLabelPosition() == 8) {
                        dY2 += Math.max(dAxisLabelsThickness, dDecorationThickness[1]);
                        dY1 -= Math.max(bTicksAbove ? this.getTickSize() : 0.0, dAppliedXAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 4) {
                        dY1 -= Math.max((bTicksAbove ? this.getTickSize() : 0.0) + dAxisLabelsThickness, dAppliedXAxisPlotSpacing);
                        dY2 += dDecorationThickness[1];
                    }
                    if (iTitleLocation == 4) {
                        dY1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 8) {
                        dY2 += dAxisTitleThickness;
                    }
                }
                dDelta = 0.0;
                if (iv.getType() == 1) {
                    dDelta = -this.insCA.getTop();
                } else if (iv.getType() == 2) {
                    dDelta = this.insCA.getBottom();
                }
                oaxOverlay.setAxisCoordinate(dY + dDelta);
                oaxOverlay.setTitleCoordinate(iTitleLocation == 4 ? dY1 + dDelta - 1.0 : dY2 + 1.0 - dAxisTitleThickness + dDelta);
                dBlockLength -= dY2 - dY1;
            }
            ++i;
        }
        aax.setBlockCordinates(dBlockStart, dBlockLength);
    }

    private final void updateOverlayAxes(AllAxes aax) throws ChartException, IllegalArgumentException {
        int iDirection = aax.getOrientation() == 0 ? 1 : -1;
        Axis[] axa = this.getModel().getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis[] axaOverlayOrthogonal = this.getModel().getOrthogonalAxes(axPrimaryBase, false);
        OneAxis axPrimary = aax.getPrimaryOrthogonal();
        AutoScale sc = axPrimary.getScale();
        int i = 0;
        while (i < aax.getOverlayCount()) {
            OneAxis axOverlay = aax.getOverlay(i);
            int iAxisType = axOverlay.getScale().getType();
            Label la = axOverlay.getLabel();
            AutoScale scOA = axOverlay.getScale();
            scOA.setEndPoints(scOA.getStart() - scOA.getStartShift() * (double)iDirection, scOA.getEnd() + scOA.getEndShift() * (double)iDirection);
            double dStart = sc.getStart();
            double dEnd = sc.getEnd();
            scOA.setEndPoints(dStart, dEnd);
            scOA.computeTicks(this.ids, la, axOverlay.getLabelPosition(), aax.getOrientation(), dStart, dEnd, false, null);
            if (!scOA.isStepFixed()) {
                Object[] oaMinMax = scOA.getMinMax();
                while (!scOA.checkFit(this.ids, la, axOverlay.getLabelPosition())) {
                    if (!scOA.zoomOut()) break;
                    scOA.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    scOA.computeTicks(this.ids, la, axOverlay.getLabelPosition(), aax.getOrientation(), dStart, dEnd, false, null);
                }
            }
            scOA.setData(this.getTypedDataSet(axaOverlayOrthogonal[i], iAxisType, 0));
            ++i;
        }
    }

    public final ISeriesRenderingHints getSeriesRenderingHints(SeriesDefinition sdOrthogonal, Series seOrthogonal) throws ChartException, IllegalArgumentException {
        if (seOrthogonal == null || seOrthogonal.getClass() == SeriesImpl.class) {
            return null;
        }
        OneAxis oaxOrthogonal = this.findOrthogonalAxis(seOrthogonal);
        if (oaxOrthogonal == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 6, "exception.axis.series.link.broken", new Object[]{seOrthogonal}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        OneAxis oaxBase = this.aax.getPrimaryBase();
        SeriesDefinition sdBase = (SeriesDefinition)oaxBase.getModelAxis().getSeriesDefinitions().get(0);
        AutoScale scBase = oaxBase.getScale();
        AutoScale scOrthogonal = oaxOrthogonal.getScale();
        int iTickCount = scBase.getTickCount();
        int iDirection = scBase.getDirection();
        double dUnitSize = iDirection == -1 || iDirection == 0 && this.aax.areAxesSwapped() ? -scBase.getUnitSize() : scBase.getUnitSize();
        scBase.getType();
        AxisTickCoordinates daTickCoordinates = scBase.getTickCordinates();
        Object oDataBase = null;
        DataSetIterator dsiDataBase = scBase.getData();
        DataSetIterator dsiDataOrthogonal = this.getTypedDataSet(seOrthogonal, oaxOrthogonal.getScale().getType());
        double dOrthogonalZero = 0.0;
        dOrthogonalZero = (scOrthogonal.getType() & 1) == 1 ? PlotWith2DAxes.getLocation(scOrthogonal, 0.0) : scOrthogonal.getStart();
        double dBaseZero = 0.0;
        dBaseZero = (scBase.getType() & 1) == 1 && !oaxBase.isCategoryScale() ? PlotWith2DAxes.getLocation(scBase, 0.0) : (oaxBase.isTickBwtweenCategories() ? scBase.getStart() : scBase.getStart() + scBase.getStartShift());
        if (scBase.getType() != 16 && !oaxBase.isCategoryScale() || oaxBase.isTickBwtweenCategories()) {
            // empty if block
        }
        double dX = 0.0;
        double dY = 0.0;
        int iBaseCount = dsiDataBase.size();
        int iOrthogonalCount = dsiDataOrthogonal.size();
        DataPointHints[] dpa = null;
        if (iBaseCount != iOrthogonalCount) {
            logger.log(1, Messages.getString("exception.base.orthogonal.inconsistent.count", new Object[]{iBaseCount, iOrthogonalCount}, this.rtc.getULocale()));
        } else {
            dpa = new DataPointHints[iBaseCount];
            boolean bScatter = oaxBase.getScale().getType() != 16 && !oaxBase.isCategoryScale();
            DataPoint dp = seOrthogonal.getDataPoint();
            EList<DataPointComponent> el = dp.getComponents();
            FormatSpecifier fsBase = null;
            FormatSpecifier fsOrthogonal = null;
            FormatSpecifier fsSeries = null;
            FormatSpecifier fsPercentile = null;
            int i = 0;
            while (i < el.size()) {
                DataPointComponent dpc = (DataPointComponent)el.get(i);
                DataPointComponentType dpct = dpc.getType();
                if (DataPointComponentType.BASE_VALUE_LITERAL.equals((Object)dpct) && (fsBase = dpc.getFormatSpecifier()) == null) {
                    fsBase = sdBase.getFormatSpecifier();
                }
                if (DataPointComponentType.ORTHOGONAL_VALUE_LITERAL.equals((Object)dpct) && (fsOrthogonal = dpc.getFormatSpecifier()) == null && seOrthogonal.eContainer() instanceof SeriesDefinition) {
                    fsOrthogonal = ((SeriesDefinition)seOrthogonal.eContainer()).getFormatSpecifier();
                }
                if (DataPointComponentType.SERIES_VALUE_LITERAL.equals((Object)dpct)) {
                    fsSeries = dpc.getFormatSpecifier();
                }
                if (DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL.equals((Object)dpct)) {
                    fsPercentile = dpc.getFormatSpecifier();
                }
                ++i;
            }
            dsiDataBase.reset();
            dsiDataOrthogonal.reset();
            UserDataSetHints udsh = new UserDataSetHints(seOrthogonal.getDataSets(), this.getModel().isReverseCategory());
            udsh.reset();
            double total = 0.0;
            boolean isZeroValue = true;
            int i2 = 0;
            while (i2 < iOrthogonalCount) {
                Object v = dsiDataOrthogonal.next();
                if (v instanceof Number) {
                    if (((Number)v).doubleValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((Number)v).doubleValue();
                } else if (v instanceof NumberDataElement) {
                    if (((NumberDataElement)v).getValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((NumberDataElement)v).getValue();
                }
                ++i2;
            }
            dsiDataOrthogonal.reset();
            i2 = 0;
            while (i2 < iBaseCount) {
                oDataBase = dsiDataBase.next();
                Object oDataOrthogonal = dsiDataOrthogonal.next();
                if (!bScatter) {
                    if (this.aax.areAxesSwapped()) {
                        dY = daTickCoordinates.getStart() + dUnitSize * (double)i2;
                        try {
                            dX = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dX = Double.NaN;
                        }
                        catch (ChartException chartException) {
                            dX = dOrthogonalZero;
                        }
                    } else {
                        dX = daTickCoordinates.getStart() + dUnitSize * (double)i2;
                        try {
                            dY = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dY = Double.NaN;
                        }
                        catch (ChartException chartException) {
                            dY = dOrthogonalZero;
                        }
                    }
                } else {
                    try {
                        dX = PlotWith2DAxes.getLocation(scBase, oDataBase);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dX = dBaseZero;
                    }
                    catch (ChartException chartException) {
                        dX = dBaseZero;
                    }
                    try {
                        dY = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dY = dOrthogonalZero;
                    }
                    catch (ChartException chartException) {
                        dY = dOrthogonalZero;
                    }
                    if (this.aax.areAxesSwapped()) {
                        double dTemp = dX;
                        dX = dY;
                        dY = dTemp;
                    }
                }
                Location lo = goFactory.createLocation(dX, dY);
                double dLength = 0.0;
                if (!bScatter) {
                    dLength = dUnitSize;
                } else {
                    int j = 0;
                    while (j < iTickCount - 1) {
                        if (this.aax.areAxesSwapped()) {
                            if (dY <= daTickCoordinates.getCoordinate(j) && dY >= daTickCoordinates.getCoordinate(j + 1) || dY <= daTickCoordinates.getCoordinate(j + 1) && dY >= daTickCoordinates.getCoordinate(j)) {
                                dLength = daTickCoordinates.getCoordinate(j + 1) - daTickCoordinates.getCoordinate(j);
                                break;
                            }
                        } else if (dX <= daTickCoordinates.getCoordinate(j + 1) && dX >= daTickCoordinates.getCoordinate(j) || dX <= daTickCoordinates.getCoordinate(j) && dX >= daTickCoordinates.getCoordinate(j + 1)) {
                            dLength = daTickCoordinates.getCoordinate(j + 1) - daTickCoordinates.getCoordinate(j);
                            break;
                        }
                        ++j;
                    }
                }
                Double percentileValue = null;
                boolean bIsPercent = oaxOrthogonal.getModelAxis().isPercent();
                if (bIsPercent) {
                    AxisSubUnit au = this.ssl.getUnit(seOrthogonal, i2);
                    if (oDataOrthogonal instanceof Number) {
                        percentileValue = new Double(au.valuePercentage(((Number)oDataOrthogonal).doubleValue()) / 100.0);
                    } else if (oDataOrthogonal instanceof NumberDataElement) {
                        percentileValue = new Double(au.valuePercentage(((NumberDataElement)oDataOrthogonal).getValue()) / 100.0);
                    }
                } else if (total != 0.0) {
                    if (oDataOrthogonal instanceof Number) {
                        percentileValue = new Double(((Number)oDataOrthogonal).doubleValue() / total);
                    } else if (oDataOrthogonal instanceof NumberDataElement) {
                        percentileValue = new Double(((NumberDataElement)oDataOrthogonal).getValue() / total);
                    }
                } else if (isZeroValue) {
                    percentileValue = new Double(1.0 / (double)iOrthogonalCount);
                }
                dpa[i2] = new DataPointHints(oDataBase, oDataOrthogonal, seOrthogonal.getSeriesIdentifier(), (Object)percentileValue, seOrthogonal.getDataPoint(), fsBase, fsOrthogonal, fsSeries, fsPercentile, i2, lo, dLength, this.rtc);
                udsh.next(dpa[i2]);
                ++i2;
            }
        }
        SeriesRenderingHints srh = new SeriesRenderingHints(this, oaxBase.getAxisCoordinate(), scOrthogonal.getStart(), dOrthogonalZero, this.dSeriesThickness, daTickCoordinates, dpa, scBase, scOrthogonal, this.ssl, dsiDataBase, dsiDataOrthogonal);
        this.setClientAreaBounds(oaxOrthogonal, seOrthogonal, srh);
        return srh;
    }

    private void setClientAreaBounds(OneAxis oaxOrthogonal, Series seOrthogonal, SeriesRenderingHints srh) {
        Bounds boClientArea = goFactory.copyOf(this.getPlotBounds());
        if (ChartUtil.hasMultipleYAxes(this.getModel()) && this.getModel().isStudyLayout()) {
            boolean isJustAreaSeries;
            double[] points = oaxOrthogonal.getScale().getEndPoints();
            double start = points[0];
            double end = points[1];
            if (!this.aax.areAxesSwapped()) {
                boClientArea.setTop(end);
                boClientArea.setHeight(start - end);
            } else {
                boClientArea.setLeft(start);
                boClientArea.setWidth(end - start);
            }
            boolean isLineSeries = seOrthogonal instanceof LineSeries;
            boolean bl = isJustAreaSeries = seOrthogonal instanceof AreaSeries && !(seOrthogonal instanceof DifferenceSeries);
            if (this.iDimension == 1 && (!isLineSeries || isJustAreaSeries)) {
                boClientArea.delta(this.dSeriesThickness, -this.dSeriesThickness, 0.0, 0.0);
            }
        }
        srh.setClientAreaBounds(boClientArea);
    }

    public final StackedSeriesLookup getStackedSeriesLookup() {
        return this.ssl;
    }

    public void addMargin(int percent) {
        if (percent > 0) {
            this.iMarginPercent = percent;
        }
    }

    public final void initDynamicPlotBounds(Bounds bo) throws ChartException {
        if (bo.getWidth() * bo.getHeight() == 0.0) {
            Axis[] axa = this.getModel().getPrimaryBaseAxes();
            Axis axPrimaryBase = axa[0];
            Axis axPrimaryOrthogonal = this.getModel().getPrimaryOrthogonalAxis(axPrimaryBase);
            int iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
            DataSetIterator dsi = new DataSetIterator(this.getMinMax(axPrimaryOrthogonal, iAxisType), iAxisType);
            OneAxis oaxPrimaryOrthogonal = this.getAxes().getPrimaryOrthogonal();
            AutoScale scPrimaryOrthogonal = AutoScale.computeScale(this.ids, oaxPrimaryOrthogonal, dsi, iAxisType, 0.0, 0.0, axPrimaryBase.getOrigin(), this.rtc, 0, 1.0, this.iMarginPercent, this);
            double axisHeight = scPrimaryOrthogonal.computeAxisLabelThickness(this.ids, axPrimaryOrthogonal.getLabel(), this.getAxes().getOrientation()) * 72.0 / (double)this.ids.getDpiResolution() + 3.75;
            if (bo.getWidth() == 0.0) {
                bo.setWidth(axisHeight);
            } else {
                bo.setHeight(axisHeight);
            }
        } else if (bo.getWidth() * bo.getHeight() < 0.0) {
            double dBase = bo.getHeight() < 0.0 ? Math.abs(bo.getHeight()) : Math.abs(bo.getWidth());
            Series baseSeries = this.getModel().getSeries(1)[0];
            Object[] values = (Object[])baseSeries.getDataSet().getValues();
            int iDPCount = values.length;
            double dTotalWidth = dBase * (double)iDPCount;
            if (bo.getWidth() < 0.0) {
                bo.setWidth(dTotalWidth);
            } else {
                bo.setHeight(dTotalWidth);
            }
        }
    }

    void updateValueAxis(OneAxis valueAxis, double dStart, double dEnd, boolean isReverseCategory) throws ChartException, IllegalArgumentException {
        Axis yAxis = valueAxis.getModelAxis();
        int iAxisType = PlotWith2DAxes.getAxisType(yAxis);
        DataSetIterator dsi = null;
        if ((iAxisType & 1) != 1 && (iAxisType & 8) != 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.orthogonal.axis.numerical.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        Object minMax = this.getMinMax(yAxis, iAxisType);
        dsi = this.rtc.getSharedScale() != null ? this.getSharedScaleMinMax(iAxisType, minMax) : new DataSetIterator(minMax, iAxisType);
        dsi.reverse(isReverseCategory);
        this.updateAxisScale(valueAxis, iAxisType, dsi, dStart, dEnd);
    }

    private DataSetIterator getSharedScaleMinMax(int iAxisType, Object minMax) throws ChartException {
        DataSetIterator dsi = minMax instanceof BigNumber[] ? this.rtc.getSharedScale().createDataSetIterator(iAxisType, true, ((BigNumber[])minMax)[1].getDivisor()) : this.rtc.getSharedScale().createDataSetIterator(iAxisType, false, null);
        if ((iAxisType & 1) == 1) {
            Object min = dsi.first();
            Object max = dsi.next();
            dsi = new DataSetIterator(this.adjustMinMax(min, max), iAxisType);
        }
        return dsi;
    }

    private void updateAxisScale(OneAxis oax, int iAxisType, DataSetIterator dsi, double dStart, double dEnd) throws ChartException {
        boolean isPrimaryOrthogonal = this.aax.getPrimaryOrthogonal() == oax;
        AutoScale scValueAxis = AutoScale.computeScale(this.ids, oax, dsi, iAxisType, dStart, dEnd, isPrimaryOrthogonal ? this.aax.getPrimaryBase().getModelAxis().getOrigin() : oax.getModelAxis().getOrigin(), this.rtc, 0, 1.0, this.iMarginPercent, this);
        oax.set(scValueAxis);
        scValueAxis.resetShifts();
    }
}

