/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.IRenderInstruction;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.render.DeferredCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WrappedInstruction
implements IRenderInstruction {
    private final DeferredCache dc;
    private final int iInstruction;
    private ArrayList alEvents = null;
    private PrimitiveRenderEvent pre = null;
    private long zorder = 0L;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();
    private DeferredCache subDeferredCache = null;
    private Bounds compareBounds = null;

    public WrappedInstruction(DeferredCache dc, ArrayList alEvents, int iInstruction, long zorder) {
        this.dc = dc;
        this.alEvents = alEvents;
        this.iInstruction = iInstruction;
        this.zorder = zorder;
    }

    public WrappedInstruction(DeferredCache dc, ArrayList alEvents, int iInstruction) {
        this(dc, alEvents, iInstruction, 0L);
    }

    public WrappedInstruction(DeferredCache dc, PrimitiveRenderEvent pre, int iInstruction, long zorder) {
        this.dc = dc;
        this.pre = pre;
        this.iInstruction = iInstruction;
        this.zorder = zorder;
    }

    public WrappedInstruction(DeferredCache dc, PrimitiveRenderEvent pre, int iInstruction) {
        this(dc, pre, iInstruction, 0L);
    }

    public int compareTo(Object o) {
        Bounds bo = null;
        if (o instanceof PrimitiveRenderEvent) {
            try {
                bo = ((PrimitiveRenderEvent)o).getBounds();
            }
            catch (ChartException chartException) {
                assert (false);
                return -1;
            }
        } else if (o instanceof IRenderInstruction) {
            if (o instanceof WrappedInstruction) {
                bo = ((WrappedInstruction)o).getCompareBounds();
                long zorder_that = ((WrappedInstruction)o).zorder;
                if (this.zorder < zorder_that) {
                    return -1;
                }
                if (this.zorder > zorder_that) {
                    return 1;
                }
            } else {
                bo = ((IRenderInstruction)o).getBounds();
            }
        }
        return this.dc != null && this.dc.isTransposed() ? PrimitiveRenderEvent.compareTransposed(this.getCompareBounds(), bo) : (bo == null ? 1 : PrimitiveRenderEvent.compareRegular(this.getCompareBounds(), bo));
    }

    @Override
    public final PrimitiveRenderEvent getEvent() {
        return this.pre;
    }

    @Override
    public final int getInstruction() {
        return this.iInstruction;
    }

    public String toString() {
        return Messages.getString("wrapped.instruction.to.string", new Object[]{super.toString(), this.isModel(), this.getBounds()}, ULocale.getDefault());
    }

    public void setCompareBounds(Bounds bounds) {
        this.compareBounds = bounds;
    }

    public Bounds getCompareBounds() {
        if (this.compareBounds != null) {
            return this.compareBounds;
        }
        return this.getBounds();
    }

    @Override
    public final Bounds getBounds() {
        block9: {
            if (this.compareBounds != null) {
                return this.compareBounds;
            }
            if (!this.isModel()) {
                try {
                    return this.pre.getBounds();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    break block9;
                }
            }
            Bounds bo = null;
            int i = 0;
            while (i < this.alEvents.size()) {
                try {
                    if (i == 0) {
                        bo = goFactory.copyOf(((PrimitiveRenderEvent)this.alEvents.get(i)).getBounds());
                    } else {
                        bo.max(((PrimitiveRenderEvent)this.alEvents.get(i)).getBounds());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
            return bo;
        }
        return null;
    }

    @Override
    public boolean isModel() {
        return this.pre == null;
    }

    @Override
    public List getModel() {
        return this.alEvents;
    }

    public long getZOrder() {
        return this.zorder;
    }

    public void setZOrder(int zorder) {
        this.zorder = zorder;
    }

    public static Comparator<?> getDefaultComarator() {
        return new WIComparator();
    }

    public void setSubDeferredCache(DeferredCache dc) {
        this.subDeferredCache = dc;
    }

    public DeferredCache getSubDeferredCache() {
        return this.subDeferredCache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WIComparator
    implements Comparator<Object>,
    Serializable {
        private WIComparator() {
        }

        private long getZOrder(Object o) {
            if (o instanceof WrappedInstruction) {
                return ((WrappedInstruction)o).getZOrder();
            }
            return 0L;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return Long.valueOf(this.getZOrder(o1)).compareTo(this.getZOrder(o2));
        }
    }
}

