/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaCompositorDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaElementDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaElementReferenceDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaIdentifierAttributeDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaJavaAttributeDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaOtherAttributeDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaRootElementDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaStringAttributeDetails;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SchemaFormPage
extends PDEFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "form";
    private ElementSection fSection;
    private SchemaBlock fBlock = new SchemaBlock();
    private DetailsPart fDetailsPart;
    private ImageHyperlink fImageHyperlinkPreviewRefDoc;
    private ShowDescriptionAction fPreviewAction;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public SchemaFormPage(PDEFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.SchemaEditor_FormPage_title);
    }

    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.schema_editor_main";
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        ISchema schema = (ISchema)((SchemaEditor)this.getEditor()).getAggregateModel();
        if (schema.isEditable()) {
            form.getToolBarManager().add((IContributionItem)this.createUIControlConPreviewRefDoc());
            form.getToolBarManager().update(true);
        }
        super.createFormContent(managedForm);
        this.fBlock.createContent(managedForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.schema_editor_main");
        this.initialize();
    }

    private ControlContribution createUIControlConPreviewRefDoc() {
        return new ControlContribution("Preview"){

            protected Control createControl(Composite parent) {
                SchemaFormPage.this.createUIImageHyperlinkPreviewRefDoc(parent);
                SchemaFormPage.this.createUIListenerImageHyperlinkPreviewRefDoc();
                return SchemaFormPage.this.fImageHyperlinkPreviewRefDoc;
            }
        };
    }

    private void createUIImageHyperlinkPreviewRefDoc(Composite parent) {
        this.fImageHyperlinkPreviewRefDoc = new ImageHyperlink(parent, 0);
        this.fImageHyperlinkPreviewRefDoc.setText(PDEUIMessages.SchemaEditor_previewLink);
        this.fImageHyperlinkPreviewRefDoc.setUnderlined(true);
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
    }

    private void createUIListenerImageHyperlinkPreviewRefDoc() {
        this.fImageHyperlinkPreviewRefDoc.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                SchemaFormPage.this.handleLinkActivatedPreviewRefDoc();
            }

            public void linkEntered(HyperlinkEvent e) {
                SchemaFormPage.this.handleLinkEnteredPreviewRefDoc(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                SchemaFormPage.this.handleLinkExitedPreviewRefDoc();
            }
        });
    }

    private void handleLinkEnteredPreviewRefDoc(String message) {
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getActiveForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private void handleLinkExitedPreviewRefDoc() {
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    private void handleLinkActivatedPreviewRefDoc() {
        ISchema schema = (ISchema)((SchemaEditor)this.getEditor()).getAggregateModel();
        if (this.fPreviewAction == null) {
            this.fPreviewAction = new ShowDescriptionAction(schema);
        } else {
            this.fPreviewAction.setSchema(schema);
        }
        this.fPreviewAction.run();
    }

    public void initialize() {
        ISchema schema = (ISchema)this.getModel();
        this.getManagedForm().getForm().setText(schema.getName());
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        ISchema schema = (ISchema)this.getModel();
        if (schema != null) {
            schema.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        IDetailsPage page;
        if (event.getChangeType() == 3) {
            Object[] change;
            String changeProperty = event.getChangedProperty();
            if (changeProperty != null && changeProperty.equals("name") && (change = event.getChangedObjects()).length > 0 && change[0] instanceof ISchema) {
                this.getManagedForm().getForm().setText(((ISchema)change[0]).getName());
            }
        } else if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        }
        if (this.fSection != null) {
            this.fSection.handleModelChanged(event);
        }
        if ((page = this.fDetailsPart.getCurrentPage()) instanceof IModelChangedListener) {
            ((IModelChangedListener)page).modelChanged(event);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        ISchema schema = (ISchema)this.getModel();
        this.getManagedForm().getForm().setText(schema.getName());
    }

    public class SchemaBlock
    extends PDEMasterDetailsBlock
    implements IDetailsPageProvider {
        public SchemaBlock() {
            super(SchemaFormPage.this);
        }

        protected PDESection createMasterSection(IManagedForm managedForm, Composite parent) {
            SchemaFormPage.this.fSection = new ElementSection(this.getPage(), parent);
            return SchemaFormPage.this.fSection;
        }

        protected void registerPages(DetailsPart detailsPart) {
            SchemaFormPage.this.fDetailsPart = detailsPart;
            detailsPart.setPageLimit(5);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaObjectReference");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz, (IDetailsPage)new SchemaElementReferenceDetails(SchemaFormPage.this.fSection));
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaRootElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz2, (IDetailsPage)new SchemaRootElementDetails(SchemaFormPage.this.fSection));
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz3, (IDetailsPage)new SchemaElementDetails(SchemaFormPage.this.fSection));
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaCompositor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz4, (IDetailsPage)new SchemaCompositorDetails(SchemaFormPage.this.fSection));
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaStringAttributeDetails");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz5, (IDetailsPage)new SchemaStringAttributeDetails(SchemaFormPage.this.fSection));
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaJavaAttributeDetails");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz6, (IDetailsPage)new SchemaJavaAttributeDetails(SchemaFormPage.this.fSection));
            Class<?> clazz7 = class$6;
            if (clazz7 == null) {
                try {
                    clazz7 = class$6 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaOtherAttributeDetails");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz7, (IDetailsPage)new SchemaOtherAttributeDetails(SchemaFormPage.this.fSection));
            Class<?> clazz8 = class$7;
            if (clazz8 == null) {
                try {
                    clazz8 = class$7 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaIdentifierAttributeDetails");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            detailsPart.registerPage(clazz8, (IDetailsPage)new SchemaIdentifierAttributeDetails(SchemaFormPage.this.fSection));
            detailsPart.setPageProvider((IDetailsPageProvider)this);
        }

        public Object getPageKey(Object object) {
            block38: {
                Class<?> clazz;
                if (object instanceof ISchemaObjectReference) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaObjectReference");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz2;
                }
                if (object instanceof ISchemaRootElement) {
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaRootElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz3;
                }
                if (object instanceof ISchemaElement) {
                    Class<?> clazz4 = class$2;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$2 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz4;
                }
                if (object instanceof ISchemaCompositor) {
                    Class<?> clazz5 = class$3;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$3 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaCompositor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz5;
                }
                if (!(object instanceof ISchemaAttribute)) break block38;
                ISchemaAttribute att = (ISchemaAttribute)object;
                int kind = att.getKind();
                switch (kind) {
                    case 1: {
                        Class<?> clazz6 = class$5;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$5 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaJavaAttributeDetails");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        return clazz6;
                    }
                    case 3: {
                        Class<?> clazz7 = class$7;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$7 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaIdentifierAttributeDetails");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        return clazz7;
                    }
                    case 0: {
                        if (!att.getType().getName().equals(ISchemaAttribute.TYPES[1])) break;
                        Class<?> clazz8 = class$4;
                        if (clazz8 == null) {
                            try {
                                clazz8 = class$4 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaStringAttributeDetails");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        return clazz8;
                    }
                }
                if ((clazz = class$6) == null) {
                    try {
                        clazz = class$6 = Class.forName("org.eclipse.pde.internal.ui.editor.schema.SchemaOtherAttributeDetails");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            return null;
        }

        public IDetailsPage getPage(Object object) {
            return null;
        }
    }
}

