/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointTypeRenameChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointRenameTypeParticipant
extends BreakpointRenameParticipant {
    @Override
    protected boolean accepts(IJavaElement element) {
        return element instanceof IType;
    }

    @Override
    protected Change createTypeChange(IJavaBreakpoint breakpoint, IType destType, IType originalType) throws CoreException {
        if (breakpoint instanceof IJavaWatchpoint) {
            return new WatchpointTypeRenameChange((IJavaWatchpoint)breakpoint, destType, originalType, this.getProcessor(), (RenameTypeArguments)this.getArguments());
        }
        return super.createTypeChange(breakpoint, destType, originalType);
    }

    @Override
    protected void gatherChanges(IMarker[] markers, List<Change> changes, String simpleDestName) throws CoreException, OperationCanceledException {
        IType originalType = (IType)this.getOriginalElement();
        ICompilationUnit originalCU = originalType.getCompilationUnit();
        ICompilationUnit destCU = null;
        IType primaryType = originalCU.findPrimaryType();
        if (originalType.isMember() || primaryType == null || !primaryType.equals(originalType)) {
            destCU = originalCU;
        } else if (primaryType.equals(originalType)) {
            String ext = ".java";
            IResource res = originalCU.getResource();
            if (res != null) {
                ext = String.valueOf('.') + res.getFileExtension();
            }
            destCU = originalType.getPackageFragment().getCompilationUnit(String.valueOf(simpleDestName) + ext);
        }
        IType newType = BreakpointChange.getType(originalType.getParent(), simpleDestName);
        newType = (IType)BreakpointChange.findElement((IJavaElement)destCU, (IJavaElement)newType);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaBreakpoint) {
                IJavaBreakpoint javaBreakpoint = (IJavaBreakpoint)breakpoint;
                IType breakpointType = BreakpointUtils.getType(javaBreakpoint);
                IType destType = null;
                if (breakpointType != null) {
                    IJavaElement element = null;
                    if (this.isContained((IJavaElement)originalType, breakpointType)) {
                        element = BreakpointChange.findElement((IJavaElement)newType, (IJavaElement)breakpointType);
                    } else if (this.isContained((IJavaElement)originalCU, breakpointType)) {
                        element = BreakpointChange.findElement((IJavaElement)destCU, (IJavaElement)breakpointType);
                    }
                    if (element instanceof IType) {
                        destType = (IType)element;
                        changes.add(this.createTypeChange(javaBreakpoint, destType, breakpointType));
                    }
                }
            }
            ++i;
        }
    }
}

