/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.Messages;
import org.eclipse.xtext.builder.builderState.PersistedStateProvider;
import org.eclipse.xtext.builder.builderState.ResourceDescriptionsData;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilderState
extends AbstractResourceDescriptionChangeEventSource
implements IBuilderState {
    private volatile ResourceDescriptionsData resourceDescriptionData = new ResourceDescriptionsData(Collections.<IResourceDescription>emptyList());
    @Inject
    private IMarkerUpdater markerUpdater;
    @Inject
    private PersistedStateProvider persister;
    private volatile boolean isLoaded = false;

    public synchronized void load() {
        if (!this.isLoaded) {
            this.resourceDescriptionData = new ResourceDescriptionsData(this.persister.load());
            this.isLoaded = true;
        }
    }

    protected void ensureLoaded() {
        if (!this.isLoaded) {
            this.load();
        }
    }

    protected Set<URI> ensureNotNull(Set<URI> uris) {
        return uris != null ? uris : Collections.emptySet();
    }

    protected void setResourceDescriptionsData(ResourceDescriptionsData newData) {
        this.resourceDescriptionData = newData;
    }

    protected void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) {
        this.markerUpdater.updateMarkers(delta, resourceSet, monitor);
    }

    protected ResourceDescriptionsData getCopiedResourceDescriptionsData() {
        return this.resourceDescriptionData.copy();
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        this.ensureLoaded();
        return this.resourceDescriptionData.getAllResourceDescriptions();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getResourceDescription(uri);
    }

    public void setPersister(PersistedStateProvider persister) {
        this.persister = persister;
    }

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> update(BuildData buildData, IProgressMonitor monitor) {
        this.ensureLoaded();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_0, (int)1);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (buildData.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceDescriptionsData newData = this.getCopiedResourceDescriptionsData();
        Collection<IResourceDescription.Delta> result = this.doUpdate(buildData, newData, (IProgressMonitor)subMonitor.newChild(1));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(result, (IResourceDescription.Event.Source)this);
        this.setResourceDescriptionsData(newData);
        this.notifyListeners((IResourceDescription.Event)event);
        return event.getDeltas();
    }

    protected abstract Collection<IResourceDescription.Delta> doUpdate(BuildData var1, ResourceDescriptionsData var2, IProgressMonitor var3);

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> clean(Set<URI> toBeRemoved, IProgressMonitor monitor) {
        this.ensureLoaded();
        toBeRemoved = this.ensureNotNull(toBeRemoved);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_0, (int)2);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (toBeRemoved.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Collection<IResourceDescription.Delta> deltas = this.doClean(toBeRemoved, (IProgressMonitor)subMonitor.newChild(1));
        ResourceDescriptionsData newData = this.getCopiedResourceDescriptionsData();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IResourceDescription.Delta delta : deltas) {
            newData.removeDescription(delta.getOld().getURI());
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(deltas, (IResourceDescription.Event.Source)this);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        subMonitor.setWorkRemaining(event.getDeltas().size());
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            this.updateMarkers(delta, null, (IProgressMonitor)subMonitor);
            subMonitor.worked(1);
        }
        this.setResourceDescriptionsData(newData);
        this.notifyListeners((IResourceDescription.Event)event);
        return event.getDeltas();
    }

    protected Collection<IResourceDescription.Delta> doClean(Set<URI> toBeRemoved, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_2, (int)toBeRemoved.size());
        subMonitor.subTask(Messages.AbstractBuilderState_2);
        HashSet toBeDeletedAsSet = Sets.newHashSet(toBeRemoved);
        HashMap result = Maps.newHashMap();
        for (URI toDelete : toBeDeletedAsSet) {
            IResourceDescription resourceDescription = this.getResourceDescription(toDelete);
            if (resourceDescription != null) {
                result.put(toDelete, new DefaultResourceDescriptionDelta(resourceDescription, null));
            }
            subMonitor.worked(1);
        }
        return result.values();
    }

    public Iterable<IEObjectDescription> getExportedObjects() {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjects();
    }

    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjects(type, name, ignoreCase);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjectsByType(type);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjectsByObject(object);
    }

    public boolean isEmpty() {
        this.ensureLoaded();
        return this.resourceDescriptionData.isEmpty();
    }
}

