/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import java.util.Comparator;
import org.eclipse.jdt.internal.junit.runner.IStopListener;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit4.runner.FailuresFirstSorter;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestListener;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public abstract class JUnit4TestReference
implements ITestReference {
    protected Runner fRunner;

    public JUnit4TestReference(Request request, String[] failureNames) {
        if (failureNames != null) {
            request = request.sortWith((Comparator)new FailuresFirstSorter(failureNames));
        }
        this.fRunner = request.getRunner();
    }

    public void run(TestExecution execution) {
        final RunNotifier notifier = new RunNotifier();
        notifier.addListener((RunListener)new JUnit4TestListener(execution.getListener()));
        execution.addStopListener(new IStopListener(){

            public void stop() {
                notifier.pleaseStop();
            }
        });
        Result result = new Result();
        RunListener listener = result.createListener();
        notifier.addListener(listener);
        try {
            try {
                notifier.fireTestRunStarted(this.fRunner.getDescription());
                this.fRunner.run(notifier);
                notifier.fireTestRunFinished(result);
            }
            catch (StoppedByUserException stoppedByUserException) {
                notifier.removeListener(listener);
            }
        }
        finally {
            notifier.removeListener(listener);
        }
    }
}

