/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler.output;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class AppendableBasedTraceRegion
extends AbstractTraceRegion {
    private final List<ILocationData> locations;
    private int offset;
    private int length;
    private int lineNumber;
    private int endLineNumber;
    private boolean useForDebugging;

    public boolean isUseForDebugging() {
        return this.useForDebugging;
    }

    public AppendableBasedTraceRegion(@Nullable AbstractTraceRegion parent, TreeAppendable delegate, int offset, int lineNumber) {
        super(parent);
        URI parentPath;
        this.offset = offset;
        this.lineNumber = lineNumber;
        this.useForDebugging = delegate.isUseForDebugging();
        boolean useLocationsFromDelegate = true;
        if (parent != null && (parentPath = parent.getAssociatedPath()) != null) {
            boolean matches = true;
            for (ILocationData iLocationData : delegate.getLocationData()) {
                if (parentPath.equals((Object)iLocationData.getPath())) continue;
                matches = false;
                break;
            }
            boolean bl = useLocationsFromDelegate = !matches;
        }
        if (useLocationsFromDelegate) {
            this.locations = Lists.newArrayList(delegate.getLocationData());
        } else {
            this.locations = Lists.newArrayList();
            for (ILocationData locationData : delegate.getLocationData()) {
                this.locations.add((ILocationData)new LocationData(locationData.getOffset(), locationData.getLength(), locationData.getLineNumber(), locationData.getEndLineNumber(), null, null));
            }
        }
        int length = 0;
        int line = lineNumber;
        for (Object object : delegate.getChildren()) {
            if (object instanceof TreeAppendable) {
                TreeAppendable castedChild = (TreeAppendable)object;
                if (!this.hasVisibleChildren(castedChild)) continue;
                AppendableBasedTraceRegion childRegion = new AppendableBasedTraceRegion(this, castedChild, offset + length, line);
                length += childRegion.getMyLength();
                line = childRegion.getMyEndLineNumber();
                continue;
            }
            String s = object.toString();
            length += s.length();
            line += Strings.countLineBreaks((CharSequence)s);
        }
        this.length = length;
        this.endLineNumber = line;
        if (parent == null) {
            this.compressTrace(delegate.getContent());
        }
    }

    protected void compressTrace(String completeContent) {
        this.leftCompressTrace(completeContent);
        this.rightCompressTrace(completeContent);
    }

    protected void leftCompressTrace(String completeContent) {
        List allNested = this.getWritableNestedRegions();
        int i = 0;
        while (i < allNested.size()) {
            AppendableBasedTraceRegion nested = (AppendableBasedTraceRegion)((Object)allNested.get(i));
            int offset = nested.getMyOffset();
            int diff = 0;
            while (completeContent.charAt(offset + diff) <= ' ' && diff < nested.length) {
                ++diff;
            }
            if (diff == nested.length) {
                allNested.remove(i);
                continue;
            }
            nested.lineNumber += Strings.countLineBreaks((CharSequence)completeContent.substring(offset, offset + diff));
            nested.offset += diff;
            nested.length -= diff;
            nested.leftCompressTrace(completeContent);
            ++i;
        }
    }

    protected void rightCompressTrace(String completeContent) {
        List allNested = this.getWritableNestedRegions();
        int i = 0;
        while (i < allNested.size()) {
            AppendableBasedTraceRegion nested = (AppendableBasedTraceRegion)((Object)allNested.get(i));
            int endOffset = nested.getMyOffset() + nested.getMyLength() - 1;
            int diff = 0;
            while (completeContent.charAt(endOffset - diff) <= ' ' && diff < nested.length) {
                ++diff;
            }
            if (diff != 0) {
                nested.endLineNumber -= Strings.countLineBreaks((CharSequence)completeContent.substring(endOffset - diff + 1, endOffset + 1));
                nested.length -= diff;
                nested.rightCompressTrace(completeContent);
            }
            ++i;
        }
    }

    protected boolean hasVisibleChildren(TreeAppendable castedChild) {
        for (Object object : castedChild.getChildren()) {
            if (object instanceof String) {
                return true;
            }
            if (!this.hasVisibleChildren((TreeAppendable)object)) continue;
            return true;
        }
        return false;
    }

    public int getMyLength() {
        return this.length;
    }

    public int getMyOffset() {
        return this.offset;
    }

    public int getMyLineNumber() {
        return this.lineNumber;
    }

    public int getMyEndLineNumber() {
        return this.endLineNumber;
    }

    public List<ILocationData> getAssociatedLocations() {
        return this.locations;
    }
}

