/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.EditorSynchronizer;
import org.eclipse.ant.internal.ui.editor.OccurrencesFinder;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class RenameInFileAction
extends SelectionDispatchAction {
    private AntEditor fEditor;

    public RenameInFileAction(AntEditor antEditor) {
        super((IWorkbenchSite)antEditor.getSite());
        this.fEditor = antEditor;
        this.setText(AntEditorActionMessages.getString("RenameInFileAction.0"));
        this.setDescription(AntEditorActionMessages.getString("RenameInFileAction.1"));
        this.setToolTipText(AntEditorActionMessages.getString("RenameInFileAction.2"));
    }

    public void run() {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        IDocument document = viewer.getDocument();
        int offset = ((ITextSelection)this.getSelection()).getOffset();
        LinkedPositionGroup group = new LinkedPositionGroup();
        OccurrencesFinder finder = new OccurrencesFinder(this.fEditor, this.fEditor.getAntModel(), document, offset);
        List positions = finder.perform();
        if (positions == null) {
            return;
        }
        this.addPositionsToGroup(offset, positions, document, group);
        if (group.isEmpty()) {
            return;
        }
        try {
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            model.addLinkingListener((ILinkedModeListener)new EditorSynchronizer(this.fEditor));
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, (ITextViewer)viewer);
            ui.setExitPosition((ITextViewer)viewer, offset, 0, Integer.MAX_VALUE);
            ui.enter();
            viewer.setSelectedRange(offset, 0);
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
    }

    private void addPositionsToGroup(int offset, List positions, IDocument document, LinkedPositionGroup group) {
        Iterator iter = positions.iterator();
        int i = 0;
        int j = 0;
        int firstPosition = -1;
        try {
            Position position;
            while (iter.hasNext()) {
                position = (Position)iter.next();
                if (firstPosition == -1) {
                    if (position.overlapsWith(offset, 0)) {
                        firstPosition = i;
                        group.addPosition(new LinkedPosition(document, position.getOffset(), position.getLength(), j++));
                    }
                } else {
                    group.addPosition(new LinkedPosition(document, position.getOffset(), position.getLength(), j++));
                }
                ++i;
            }
            i = 0;
            while (i < firstPosition) {
                position = (Position)positions.get(i);
                group.addPosition(new LinkedPosition(document, position.getOffset(), position.getLength(), j++));
                ++i;
            }
        }
        catch (BadLocationException be) {
            AntUIPlugin.log(be);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.fEditor != null);
    }

    public void setEditor(AntEditor editor) {
        this.fEditor = editor;
    }
}

