/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarlyExitValidator
extends AbstractDeclarativeValidator {
    private final Map<EReference, EarlyExitKind> disallowedEarylExitReferences = ImmutableMap.of((Object)XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__FINALLY_EXPRESSION, (Object)((Object)EarlyExitKind.BOTH));
    @Inject
    private IEarlyExitComputer earlyExitComputer;

    protected Map<EReference, EarlyExitKind> getDisallowedEarlyExitReferences() {
        return this.disallowedEarylExitReferences;
    }

    @Check
    public void checkInvalidReturnExpression(XExpression expression) {
        EReference contFeature = (EReference)expression.eContainingFeature();
        Map<EReference, EarlyExitKind> map = this.getDisallowedEarlyExitReferences();
        if (map.containsKey(contFeature)) {
            EarlyExitKind exitKind = map.get(contFeature);
            ArrayList returns = Lists.newArrayList();
            this.collectExits(expression, returns);
            for (XExpression expr : returns) {
                if (expr instanceof XReturnExpression && (exitKind == EarlyExitKind.RETURN || exitKind == EarlyExitKind.BOTH)) {
                    this.error("A return expression is not allowed in this context.", expr, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
                }
                if (!(expr instanceof XThrowExpression) || exitKind != EarlyExitKind.THROW && exitKind != EarlyExitKind.BOTH) continue;
                this.error("A throw expression is not allowed in this context.", expr, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
            }
        }
    }

    protected void collectExits(EObject expr, List<XExpression> found) {
        if (expr instanceof XReturnExpression) {
            found.add((XExpression)expr);
        } else if (expr instanceof XThrowExpression) {
            found.add((XExpression)expr);
        } else if (expr instanceof XClosure) {
            return;
        }
        for (EObject child : expr.eContents()) {
            this.collectExits(child, found);
        }
    }

    @Check
    public void checkDeadCode(XBlockExpression block) {
        EList<XExpression> expressions = block.getExpressions();
        int i = 0;
        while (i < expressions.size() - 1) {
            if (this.earlyExitComputer.isEarlyExit((XExpression)expressions.get(i))) {
                this.error("Unreachable expression.", (EObject)expressions.get(i + 1), null, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code", new String[0]);
                return;
            }
            ++i;
        }
    }

    public void register(EValidatorRegistrar registrar) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EarlyExitKind {
        RETURN,
        THROW,
        BOTH;

    }
}

