/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.controls;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelType;
import org.eclipse.stem.model.ui.editor.ModelDiagramEditor;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class ModelPropertiesComposite
extends Composite
implements ISelectionListener {
    ModelDiagramEditor editor;
    private Label modelNameTextLabel;
    private Label modelTypeTextLabel;
    private ComboViewer modelParentViewer;
    private Button loadModelsButton;
    private ModelElement selectedModelElement;
    private Model selectedModel;

    public ModelPropertiesComposite(ModelDiagramEditor editor, Composite parent, int style) {
        super(parent, style);
        this.editor = editor;
        this.setLayout((Layout)new GridLayout(3, false));
        this.init();
        editor.addModelSelectionListener(this);
    }

    public void dispose() {
        this.editor.removeModelSelectionListener(this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            this.setModel((ModelElement)((StructuredSelection)selection).getFirstElement());
        }
    }

    public void setModel(ModelElement me) {
        if (this.selectedModelElement == me) {
            return;
        }
        this.selectedModelElement = me;
        if (this.selectedModelElement != null) {
            this.setModel(this.selectedModelElement.getModel());
        } else {
            this.setModel((Model)null);
        }
    }

    private void setModel(Model model) {
        this.selectedModel = model;
        this.setFields();
    }

    protected void init() {
        Label modelNameLabel = new Label((Composite)this, 0);
        modelNameLabel.setText("Model Name");
        this.modelNameTextLabel = new Label((Composite)this, 0);
        this.modelNameTextLabel.setText("");
        GridData modelNameTextData = new GridData();
        modelNameTextData.horizontalSpan = 2;
        this.modelNameTextLabel.setLayoutData((Object)modelNameTextData);
        GridData modelNameLabelData = new GridData();
        modelNameLabelData.horizontalSpan = 2;
        this.modelNameTextLabel.setLayoutData((Object)modelNameLabelData);
        Label modelTypeLabel = new Label((Composite)this, 0);
        modelTypeLabel.setText("Model Type");
        this.modelTypeTextLabel = new Label((Composite)this, 0);
        this.modelTypeTextLabel.setText("");
        GridData modelTypeComboData = new GridData();
        modelTypeComboData.horizontalSpan = 2;
        this.modelTypeTextLabel.setLayoutData((Object)modelTypeComboData);
        Label modelParentLabel = new Label((Composite)this, 0);
        modelParentLabel.setText("Parent Model");
        this.modelParentViewer = new ComboViewer((Composite)this, 8);
        this.modelParentViewer.setContentProvider((IContentProvider)new ModelParentContentProvider());
        this.modelParentViewer.setLabelProvider((IBaseLabelProvider)new ModelParentLabelProvider());
        this.modelParentViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof EClass && e2 instanceof EClass) {
                    return ((EClass)e1).getName().compareTo(((EClass)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.modelParentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.loadModelsButton = new Button((Composite)this, 8);
        this.loadModelsButton.setEnabled(true);
        this.loadModelsButton.setText("Reload Model List");
        this.loadModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelPropertiesComposite.this.loadModelPackages();
                ModelPropertiesComposite.this.modelParentViewer.refresh();
            }
        });
        this.doSelectParentModel();
    }

    private void setFields() {
        if (this.selectedModel != null) {
            this.modelNameTextLabel.setText(this.selectedModel.getName());
            this.modelTypeTextLabel.setText(this.selectedModel.getModelType().getLiteral());
            this.modelParentViewer.setInput((Object)this.selectedModel.getModelType());
            this.modelParentViewer.refresh();
            this.loadModelsButton.setEnabled(true);
            this.doSelectParentModel();
        } else {
            this.modelNameTextLabel.setText("");
            this.modelTypeTextLabel.setText("");
            this.modelParentViewer.setInput(null);
            this.loadModelsButton.setEnabled(false);
            this.modelParentViewer.refresh();
        }
    }

    private void doSelectParentModel() {
        if (this.selectedModel != null && this.selectedModel.getParentModel() != null) {
            String[] items = this.modelParentViewer.getCombo().getItems();
            int idx = 0;
            while (idx < items.length) {
                Object selected;
                if (items[idx].equals(this.selectedModel.getParentModel().getName()) && (selected = this.modelParentViewer.getElementAt(idx)) != null) {
                    this.modelParentViewer.setSelection((ISelection)new StructuredSelection(selected));
                    break;
                }
                ++idx;
            }
        }
    }

    public Model getParentModel() {
        StructuredSelection selection = (StructuredSelection)this.modelParentViewer.getSelection();
        if (selection.getFirstElement() instanceof Model) {
            Model selectedModel = (Model)selection.getFirstElement();
            if (selectedModel.getParentModel() != null && selectedModel.getParentModel().getName() != null && selectedModel.getParentModel().getName().equals(selectedModel.getName())) {
                return selectedModel.getParentModel();
            }
            return selectedModel;
        }
        return null;
    }

    private void loadModelPackages() {
        WizardHelper.loadMetamodels((boolean)true, (IRunnableContext)new ProgressMonitorDialog(this.getShell()));
    }

    private class ModelParentContentProvider
    implements IStructuredContentProvider {
        private ModelParentContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List data;
            if (inputElement != null && (data = WizardHelper.getModelsForModelType((ModelType)((ModelType)inputElement), (boolean)false, (IProgressMonitor)new NullProgressMonitor())) != null) {
                return data.toArray();
            }
            return new Object[0];
        }
    }

    private class ModelParentLabelProvider
    extends LabelProvider {
        private ModelParentLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Model) {
                return ((Model)element).getName();
            }
            return "";
        }
    }
}

