/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaStackTraceHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public JavaStackTraceHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        int lineNumber;
        String typeName;
        try {
            String linkText = this.getLinkText();
            typeName = this.getTypeName(linkText);
            lineNumber = this.getLineNumber(linkText);
        }
        catch (CoreException e1) {
            ErrorDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.JavaStackTraceHyperlink_Error, (String)ConsoleMessages.JavaStackTraceHyperlink_Error, (IStatus)e1.getStatus());
            return;
        }
        if (lineNumber > 0) {
            --lineNumber;
        }
        this.startSourceSearch(typeName, lineNumber);
    }

    protected void startSourceSearch(final String typeName, final int lineNumber) {
        Job search = new Job(ConsoleMessages.JavaStackTraceHyperlink_2){

            protected IStatus run(IProgressMonitor monitor) {
                ILaunch launch = JavaStackTraceHyperlink.this.getLaunch();
                Object result = null;
                try {
                    result = OpenTypeAction.findTypeInWorkspace(typeName, true);
                    if (result == null && launch != null) {
                        result = JavaDebugUtils.resolveSourceElement((Object)JavaDebugUtils.generateSourceName((String)typeName), (ILaunch)JavaStackTraceHyperlink.this.getLaunch());
                    }
                    if (result == null) {
                        result = OpenTypeAction.findTypeInWorkspace(typeName, false);
                    }
                    JavaStackTraceHyperlink.this.searchCompleted(result, typeName, lineNumber, null);
                }
                catch (CoreException e) {
                    JavaStackTraceHyperlink.this.searchCompleted(null, typeName, lineNumber, e.getStatus());
                }
                return Status.OK_STATUS;
            }
        };
        search.schedule();
    }

    protected void searchCompleted(final Object source, final String typeName, final int lineNumber, final IStatus status) {
        UIJob job = new UIJob("link search complete"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (source == null) {
                    if (status == null) {
                        MessageDialog.openInformation((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.JavaStackTraceHyperlink_Information_1, (String)NLS.bind((String)ConsoleMessages.JavaStackTraceHyperlink_Source_not_found_for__0__2, (Object[])new String[]{typeName}));
                    } else {
                        JDIDebugUIPlugin.statusDialog(ConsoleMessages.JavaStackTraceHyperlink_3, status);
                    }
                } else {
                    JavaStackTraceHyperlink.this.processSearchResult(source, typeName, lineNumber);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void processSearchResult(Object source, String typeName, int lineNumber) {
        block5: {
            String editorId;
            IDebugModelPresentation presentation = JDIDebugUIPlugin.getDefault().getModelPresentation();
            IEditorInput editorInput = presentation.getEditorInput(source);
            if (editorInput != null && (editorId = presentation.getEditorId(editorInput, source)) != null) {
                try {
                    IEditorPart editorPart = JDIDebugUIPlugin.getActivePage().openEditor(editorInput, editorId);
                    if (!(editorPart instanceof ITextEditor) || lineNumber < 0) break block5;
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    provider.connect((Object)editorInput);
                    IDocument document = provider.getDocument((Object)editorInput);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        MessageDialog.openInformation((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.JavaStackTraceHyperlink_0, (String)NLS.bind((String)"{0}{1}{2}", (Object[])new String[]{String.valueOf(lineNumber + 1), ConsoleMessages.JavaStackTraceHyperlink_1, typeName}));
                    }
                    provider.disconnect((Object)editorInput);
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.statusDialog(e.getStatus());
                }
            }
        }
    }

    private ILaunch getLaunch() {
        IProcess process = (IProcess)this.getConsole().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
        if (process != null) {
            return process.getLaunch();
        }
        return null;
    }

    protected String getTypeName(String linkText) throws CoreException {
        int start = linkText.indexOf(40);
        int end = linkText.indexOf(58);
        if (start >= 0 && end > start) {
            String typeName = linkText.substring(start + 1, end);
            typeName = JavaCore.removeJavaLikeExtension((String)typeName);
            String qualifier = linkText.substring(0, start);
            if ((start = qualifier.lastIndexOf(46)) >= 0 && (start = new String((String)qualifier.subSequence(0, start)).lastIndexOf(46)) == -1) {
                start = 0;
            }
            if (start >= 0) {
                qualifier = qualifier.substring(0, start);
            }
            if (qualifier.length() > 0) {
                typeName = String.valueOf(qualifier) + "." + typeName;
            }
            return typeName;
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_type_name_from_hyperlink__5, null);
        throw new CoreException((IStatus)status);
    }

    protected int getLineNumber(String linkText) throws CoreException {
        int index = linkText.lastIndexOf(58);
        if (index >= 0) {
            String numText = linkText.substring(index + 1);
            if ((index = numText.indexOf(41)) >= 0) {
                numText = numText.substring(0, index);
            }
            try {
                return Integer.parseInt(numText);
            }
            catch (NumberFormatException e) {
                Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_line_number_from_hyperlink__6, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_line_number_from_hyperlink__6, null);
        throw new CoreException((IStatus)status);
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            int regionOffsetInLine = regionOffset - lineOffset;
            int linkEnd = line.indexOf(41, regionOffsetInLine);
            int linkStart = line.lastIndexOf(32, regionOffsetInLine);
            return line.substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_retrieve_hyperlink_text__8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

