/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class OptionalRequireBundleResolution
extends AbstractManifestMarkerResolution {
    private String fBundleId;

    public OptionalRequireBundleResolution(int type, String bundleId) {
        super(type);
        this.fBundleId = bundleId;
    }

    protected void createChange(BundleModel model) {
        Bundle bundle = (Bundle)model.getBundle();
        RequireBundleHeader header = (RequireBundleHeader)bundle.getManifestHeader("Require-Bundle");
        if (header != null) {
            RequireBundleObject[] required = header.getRequiredBundles();
            int i = 0;
            while (i < required.length) {
                if (this.fBundleId.equals(required[i].getId())) {
                    required[i].setOptional(true);
                }
                ++i;
            }
        }
    }

    public String getDescription() {
        return NLS.bind((String)PDEUIMessages.OptionalRequireBundleResolution_description, (Object)this.fBundleId);
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.OptionalRequireBundleResolution_label, (Object)this.fBundleId);
    }
}

